/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.vaadin.navigator.View;
import com.vaadin.ui.UI;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.apps.CmsAppView;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsEditor;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;

public class CmsFormEditDialogAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "formedit";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.EDIT;

    @Override
    public void executeAction(I_CmsDialogContext context) {
        View view = CmsAppWorkplaceUi.get().getCurrentView();
        if (view instanceof CmsAppView) {
            ((CmsAppView)view).setCacheStatus(CmsAppView.CacheStatus.cacheOnce);
        }
        CmsAppWorkplaceUi.get().showApp(OpenCms.getWorkplaceAppManager().getAppConfiguration("editor"), CmsEditor.getEditState(context.getResources().get(0).getStructureId(), false, UI.getCurrent().getPage().getLocation().toString()));
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        if (resources.size() == 1 && CmsResourceTypeXmlContainerPage.isContainerPage(resources.get(0))) {
            return VISIBILITY.getVisibility(cms, resources);
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_ACTION_OPEN_FORM_EDITOR_0";
    }
}

