/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.CmsComponentState;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;

public class CmsUnusedContentFinderAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "unusedcontentfinder";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.DEFAULT_FOLDERS;

    @Override
    public void executeAction(I_CmsDialogContext context) {
        CmsObject cms = A_CmsUI.getCmsObject();
        CmsResource resource = context.getResources().get(0);
        String site = cms.getRequestContext().getSiteRoot();
        String folder = cms.getRequestContext().getSitePath(resource);
        CmsComponentState stateBean = new CmsComponentState();
        stateBean.setSite(site);
        stateBean.setFolder(folder);
        CmsAppWorkplaceUi.get().showApp("unused-content-finder", stateBean.generateStateString());
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }

    @Override
    protected String getTitleKey() {
        return "GUI_UNUSED_CONTENT_FINDER_0";
    }
}

