/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.components.CmsUploadButton;
import org.opencms.ui.components.CmsUserInfo;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.dialogs.CmsEmbeddedDialogContext;

public class CmsUserInfoDialogAction
extends A_CmsWorkplaceAction {
    public static final String ACTION_ID = "userInfo";

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        CmsUserInfo dialog = new CmsUserInfo(new CmsUploadButton.I_UploadListener(){

            @Override
            public void onUploadFinished(List<String> uploadedFiles) {
                CmsUserInfoDialogAction.this.handleUpload(uploadedFiles, context);
            }
        }, context);
        int top = 55;
        int left = 0;
        if (context.getParameters().get("left") != null) {
            String buttonLeft = context.getParameters().get("left");
            left = Integer.parseInt(buttonLeft) - 290;
        }
        Window window = new Window();
        window.setModal(false);
        window.setClosable(true);
        window.setResizable(false);
        window.setContent((Component)dialog);
        context.setWindow(window);
        window.addStyleName("o-dropdown");
        UI.getCurrent().addWindow(window);
        window.setPosition(left, top);
    }

    @Override
    public String getDialogTitle() {
        return "";
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getTitle(Locale locale) {
        return "";
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        if (context instanceof CmsEmbeddedDialogContext && I_CmsDialogContext.ContextType.appToolbar == context.getContextType()) {
            return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    protected String getTitleKey() {
        return "";
    }

    void handleUpload(List<String> uploadedFiles, I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        boolean success = OpenCms.getWorkplaceAppManager().getUserIconHelper().handleImageUpload(cms, uploadedFiles);
        if (success) {
            context.reload();
        }
    }
}

