/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.apps.CmsAppCategoryNode;
import org.opencms.ui.apps.CmsAppHierarchyPanel;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppButtonProvider;
import org.opencms.ui.apps.I_CmsFolderAppCategory;
import org.opencms.ui.apps.I_CmsHasAppLaunchCommand;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsDefaultAppButtonProvider
implements I_CmsAppButtonProvider {
    public static Component createAppButton(CmsObject cms, final I_CmsWorkplaceAppConfiguration appConfig, Locale locale) {
        Button button = CmsDefaultAppButtonProvider.createAppIconButton(appConfig, locale);
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (appConfig instanceof I_CmsHasAppLaunchCommand && ((I_CmsHasAppLaunchCommand)((Object)appConfig)).getAppLaunchCommand() != null) {
                    ((I_CmsHasAppLaunchCommand)((Object)appConfig)).getAppLaunchCommand().run();
                } else {
                    CmsAppWorkplaceUi ui = (CmsAppWorkplaceUi)A_CmsUI.get();
                    ui.showApp(appConfig);
                }
            }
        });
        CmsAppVisibilityStatus status = appConfig.getVisibility(cms);
        if (!status.isActive()) {
            button.setEnabled(false);
            button.setDescription(status.getHelpText());
        } else {
            String helpText = appConfig.getHelpText(locale);
            button.setDescription(helpText);
        }
        return button;
    }

    public static Component createAppFolderButton(CmsObject cms, final CmsAppCategoryNode node, final Locale locale) {
        Button button = CmsDefaultAppButtonProvider.createAppFolderIconButton((I_CmsFolderAppCategory)node.getCategory(), locale);
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;
            private static final int DEFAULT_WIDTH = 855;
            private static final int DEFAULT_MAX_APP_PER_ROW = 5;
            private static final int MARGIN = 10;

            public void buttonClick(Button.ClickEvent event) {
                CmsAppHierarchyPanel panel = new CmsAppHierarchyPanel(new CmsDefaultAppButtonProvider());
                panel.setCaption("Test caption");
                panel.fill(node, locale);
                Panel realPanel = new Panel();
                realPanel.setContent((Component)panel);
                realPanel.setCaption(((I_CmsFolderAppCategory)node.getCategory()).getName(locale));
                int browtherWidth = A_CmsUI.get().getPage().getBrowserWindowWidth();
                if (node.getAppConfigurations().size() <= 5) {
                    panel.setComponentAlignment(panel.getComponent(0), Alignment.MIDDLE_CENTER);
                }
                if (browtherWidth < 855) {
                    realPanel.setWidth(browtherWidth - 20 + "px");
                } else {
                    realPanel.setWidth("855px");
                }
                Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.content);
                window.setResizable(false);
                window.setContent((Component)realPanel);
                window.setClosable(true);
                window.addStyleName("o-close-on-background");
                window.setModal(true);
                window.setDraggable(false);
                CmsAppWorkplaceUi.get().addWindow(window);
            }
        });
        return button;
    }

    public static Button createAppFolderIconButton(I_CmsFolderAppCategory appCat, Locale locale) {
        return CmsDefaultAppButtonProvider.createIconButton(appCat.getName(locale), appCat.getHelpText(locale), appCat.getIcon(), appCat.getButtonStyle());
    }

    public static Button createAppIconButton(I_CmsWorkplaceAppConfiguration appConfig, Locale locale) {
        return CmsDefaultAppButtonProvider.createIconButton(appConfig.getName(locale), appConfig.getHelpText(locale), appConfig.getIcon(), appConfig.getButtonStyle());
    }

    public static Button createIconButton(String name, String description, Resource icon) {
        return CmsDefaultAppButtonProvider.createIconButton(name, description, icon, "o-image-transparent");
    }

    public static Button createIconButton(String name, String description, Resource icon, String buttonStyle) {
        Button button = new Button(name);
        button.setIcon(icon, name);
        button.setDescription(description);
        button.addStyleName("o-app-button");
        button.addStyleName("borderless");
        button.addStyleName("icon-align-top");
        if (buttonStyle != null) {
            button.addStyleName(buttonStyle);
        }
        if (icon instanceof CmsCssIcon && ((CmsCssIcon)icon).hasAdditionalButtonStyle()) {
            button.addStyleName(((CmsCssIcon)icon).getAdditionalButtonStyle());
        }
        return button;
    }

    @Override
    public Component createAppButton(I_CmsWorkplaceAppConfiguration appConfig) {
        return CmsDefaultAppButtonProvider.createAppButton(A_CmsUI.getCmsObject(), appConfig, UI.getCurrent().getLocale());
    }

    @Override
    public Component createAppFolderButton(CmsAppCategoryNode node) {
        if (node.getAppConfigurations().size() == 1) {
            return CmsDefaultAppButtonProvider.createAppButton(A_CmsUI.getCmsObject(), node.getAppConfigurations().get(0), UI.getCurrent().getLocale());
        }
        return CmsDefaultAppButtonProvider.createAppFolderButton(A_CmsUI.getCmsObject(), node, UI.getCurrent().getLocale());
    }
}

