/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import java.util.Collection;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.CmsFileExplorer;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsFileTable;
import org.opencms.ui.components.CmsFileTableDialogContext;
import org.opencms.util.CmsUUID;

public class CmsExplorerDialogContext
extends CmsFileTableDialogContext {
    private CmsFileExplorer m_explorer;

    public CmsExplorerDialogContext(I_CmsDialogContext.ContextType contextType, CmsFileTable fileTable, CmsFileExplorer explorer, List<CmsResource> resources) {
        super("explorer", contextType, fileTable, resources);
        this.m_explorer = explorer;
    }

    @Override
    public void finish(CmsProject project, String siteRoot) {
        this.finish(null);
        this.m_explorer.onSiteOrProjectChange(project, siteRoot);
    }

    @Override
    public void finish(Collection<CmsUUID> ids) {
        this.closeWindow();
        CmsAppWorkplaceUi.get().enableGlobalShortcuts();
        if (ids != null) {
            this.m_explorer.clearSelection();
            for (CmsUUID id : ids) {
                if (!id.isNullUUID()) continue;
                this.m_explorer.updateAll(false);
                return;
            }
            this.m_explorer.update(ids);
        }
    }

    @Override
    public void focus(CmsUUID cmsUUID) {
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsResource res = cms.readResource(cmsUUID, CmsResourceFilter.ALL);
            String rootPath = res.getRootPath();
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath);
            String sitePath = null;
            if (siteRoot == null) {
                if (OpenCms.getSiteManager().startsWithShared(rootPath)) {
                    siteRoot = OpenCms.getSiteManager().getSharedFolder();
                    sitePath = CmsResource.getParentFolder(rootPath.substring(OpenCms.getSiteManager().getSharedFolder().length()));
                } else {
                    sitePath = CmsResource.getParentFolder(rootPath);
                    siteRoot = "";
                }
            } else {
                CmsObject otherSiteCms = OpenCms.initCmsObject(cms);
                otherSiteCms.getRequestContext().setSiteRoot(siteRoot);
                sitePath = otherSiteCms.getRequestContext().removeSiteRoot(CmsResource.getParentFolder(rootPath));
            }
            this.m_explorer.changeSite(siteRoot, sitePath, true);
        }
        catch (CmsException e) {
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public void updateUserInfo() {
        this.m_explorer.m_appContext.updateUserInfo();
    }
}

