/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;

public class CmsQuickLaunchLocationCache
implements Serializable {
    private static final Log LOG = CmsLog.getLog(CmsQuickLaunchLocationCache.class);
    private static final long serialVersionUID = -6144984854691623070L;
    private Map<String, CmsResource> m_pageEditorResources = new HashMap<String, CmsResource>();
    private Map<String, String> m_sitemapEditorLocations = new HashMap<String, String>();
    private Map<String, String> m_fileExplorerLocations = new HashMap<String, String>();

    public static CmsQuickLaunchLocationCache getLocationCache(HttpSession session) {
        CmsQuickLaunchLocationCache cache = (CmsQuickLaunchLocationCache)session.getAttribute(CmsQuickLaunchLocationCache.class.getName());
        if (cache == null) {
            cache = new CmsQuickLaunchLocationCache();
            session.setAttribute(CmsQuickLaunchLocationCache.class.getName(), (Object)cache);
        }
        return cache;
    }

    public String getFileExplorerLocation(String siteRoot) {
        return this.m_fileExplorerLocations.get(siteRoot);
    }

    public String getPageEditorLocation(CmsObject cms, String siteRoot) {
        CmsResource res = this.m_pageEditorResources.get(siteRoot);
        if (res == null) {
            return null;
        }
        try {
            String sitePath = cms.getSitePath(res);
            cms.readResource(sitePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            return sitePath;
        }
        catch (CmsVfsResourceNotFoundException e) {
            try {
                CmsResource newRes = cms.readResource(res.getStructureId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(newRes.getRootPath());
                if (site == null) {
                    return null;
                }
                if (this.normalizePath(site.getSiteRoot()).equals(this.normalizePath(siteRoot))) {
                    return cms.getSitePath(newRes);
                }
                return null;
            }
            catch (CmsVfsResourceNotFoundException e2) {
                return null;
            }
            catch (CmsException e2) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e2);
                return null;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public CmsResource getPageEditorResource(String siteRoot) {
        return this.m_pageEditorResources.get(siteRoot);
    }

    public String getSitemapEditorLocation(String siteRoot) {
        return this.m_sitemapEditorLocations.get(siteRoot);
    }

    public void setFileExplorerLocation(String siteRoot, String location) {
        this.m_fileExplorerLocations.put(siteRoot, location);
    }

    public void setPageEditorResource(String siteRoot, CmsResource resource) {
        this.m_pageEditorResources.put(siteRoot, resource);
    }

    public void setSitemapEditorLocation(String siteRoot, String location) {
        this.m_sitemapEditorLocations.put(siteRoot, location);
    }

    private String normalizePath(String path) {
        return CmsStringUtil.joinPaths("/", path, "/");
    }
}

