/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Panel;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Iterator;
import java.util.Set;
import org.opencms.flex.CmsFlexCache;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.cacheadmin.CmsCacheViewApp;
import org.opencms.ui.apps.cacheadmin.CmsImageVariationsTable;
import org.opencms.ui.components.CmsBasicDialog;

public class CmsVariationsDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -7346908393288365974L;
    private Button m_cancelButton;
    private FormLayout m_layout;
    private VerticalLayout m_outerlayout;
    private Panel m_panel;

    public CmsVariationsDialog(String resource, final Runnable cancel, CmsCacheViewApp.Mode mode) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -4321889329235244258L;

            public void buttonClick(Button.ClickEvent event) {
                cancel.run();
            }
        });
        Iterator<String> variationsIterator = null;
        if (CmsCacheViewApp.Mode.FlexCache.equals((Object)mode)) {
            CmsFlexCache cache = OpenCms.getFlexCache();
            Set<String> variations = cache.getCachedVariations(resource, A_CmsUI.getCmsObject());
            variationsIterator = variations.iterator();
            this.m_panel.setSizeFull();
            this.m_layout.setHeight("100%");
            this.m_outerlayout.setHeight("100%");
            this.m_layout.addStyleName("v-scrollable");
            while (variationsIterator.hasNext()) {
                this.m_layout.addComponent((Component)new Label(variationsIterator.next()));
            }
        } else {
            this.m_outerlayout.addComponent((Component)new CmsImageVariationsTable(resource));
        }
    }
}

