/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Upload;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.opencms.main.OpenCms;
import org.opencms.ui.apps.dbmanager.A_CmsImportForm;
import org.opencms.ui.apps.dbmanager.CmsImportFile;
import org.opencms.ui.apps.dbmanager.I_CmsReportApp;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsHTTPImportForm
extends A_CmsImportForm {
    private static final long serialVersionUID = 8268966029442189695L;

    public A_CmsHTTPImportForm(I_CmsReportApp app, final String pathToServer, final boolean validate) {
        super(app);
        this.getUpload().setImmediate(true);
        this.getUpload().addStartedListener(new Upload.StartedListener(){
            private static final long serialVersionUID = -1167851886739855757L;

            public void uploadStarted(Upload.StartedEvent event) {
                A_CmsHTTPImportForm.this.getOkButton().setEnabled(false);
                A_CmsHTTPImportForm.this.getSiteSelector().setEnabled(true);
                String name = event.getFilename();
                name = A_CmsHTTPImportForm.this.processFileName(name);
                A_CmsHTTPImportForm.this.getUploadLabel().setValue(name);
            }
        });
        this.getUpload().addChangeListener(new Upload.ChangeListener(){
            private static final long serialVersionUID = -8531203923548531981L;

            public void filenameChanged(Upload.ChangeEvent event) {
                A_CmsHTTPImportForm.this.getOkButton().setEnabled(false);
                A_CmsHTTPImportForm.this.getSiteSelector().setEnabled(true);
                String name = A_CmsHTTPImportForm.this.processFileName(event.getFilename());
                A_CmsHTTPImportForm.this.getUploadLabel().setValue(name);
            }
        });
        this.getUpload().setReceiver(new Upload.Receiver(){
            private static final long serialVersionUID = 5860617055589937645L;

            public OutputStream receiveUpload(String filename, String mimeType) {
                String path = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getWebInfRfsPath(), pathToServer, A_CmsHTTPImportForm.this.processFileName(filename));
                File rfsFile = new File(path);
                rfsFile.getParentFile().mkdirs();
                A_CmsHTTPImportForm.this.m_importFile = new CmsImportFile(path);
                try {
                    return new FileOutputStream(A_CmsHTTPImportForm.this.m_importFile.getPath());
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.getUpload().addSucceededListener(new Upload.SucceededListener(){
            private static final long serialVersionUID = 3430913281578577509L;

            public void uploadSucceeded(Upload.SucceededEvent event) {
                if (validate) {
                    A_CmsHTTPImportForm.this.validateModuleFile();
                } else {
                    A_CmsHTTPImportForm.this.getOkButton().setEnabled(true);
                }
            }
        });
    }

    protected abstract Upload getUpload();

    protected abstract Label getUploadLabel();
}

