/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.dbmanager;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.io.FileInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.importexport.CmsVfsImportExportHandler;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.report.CmsReportWidget;
import org.opencms.util.CmsUUID;

public class CmsExportThreadDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 660736768361578208L;
    private static final Log LOG = CmsLog.getLog(CmsExportThreadDialog.class);
    private CmsVfsImportExportHandler m_exportHandler;

    public CmsExportThreadDialog(CmsVfsImportExportHandler exportHandler, A_CmsReportThread thread, final Window window) {
        this.m_exportHandler = exportHandler;
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_DATABASEAPP_EXPORT_THREAD_CAPTION_0", new Object[0]));
        window.setHeight("600px");
        window.center();
        this.setSizeFull();
        CmsReportWidget reportWidget = new CmsReportWidget(thread);
        reportWidget.setHeight("100%");
        String id = "label" + new CmsUUID().getStringValue();
        reportWidget.setId(id);
        reportWidget.setWidth("100%");
        reportWidget.addStyleName("o-sroll-x");
        this.setContent((Component)reportWidget);
        Button button = this.createButtonClose();
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -5567381118325538754L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        if (!exportHandler.getExportParams().isExportAsFiles()) {
            Button download = new Button(CmsVaadinUtils.getMessageText("GUI_BUTTON_DOWNLOAD_0", new Object[0]));
            FileDownloader downloadContext = new FileDownloader(this.getDownloadResource());
            download.setEnabled(false);
            downloadContext.extend((AbstractComponent)download);
            this.addButton((Component)download, true);
            reportWidget.addReportFinishedHandler(() -> {
                int errors = thread.getErrors().size();
                download.setEnabled(errors == 0);
            });
        }
        this.addButton((Component)button, true);
    }

    private Resource getDownloadResource() {
        return new StreamResource((StreamResource.StreamSource & Serializable)() -> {
            try {
                String path = this.m_exportHandler.getExportParams().getPath();
                FileInputStream stream = new FileInputStream(path);
                return stream;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }, CmsResource.getName(this.m_exportHandler.getExportParams().getPath()));
    }
}

