/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.git;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.Closure;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Node;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.module.CmsModuleManager;
import org.opencms.report.CmsPrintStreamReport;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.ui.apps.git.CmsGitConfiguration;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlUtils;
import org.xml.sax.EntityResolver;

public class CmsGitCheckin {
    private static final String DEFAULT_LOGFILE_PATH = OpenCms.getSystemInfo().getWebInfRfsPath() + "logs/git.log";
    private static final String DEFAULT_RFS_PATH = OpenCms.getSystemInfo().getWebInfRfsPath() + "git-scripts/";
    private static final String DEFAULT_CONFIG_FOLDER = DEFAULT_RFS_PATH + "config/";
    private static final String DEFAULT_SCRIPT_FILE = DEFAULT_RFS_PATH + "module-checkin.sh";
    private static final String DEFAULT_CONFIG_FILE = DEFAULT_RFS_PATH + "module-checkin.conf";
    private static final Log LOG = CmsLog.getLog(CmsGitCheckin.class);
    private static final Object STATIC_LOCK = new Object();
    private Boolean m_autoPullAfter;
    private Boolean m_autoPullBefore;
    private Boolean m_autoPush;
    private boolean m_checkout;
    private CmsObject m_cms;
    private String m_commitMessage;
    private Boolean m_copyAndUnzip;
    private Boolean m_commitMode;
    private boolean m_fetchAndResetBeforeImport;
    private PrintStream m_logStream;
    private Collection<String> m_modulesToExport;
    private boolean m_resetHead;
    private boolean m_resetRemoteHead;
    private Boolean m_excludeLibs;
    private String m_gitUserEmail;
    private String m_gitUserName;
    private Boolean m_ignoreUnclean;
    private CmsGitConfiguration m_currentConfiguration;
    private List<CmsGitConfiguration> m_configurations = new LinkedList<CmsGitConfiguration>();

    public CmsGitCheckin(CmsObject cms) {
        this.m_cms = cms;
        this.m_configurations = this.readConfigFiles();
        for (CmsGitConfiguration config : this.m_configurations) {
            if (!config.isValid()) continue;
            this.m_currentConfiguration = config;
            break;
        }
    }

    public static void zipRfsFolder(final File root, OutputStream zipOutput) throws Exception {
        final ZipOutputStream zip = new ZipOutputStream(zipOutput);
        try {
            CmsFileUtil.walkFileSystem(root, new Closure(){

                public void execute(Object stateObj) {
                    try {
                        CmsFileUtil.FileWalkState state = (CmsFileUtil.FileWalkState)stateObj;
                        for (File file : state.getFiles()) {
                            String relativePath = Paths.get(root.getAbsolutePath(), new String[0]).relativize(Paths.get(file.getAbsolutePath(), new String[0])).toString();
                            ZipEntry entry = new ZipEntry(relativePath);
                            entry.setTime(file.lastModified());
                            zip.putNextEntry(entry);
                            zip.write(CmsFileUtil.readFully(new FileInputStream(file)));
                            zip.closeEntry();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        zip.flush();
        zip.close();
    }

    public void addModuleToExport(String moduleName) {
        if (this.m_modulesToExport == null) {
            this.m_modulesToExport = new HashSet<String>();
        }
        this.m_modulesToExport.add(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkIn() {
        try {
            Object object = STATIC_LOCK;
            synchronized (object) {
                this.m_logStream = new PrintStream(new FileOutputStream(DEFAULT_LOGFILE_PATH, false));
                CmsObject cms = this.getCmsObject();
                if (cms != null) {
                    return this.checkInInternal();
                }
                this.m_logStream.println("No CmsObject given. Did you call init() first?");
                return -1;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -2;
        }
    }

    public void clearModules() {
        if (this.m_modulesToExport != null) {
            this.m_modulesToExport.clear();
        }
    }

    public boolean getCheckout() {
        return this.m_checkout;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public String getCommitMessage() {
        return this.m_commitMessage;
    }

    public Collection<CmsGitConfiguration> getConfigurations() {
        return this.m_configurations;
    }

    public CmsGitConfiguration getCurrentConfiguration() {
        return this.m_currentConfiguration;
    }

    public String getGitUserEmail() {
        return this.m_gitUserEmail;
    }

    public String getGitUserName() {
        return this.m_gitUserName;
    }

    public Collection<String> getInstalledModules() {
        return OpenCms.getModuleManager().getModuleNames();
    }

    public String getLogFilePath() {
        return DEFAULT_LOGFILE_PATH;
    }

    public String getLogText() {
        try {
            String logFilePath = this.getLogFilePath();
            byte[] logData = CmsFileUtil.readFully(new FileInputStream(logFilePath));
            return new String(logData, "UTF-8");
        }
        catch (IOException e) {
            return "Error reading log file: " + this.getLogFilePath();
        }
    }

    public boolean hasValidConfiguration() {
        return !this.m_configurations.isEmpty();
    }

    public boolean isFetchAndResetBeforeImport() {
        return this.m_fetchAndResetBeforeImport;
    }

    public boolean isModuleInstalled(String moduleName) {
        return OpenCms.getModuleManager().getModule(moduleName) != null;
    }

    public void setCheckout(boolean checkout) {
        this.m_checkout = checkout;
    }

    public void setCommit(boolean autoCommit) {
        this.m_commitMode = autoCommit;
    }

    public void setCommitMessage(String message) {
        this.m_commitMessage = message;
    }

    public void setCopyAndUnzip(boolean copyAndUnzip) {
        this.m_copyAndUnzip = copyAndUnzip;
    }

    public boolean setCurrentConfiguration(CmsGitConfiguration configuration) {
        if (null != configuration && configuration.isValid()) {
            this.m_currentConfiguration = configuration;
            return true;
        }
        return false;
    }

    public void setExcludeLibs(boolean excludeLibs) {
        this.m_excludeLibs = excludeLibs;
    }

    public void setFetchAndResetBeforeImport(boolean fetchAndReset) {
        this.m_fetchAndResetBeforeImport = fetchAndReset;
    }

    public void setGitUserEmail(String useremail) {
        this.m_gitUserEmail = useremail;
    }

    public void setGitUserName(String username) {
        this.m_gitUserName = username;
    }

    public void setIgnoreUnclean(boolean ignore) {
        this.m_ignoreUnclean = ignore;
    }

    public void setPullAfter(boolean autoPull) {
        this.m_autoPullAfter = autoPull;
    }

    public void setPullBefore(boolean autoPull) {
        this.m_autoPullBefore = autoPull;
    }

    public void setPush(boolean autoPush) {
        this.m_autoPush = autoPush;
    }

    public void setResetHead(boolean reset) {
        this.m_resetHead = reset;
    }

    public void setResetRemoteHead(boolean reset) {
        this.m_resetRemoteHead = reset;
    }

    private void addConfigurationIfValid(Collection<CmsGitConfiguration> configurations, File configFile) {
        block4: {
            CmsGitConfiguration config = null;
            try {
                if (!configFile.isFile()) break block4;
                config = new CmsGitConfiguration(configFile);
                if (config.isValid()) {
                    configurations.add(config);
                    break block4;
                }
                throw new Exception("Could not read git configuration file" + config.getConfigurationFile().getAbsolutePath());
            }
            catch (NullPointerException npe) {
                LOG.error((Object)"Could not read git configuration.", (Throwable)npe);
            }
            catch (Exception e) {
                String file = null != config && null != config.getConfigurationFile() && null != config.getConfigurationFile().getAbsolutePath() ? config.getConfigurationFile().getAbsolutePath() : "<unknown>";
                LOG.warn((Object)("Trying to read invalid git configuration from " + file + "."), (Throwable)e);
            }
        }
    }

    private int checkInInternal() {
        boolean importOk;
        this.m_logStream.println("[" + new Date() + "] STARTING Git task");
        this.m_logStream.println("=========================");
        this.m_logStream.println();
        if (this.m_checkout) {
            this.m_logStream.println("Running checkout script");
        } else if (!this.m_resetHead && !this.m_resetRemoteHead) {
            this.m_logStream.println("Exporting relevant modules");
            this.m_logStream.println("--------------------------");
            this.m_logStream.println();
            this.exportModules();
            this.m_logStream.println();
            this.m_logStream.println("Calling script to check in the exports");
            this.m_logStream.println("--------------------------------------");
            this.m_logStream.println();
        } else {
            this.m_logStream.println();
            this.m_logStream.println("Calling script to reset the repository");
            this.m_logStream.println("--------------------------------------");
            this.m_logStream.println();
        }
        int exitCode = this.runCommitScript();
        if (exitCode != 0) {
            this.m_logStream.println();
            this.m_logStream.println("ERROR: Something went wrong. The script got exitcode " + exitCode + ".");
            this.m_logStream.println();
        }
        if (exitCode == 0 && this.m_checkout && !(importOk = this.importModules())) {
            return -1;
        }
        this.m_logStream.println("[" + new Date() + "] FINISHED Git task");
        this.m_logStream.println();
        this.m_logStream.close();
        return exitCode;
    }

    private String checkinScriptCommand() {
        String exportModules = "";
        if (this.m_modulesToExport != null && !this.m_modulesToExport.isEmpty()) {
            StringBuffer exportModulesParam = new StringBuffer();
            for (String moduleName : this.m_modulesToExport) {
                exportModulesParam.append(" ").append(moduleName);
            }
            exportModulesParam.replace(0, 1, " \"");
            exportModulesParam.append("\" ");
            exportModules = " --modules " + exportModulesParam.toString();
        }
        String commitMessage = "";
        if (this.m_commitMessage != null) {
            commitMessage = " -msg \"" + this.m_commitMessage.replace("\"", "\\\"") + "\"";
        }
        String gitUserName = "";
        if (this.m_gitUserName != null) {
            gitUserName = this.m_gitUserName.trim().isEmpty() ? " --ignore-default-git-user-name" : " --git-user-name \"" + this.m_gitUserName + "\"";
        }
        String gitUserEmail = "";
        if (this.m_gitUserEmail != null) {
            gitUserEmail = this.m_gitUserEmail.trim().isEmpty() ? " --ignore-default-git-user-email" : " --git-user-email \"" + this.m_gitUserEmail + "\"";
        }
        String autoPullBefore = "";
        if (this.m_autoPullBefore != null) {
            autoPullBefore = this.m_autoPullBefore != false ? " --pull-before " : " --no-pull-before";
        }
        String autoPullAfter = "";
        if (this.m_autoPullAfter != null) {
            autoPullAfter = this.m_autoPullAfter != false ? " --pull-after " : " --no-pull-after";
        }
        String autoPush = "";
        if (this.m_autoPush != null) {
            autoPush = this.m_autoPush != false ? " --push " : " --no-push";
        }
        String exportFolder = " --export-folder \"" + this.m_currentConfiguration.getModuleExportPath() + "\"";
        String exportMode = " --export-mode " + this.m_currentConfiguration.getExportMode();
        String excludeLibs = "";
        if (this.m_excludeLibs != null) {
            excludeLibs = this.m_excludeLibs != false ? " --exclude-libs" : " --no-exclude-libs";
        }
        String commitMode = "";
        if (this.m_commitMode != null) {
            commitMode = this.m_commitMode != false ? " --commit" : " --no-commit";
        }
        String ignoreUncleanMode = "";
        if (this.m_ignoreUnclean != null) {
            ignoreUncleanMode = this.m_ignoreUnclean != false ? " --ignore-unclean" : " --no-ignore-unclean";
        }
        String copyAndUnzip = "";
        if (this.m_copyAndUnzip != null) {
            copyAndUnzip = this.m_copyAndUnzip != false ? " --copy-and-unzip" : " --no-copy-and-unzip";
        }
        String configFilePath = this.m_currentConfiguration.getFilePath();
        return "\"" + DEFAULT_SCRIPT_FILE + "\"" + exportModules + commitMessage + gitUserName + gitUserEmail + autoPullBefore + autoPullAfter + autoPush + exportFolder + exportMode + excludeLibs + commitMode + ignoreUncleanMode + copyAndUnzip + " \"" + configFilePath + "\"";
    }

    private String checkoutScriptCommand() {
        String configFilePath = this.m_currentConfiguration.getFilePath();
        return "\"" + DEFAULT_SCRIPT_FILE + "\" --checkout  \"" + configFilePath + "\"";
    }

    private void exportModules() {
        if (null != this.m_copyAndUnzip && !this.m_copyAndUnzip.booleanValue() || null == this.m_copyAndUnzip && !this.m_currentConfiguration.getDefaultCopyAndUnzip()) {
            this.m_logStream.println();
            this.m_logStream.println("NOT EXPORTING MODULES - you disabled copy and unzip.");
            this.m_logStream.println();
            return;
        }
        CmsModuleManager moduleManager = OpenCms.getModuleManager();
        Collection<String> modulesToExport = this.m_modulesToExport == null || this.m_modulesToExport.isEmpty() ? this.m_currentConfiguration.getConfiguredModules() : this.m_modulesToExport;
        for (String moduleName : modulesToExport) {
            CmsModule module = moduleManager.getModule(moduleName);
            if (module == null) continue;
            CmsModuleImportExportHandler handler = CmsModuleImportExportHandler.getExportHandler(this.getCmsObject(), module, "Git export handler");
            try {
                handler.exportData(this.getCmsObject(), new CmsPrintStreamReport(this.m_logStream, OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()), false));
            }
            catch (CmsConfigurationException | CmsImportExportException | CmsRoleViolationException e) {
                e.printStackTrace(this.m_logStream);
            }
        }
    }

    private boolean importModule(File file) throws CmsException {
        this.m_logStream.println("Trying to import module from " + file.getAbsolutePath());
        CmsPrintStreamReport report = new CmsPrintStreamReport(this.m_logStream, OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()), false);
        OpenCms.getModuleManager().replaceModule(this.m_cms, file.getAbsolutePath(), report);
        file.delete();
        if (report.hasError() || report.hasWarning()) {
            this.m_logStream.println("Import failed, see opencms.log for details");
            return false;
        }
        return true;
    }

    private boolean importModules() {
        boolean result = true;
        try {
            this.m_logStream.println("Checking module dependencies.");
            HashMultimap dependencies = HashMultimap.create();
            HashSet unsortedModules = Sets.newHashSet(this.m_modulesToExport);
            for (String module : this.m_modulesToExport) {
                String manifestPath = CmsStringUtil.joinPaths(this.m_currentConfiguration.getModulesPath(), module, this.m_currentConfiguration.getResourcesSubFolder(), "manifest.xml");
                Document doc = CmsXmlUtils.unmarshalHelper(CmsFileUtil.readFully(new FileInputStream(manifestPath)), (EntityResolver)new CmsXmlEntityResolver(null));
                List depNodes = doc.getRootElement().selectNodes("//dependencies/dependency/@name");
                for (Object nodeObj : depNodes) {
                    Node node = (Node)nodeObj;
                    String dependency = node.getText();
                    if (!this.m_modulesToExport.contains(dependency)) continue;
                    dependencies.put((Object)module, (Object)dependency);
                }
            }
            ArrayList sortedModules = Lists.newArrayList();
            for (int i = 0; i < this.m_modulesToExport.size(); ++i) {
                String nextModule = null;
                for (String key : unsortedModules) {
                    if (!dependencies.get((Object)key).isEmpty()) continue;
                    nextModule = key;
                    break;
                }
                if (nextModule == null) continue;
                sortedModules.add(nextModule);
                unsortedModules.remove(nextModule);
                for (String key : Sets.newHashSet((Iterable)dependencies.keySet())) {
                    dependencies.get((Object)key).remove(nextModule);
                }
            }
            this.m_logStream.println("Modules sorted by dependencies: " + sortedModules);
            for (String moduleName : sortedModules) {
                String dir = CmsStringUtil.joinPaths(this.m_currentConfiguration.getModulesPath(), moduleName, this.m_currentConfiguration.getResourcesSubFolder());
                File dirEntry = new File(dir);
                if (!dirEntry.exists()) continue;
                try {
                    this.m_logStream.println("Creating temp file for module " + moduleName);
                    File outputFile = File.createTempFile(moduleName + "-", ".zip");
                    FileOutputStream fos = new FileOutputStream(outputFile);
                    this.m_logStream.println("Zipping module structure to " + outputFile.getAbsolutePath());
                    CmsGitCheckin.zipRfsFolder(dirEntry, fos);
                    result &= this.importModule(outputFile);
                    outputFile.delete();
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    e.printStackTrace(this.m_logStream);
                    result = false;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_logStream.println("Unable to check dependencies for modules, giving up.");
            e.printStackTrace(this.m_logStream);
            result = false;
        }
        return result;
    }

    private List<CmsGitConfiguration> readConfigFiles() {
        LinkedList<CmsGitConfiguration> configurations = new LinkedList<CmsGitConfiguration>();
        this.addConfigurationIfValid(configurations, new File(DEFAULT_CONFIG_FILE));
        File configFolder = new File(DEFAULT_CONFIG_FOLDER);
        if (configFolder.isDirectory()) {
            for (File configFile : configFolder.listFiles()) {
                this.addConfigurationIfValid(configurations, configFile);
            }
        }
        return configurations;
    }

    private String resetHeadScriptCommand() {
        String configFilePath = this.m_currentConfiguration.getFilePath();
        return "\"" + DEFAULT_SCRIPT_FILE + "\" --reset-head \"" + configFilePath + "\"";
    }

    private String resetRemoteHeadScriptCommand() {
        String configFilePath = this.m_currentConfiguration.getFilePath();
        return "\"" + DEFAULT_SCRIPT_FILE + "\" --reset-remote-head \"" + configFilePath + "\"";
    }

    private int runCommitScript() {
        if (this.m_checkout && !this.m_fetchAndResetBeforeImport) {
            this.m_logStream.println("Skipping script....");
            return 0;
        }
        try {
            this.m_logStream.flush();
            String commandParam = this.m_resetRemoteHead ? this.resetRemoteHeadScriptCommand() : (this.m_resetHead ? this.resetHeadScriptCommand() : (this.m_checkout ? this.checkoutScriptCommand() : this.checkinScriptCommand()));
            String[] cmd = new String[]{"bash", "-c", commandParam};
            this.m_logStream.println("Calling the script as follows:");
            this.m_logStream.println();
            this.m_logStream.println(cmd[0] + " " + cmd[1] + " " + cmd[2]);
            ProcessBuilder builder = new ProcessBuilder(cmd);
            this.m_logStream.close();
            this.m_logStream = null;
            ProcessBuilder.Redirect redirect = ProcessBuilder.Redirect.appendTo(new File(DEFAULT_LOGFILE_PATH));
            builder.redirectOutput(redirect);
            builder.redirectError(redirect);
            Process scriptProcess = builder.start();
            int exitCode = scriptProcess.waitFor();
            scriptProcess.getOutputStream().close();
            this.m_logStream = new PrintStream(new FileOutputStream(DEFAULT_LOGFILE_PATH, true));
            return exitCode;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(this.m_logStream);
            return -1;
        }
    }
}

