/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.git;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;

public class CmsGitConfiguration {
    private static final String SYSTEM_MODULE_EXPORTPATH = OpenCms.getSystemInfo().getPackagesRfsPath() + CmsSystemInfo.FOLDER_MODULES;
    private static final String DEFAULT_COMMIT_MESSAGE = "COMMIT_MESSAGE";
    private static final String DEFAULT_COMMIT_MODE = "GIT_COMMIT";
    private static final String DEFAULT_COPY_AND_UNZIP = "COPY_AND_UNZIP";
    private static final String DEFAULT_EXCLUDE_LIBS = "DEFAULT_EXCLUDE_LIBS";
    private static final String DEFAULT_EXPORT_MODE = "MODULE_EXPORT_MODE";
    private static final String DEFAULT_GIT_USER_EMAIL = "GIT_USER_EMAIL";
    private static final String DEFAULT_GIT_USER_NAME = "GIT_USER_NAME";
    private static final String DEFAULT_IGNORE_UNCLEAN = "GIT_IGNORE_UNCLEAN";
    private static final String DEFAULT_MODULE_EXPORT_PATH = "MODULE_EXPORT_FOLDER";
    private static final String DEFAULT_MODULES_TO_EXPORT = "DEFAULT_MODULES_TO_EXPORT";
    private static final String DEFAULT_PULL_MODE_AFTER = "GIT_PULL_AFTER";
    private static final String DEFAULT_PULL_MODE_BEFORE = "GIT_PULL_BEFORE";
    private static final String DEFAULT_PUSH_MODE = "GIT_PUSH";
    private static final String DEFAULT_REPOSITORY_PATH = "REPOSITORY_HOME";
    private static final String DEFAULT_MODULE_RESOURCES_SUBFOLDER = "MODULE_RESOURCES_SUBFOLDER";
    private static final String DEFAULT_MODULE_PATH = "MODULE_PATH";
    private String m_defaultCommitMessage = "Autocommit of exported modules.";
    private boolean m_defaultCommitMode;
    private boolean m_defaultCopyAndUnzip;
    private boolean m_defaultExcludeLibs;
    private int m_defaultExportMode;
    private String m_defaultGitUserEmail;
    private String m_defaultGitUserName;
    private boolean m_defaultIgnoreUnclean;
    private String m_defaultModuleExportPath = "";
    private boolean m_defaultPullModeAfter;
    private boolean m_defaultPullModeBefore;
    private boolean m_defaultPushMode;
    private Collection<String> m_configuredModules = new ArrayList<String>();
    private String m_modulesPath;
    private String m_resourcesSubfolder;
    private String m_repositoryPath = "";
    private boolean m_isValid;
    private File m_configFile;

    CmsGitConfiguration(File configFile) {
        this.m_configFile = configFile;
        this.readConfigFile();
    }

    public File getConfigurationFile() {
        return this.m_configFile;
    }

    public Collection<String> getConfiguredModules() {
        return this.m_configuredModules;
    }

    public boolean getDefaultAutoCommit() {
        return this.m_defaultCommitMode;
    }

    public boolean getDefaultAutoPullAfter() {
        return this.m_defaultPullModeAfter;
    }

    public boolean getDefaultAutoPullBefore() {
        return this.m_defaultPullModeBefore;
    }

    public boolean getDefaultAutoPush() {
        return this.m_defaultPushMode;
    }

    public String getDefaultCommitMessage() {
        return this.m_defaultCommitMessage;
    }

    public boolean getDefaultCopyAndUnzip() {
        return this.m_defaultCopyAndUnzip;
    }

    public boolean getDefaultExcludeLibs() {
        return this.m_defaultExcludeLibs;
    }

    public String getDefaultGitUserEmail() {
        return this.m_defaultGitUserEmail;
    }

    public String getDefaultGitUserName() {
        return this.m_defaultGitUserName;
    }

    public boolean getDefaultIngoreUnclean() {
        return this.m_defaultIgnoreUnclean;
    }

    public int getExportMode() {
        return this.m_defaultModuleExportPath.isEmpty() ? 1 : this.m_defaultExportMode;
    }

    public String getFilePath() {
        if (null != this.m_configFile) {
            return this.m_configFile.getAbsolutePath();
        }
        return null;
    }

    public String getModuleExportPath() {
        return this.m_defaultModuleExportPath.isEmpty() ? SYSTEM_MODULE_EXPORTPATH : this.m_defaultModuleExportPath;
    }

    public String getModulesPath() {
        return this.m_modulesPath;
    }

    public String getName() {
        if (null != this.m_configFile && null != this.m_configFile.getName()) {
            return this.m_configFile.getName();
        }
        return "<invalid configuration>";
    }

    public String getRepositoryPath() {
        return this.m_repositoryPath;
    }

    public String getResourcesSubFolder() {
        return this.m_resourcesSubfolder;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    private String getValueFromProp(String propValue) {
        String value = propValue;
        if ((value = value.trim()).startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private void readConfigFile() {
        this.m_isValid = false;
        if (null != this.m_configFile && this.m_configFile.exists() && this.m_configFile.canRead()) {
            Properties props = new Properties();
            try (FileInputStream input = new FileInputStream(this.m_configFile);){
                props.load(input);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String value;
                    String key = (String)entry.getKey();
                    String propValue = (String)entry.getValue();
                    if (key.equals(DEFAULT_MODULES_TO_EXPORT)) {
                        value = this.getValueFromProp(propValue).trim();
                        this.m_configuredModules = value.contains(",") ? Arrays.asList(value.split(" *, *")) : Arrays.asList(value.split(" +"));
                    }
                    if (key.equals(DEFAULT_MODULE_PATH)) {
                        this.m_modulesPath = this.getValueFromProp(propValue).trim();
                    }
                    if (key.equals(DEFAULT_MODULE_RESOURCES_SUBFOLDER)) {
                        this.m_resourcesSubfolder = this.getValueFromProp(propValue).trim();
                    }
                    if (key.equals(DEFAULT_PULL_MODE_BEFORE)) {
                        value = this.getValueFromProp(propValue);
                        if ((value = value.trim()).equals("1")) {
                            this.m_defaultPullModeBefore = true;
                        }
                    }
                    if (key.equals(DEFAULT_PULL_MODE_AFTER)) {
                        value = this.getValueFromProp(propValue);
                        if ((value = value.trim()).equals("1")) {
                            this.m_defaultPullModeAfter = true;
                        }
                    }
                    if (key.equals(DEFAULT_PUSH_MODE)) {
                        value = this.getValueFromProp(propValue);
                        if ((value = value.trim()).equals("1")) {
                            this.m_defaultPushMode = true;
                        }
                    }
                    if (key.equals(DEFAULT_MODULE_EXPORT_PATH)) {
                        value = this.getValueFromProp(propValue);
                        this.m_defaultModuleExportPath = value.trim();
                    }
                    if (key.equals(DEFAULT_REPOSITORY_PATH)) {
                        value = this.getValueFromProp(propValue);
                        this.m_repositoryPath = value.trim();
                    }
                    if (key.equals(DEFAULT_EXPORT_MODE)) {
                        value = this.getValueFromProp(propValue);
                        int n = this.m_defaultExportMode = value.trim().equals("1") ? 1 : 0;
                    }
                    if (key.equals(DEFAULT_COMMIT_MESSAGE)) {
                        this.m_defaultCommitMessage = value = this.getValueFromProp(propValue);
                    }
                    if (key.equals(DEFAULT_GIT_USER_NAME)) {
                        this.m_defaultGitUserName = value = this.getValueFromProp(propValue);
                    }
                    if (key.equals(DEFAULT_GIT_USER_EMAIL)) {
                        this.m_defaultGitUserEmail = value = this.getValueFromProp(propValue);
                    }
                    if (key.equals(DEFAULT_EXCLUDE_LIBS)) {
                        value = this.getValueFromProp(propValue);
                        boolean bl = this.m_defaultExcludeLibs = value.trim().equals("1");
                    }
                    if (key.equals(DEFAULT_COMMIT_MODE)) {
                        value = this.getValueFromProp(propValue);
                        boolean bl = this.m_defaultCommitMode = value.trim().equals("1");
                    }
                    if (key.equals(DEFAULT_IGNORE_UNCLEAN)) {
                        value = this.getValueFromProp(propValue);
                        boolean bl = this.m_defaultIgnoreUnclean = value.trim().equals("1");
                    }
                    if (!key.equals(DEFAULT_COPY_AND_UNZIP)) continue;
                    value = this.getValueFromProp(propValue);
                    this.m_defaultCopyAndUnzip = value.trim().equals("1");
                }
                this.m_isValid = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

