/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.linkvalidation;

import com.google.common.base.Supplier;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.linkvalidation.I_CmsUpdatableComponent;
import org.opencms.ui.components.editablegroup.CmsEditableGroup;
import org.opencms.ui.components.editablegroup.I_CmsEditableGroupRow;
import org.opencms.ui.components.fileselect.CmsPathSelectField;

public class CmsInternalResources
extends VerticalLayout {
    private static final long serialVersionUID = 6880701403593873461L;
    CmsEditableGroup m_resourcesGroup;
    Button m_okButton;
    VerticalLayout m_resources;

    public CmsInternalResources(final I_CmsUpdatableComponent table) {
        this.setHeightUndefined();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -5668840121832993312L;

            public void buttonClick(Button.ClickEvent event) {
                table.update(CmsInternalResources.this.getResources());
            }
        });
        this.m_resourcesGroup = new CmsEditableGroup((AbstractOrderedLayout)this.m_resources, new Supplier<Component>(){

            public Component get() {
                return CmsInternalResources.this.getResourceComponent(null);
            }
        }, CmsVaadinUtils.getMessageText("GUI_LINKVALIDATION_LINKS_ADDRESOURCES_0", new Object[0]));
        this.m_resourcesGroup.init();
        this.m_resourcesGroup.addRow(this.getResourceComponent(null));
    }

    public void addResource(String resource) {
        this.m_resourcesGroup.addRow(this.getResourceComponent(resource));
    }

    public void clearResources() {
        for (I_CmsEditableGroupRow row : this.m_resourcesGroup.getRows()) {
            this.m_resourcesGroup.remove(row);
        }
    }

    public List<String> getResources() {
        ArrayList<String> res = new ArrayList<String>();
        for (I_CmsEditableGroupRow row : this.m_resourcesGroup.getRows()) {
            res.add(((CmsPathSelectField)row.getComponent()).getValue());
        }
        return res;
    }

    protected Component getResourceComponent(String path) {
        try {
            CmsPathSelectField field = new CmsPathSelectField();
            field.setUseRootPaths(true);
            CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            field.setCmsObject(cms);
            if (path != null) {
                field.setValue(path);
            }
            return field;
        }
        catch (CmsException cmsException) {
            return null;
        }
    }

    void addEmptyPathFieldToLayout(String defaultValue) {
        this.m_resourcesGroup.addRow(this.getResourceComponent(defaultValue));
    }
}

