/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.logfile;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.logfile.CmsLogFileApp;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.util.CmsStringUtil;

public class CmsLogChannelTable
extends Table {
    public static final String LOGCHANGES_NAME = "logchanges";
    private static final Log LOGCHANGES = CmsLog.getLog("logchanges");
    private static final long serialVersionUID = 5467369614234190999L;
    private IndexedContainer m_container;
    private CmsContextMenu m_menu;
    private CmsLogFileApp m_app;

    protected CmsLogChannelTable(CmsLogFileApp app) {
        this.m_app = app;
        this.m_container = new IndexedContainer();
        this.setContainerDataSource((Container)this.m_container);
        for (TableColumn prop : TableColumn.values()) {
            this.m_container.addContainerProperty((Object)prop, prop.getType(), prop.getDefaultValue());
            this.setColumnHeader((Object)prop, prop.getLocalizedMessage());
        }
        this.setVisibleColumns(new Object[]{TableColumn.Level, TableColumn.Channel, TableColumn.ParentChannel, TableColumn.File});
        this.setItemIconPropertyId((Object)TableColumn.Icon);
        this.setColumnWidth(null, 40);
        this.setRowHeaderMode(Table.RowHeaderMode.ICON_ONLY);
        this.setColumnWidth((Object)TableColumn.Level, 80);
        this.setSelectable(true);
        this.setMultiSelect(true);
        this.m_menu = new CmsContextMenu();
        this.m_menu.setAsTableContextMenu(this);
        this.addItemClickListener(new ItemClickEvent.ItemClickListener(){
            private static final long serialVersionUID = 1L;

            public void itemClick(ItemClickEvent event) {
                CmsLogChannelTable.this.onItemClick((MouseEvents.ClickEvent)event, event.getItemId(), event.getPropertyId());
            }
        });
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 1L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                if (TableColumn.Channel.equals(propertyId)) {
                    return " o-hover-column";
                }
                if (TableColumn.Level.equals(propertyId)) {
                    return ((LoggerLevel)((Object)source.getItem(itemId).getItemProperty(propertyId).getValue())).getCssClass();
                }
                return null;
            }
        });
        this.addGeneratedColumn((Object)TableColumn.Level, new LevelIcon());
        this.fillTable();
    }

    public void addItemForLogger(Logger logger) {
        Item item = this.m_container.addItem((Object)logger);
        if (item != null) {
            item.getItemProperty((Object)TableColumn.Channel).setValue((Object)logger.getName());
            String parentChannelName = this.getParentLogChannelName(logger);
            item.getItemProperty((Object)TableColumn.ParentChannel).setValue((Object)(parentChannelName != null ? parentChannelName : "none"));
            item.getItemProperty((Object)TableColumn.File).setValue((Object)this.m_app.getLogFile(logger));
            item.getItemProperty((Object)TableColumn.Level).setValue((Object)LoggerLevel.fromLogger(logger));
        }
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)TableColumn.Channel, search, true, false), new SimpleStringFilter((Object)TableColumn.ParentChannel, search, true, false), new SimpleStringFilter((Object)TableColumn.File, search, true, false)}));
        }
        if (this.getValue() != null & !((Set)this.getValue()).isEmpty()) {
            this.setCurrentPageFirstItemId(((Set)this.getValue()).iterator().next());
        }
    }

    protected void toggleOwnFile(Logger logchannel) {
        this.m_app.toggleOwnFileForLogger(logchannel);
        this.m_app.updateTable();
    }

    void changeLoggerLevel(LoggerLevel clickedLevel, Set<Logger> clickedLogger) {
        for (Logger logger : clickedLogger) {
            this.logLogLevelChange(logger, clickedLevel.getLevel());
            logger.setLevel(clickedLevel.getLevel());
            this.m_app.writeElement(logger);
        }
        this.m_app.updateTable();
    }

    void onItemClick(MouseEvents.ClickEvent event, Object itemId, Object propertyId) {
        if (!event.isCtrlKey() && !event.isShiftKey()) {
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.LEFT)) {
                this.setValue(null);
            }
            this.changeValueIfNotMultiSelect(itemId);
            if (event.getButton().equals((Object)MouseEventDetails.MouseButton.RIGHT) || propertyId == null) {
                this.m_menu.removeAllItems();
                this.fillContextMenu((Set)this.getValue());
                this.m_menu.openForTable(event, itemId, propertyId, this);
            }
        }
    }

    private void changeValueIfNotMultiSelect(Object itemId) {
        Set value = (Set)this.getValue();
        if (value == null) {
            this.select(itemId);
        } else if (!value.contains(itemId)) {
            this.setValue(null);
            this.select(itemId);
        }
    }

    private void fillContextMenu(final Set<Logger> loggerSet) {
        LoggerLevel[] loggerLevelArray = LoggerLevel.values();
        int n = loggerLevelArray.length;
        for (int i = 0; i < n; ++i) {
            LoggerLevel level;
            final LoggerLevel currentLevel = level = loggerLevelArray[i];
            CmsContextMenu.ContextMenuItem item = this.m_menu.addItem(level.getLevelStringComplet());
            item.setData(loggerSet);
            item.addItemClickListener(new CmsContextMenu.ContextMenuItemClickListener(){

                @Override
                public void contextMenuItemClicked(CmsContextMenu.ContextMenuItemClickEvent event) {
                    CmsLogChannelTable.this.changeLoggerLevel(currentLevel, loggerSet);
                }
            });
            if (loggerSet.size() != 1 || !level.getLevel().equals((Object)loggerSet.iterator().next().getLevel())) continue;
            item.setIcon((Resource)FontOpenCms.CHECK_SMALL);
        }
        if (loggerSet.size() == 1) {
            String message = CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_NEWFILE_0", new Object[0]);
            if (CmsLogFileApp.isloggingactivated(loggerSet.iterator().next())) {
                message = CmsVaadinUtils.getMessageText("GUI_LOGFILE_LOGSETTINGS_REMOVEFILE_0", new Object[0]);
            }
            CmsContextMenu.ContextMenuItem item = this.m_menu.addItem(message);
            item.setData(loggerSet);
            item.addItemClickListener(new CmsContextMenu.ContextMenuItemClickListener(){

                @Override
                public void contextMenuItemClicked(CmsContextMenu.ContextMenuItemClickEvent event) {
                    CmsLogChannelTable.this.toggleOwnFile((Logger)loggerSet.iterator().next());
                }
            });
        }
    }

    private void fillTable() {
        this.removeAllItems();
        for (Logger logger : this.m_app.getAllElements()) {
            this.addItemForLogger(logger);
        }
    }

    private String getParentLogChannelName(Logger logger) {
        LoggerConfig parentConfig = null;
        parentConfig = logger.getName().equals(logger.get().getName()) ? logger.get().getParent() : logger.get();
        return parentConfig != null ? parentConfig.getName() : null;
    }

    private void log(String message) {
        String user = A_CmsUI.getCmsObject().getRequestContext().getCurrentUser().getName();
        LOGCHANGES.info((Object)("[User: " + user + "] " + message));
    }

    private void logLogLevelChange(Logger logger, Level newLevel) {
        String oldLevelDesc = null;
        LoggerConfig config = logger.get();
        oldLevelDesc = logger.getName().equals(config.getName()) ? config.getLevel().toString() : config.getLevel().toString() + " (inherited from '" + config.getName() + "')";
        this.log("Switching channel '" + logger.getName() + "' from " + oldLevelDesc + " to " + newLevel.toString());
    }

    static enum TableColumn {
        Channel("GUI_LOGFILE_LOGSETTINGS_CHANNEL_0", String.class, ""),
        File("GUI_LOGFILE_LOGSETTINGS_FILE_0", String.class, ""),
        Icon(null, Resource.class, new CmsCssIcon("oc-icon-24-log")),
        Level("GUI_LOGFILE_LOGSETTINGS_LEVEL_0", LoggerLevel.class, null),
        ParentChannel("GUI_LOGFILE_LOGSETTINGS_PARENT_CHANNEL_0", String.class, "");

        private Object m_defaultValue;
        private String m_headerMessage;
        private Class<?> m_type;

        private TableColumn(String headerMessage, Class<?> type, Object defaultValue) {
            this.m_headerMessage = headerMessage;
            this.m_type = type;
            this.m_defaultValue = defaultValue;
        }

        static List<TableColumn> withHeader() {
            ArrayList<TableColumn> props = new ArrayList<TableColumn>();
            for (TableColumn prop : TableColumn.values()) {
                if (prop.m_headerMessage == null) continue;
                props.add(prop);
            }
            return props;
        }

        Object getDefaultValue() {
            return this.m_defaultValue;
        }

        String getLocalizedMessage() {
            if (this.m_headerMessage == null) {
                return "";
            }
            return CmsVaadinUtils.getMessageText(this.m_headerMessage, new Object[0]);
        }

        Class<?> getType() {
            return this.m_type;
        }
    }

    class LevelIcon
    implements Table.ColumnGenerator {
        private static final long serialVersionUID = 7258796583481183276L;

        LevelIcon() {
        }

        public Object generateCell(Table source, Object itemId, Object columnId) {
            return ((LoggerLevel)((Object)source.getItem(itemId).getItemProperty(columnId).getValue())).getLevelString();
        }
    }

    private static enum LoggerLevel {
        Debug(Level.DEBUG, " o-box-red", null),
        Error(Level.ERROR, " o-box-cyan", "Default"),
        Fatal(Level.FATAL, " o-box-blue-light", null),
        Info(Level.INFO, " o-box-orange-dark", null),
        Off(Level.OFF, " o-box-gray", null),
        Warn(Level.WARN, " o-box-orange", null);

        private String m_caption;
        private String m_css;
        private Level m_level;

        private LoggerLevel(Level level, String css, String caption) {
            this.m_css = css;
            this.m_level = level;
            this.m_caption = caption;
        }

        protected static LoggerLevel fromLogger(Logger logger) {
            for (LoggerLevel item : LoggerLevel.values()) {
                if (!item.getLevel().equals((Object)logger.getLevel())) continue;
                return item;
            }
            return null;
        }

        protected String getCssClass() {
            return this.m_css;
        }

        protected Level getLevel() {
            return this.m_level;
        }

        protected String getLevelString() {
            if (this.m_caption == null) {
                String out = this.m_level.toString();
                return out.substring(0, 1).toUpperCase() + out.substring(1).toLowerCase();
            }
            return this.m_caption;
        }

        protected String getLevelStringComplet() {
            if (this.m_caption == null) {
                return this.getLevelString();
            }
            String level = this.m_level.toString();
            level = level.substring(0, 1).toUpperCase() + level.substring(1).toLowerCase();
            return this.m_caption + " (" + level + ")";
        }
    }
}

