/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.modules.CmsModuleApp;
import org.opencms.ui.apps.modules.CmsModuleImportFile;
import org.opencms.ui.apps.modules.CmsModuleImportThread;
import org.opencms.ui.apps.modules.edit.CmsSiteSelectorNewValueHandler;
import org.opencms.ui.components.CmsAutoItemCreatingComboBox;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.report.CmsReportWidget;

public abstract class A_CmsModuleImportForm
extends CssLayout {
    private static final Log LOG = CmsLog.getLog(A_CmsModuleImportForm.class);
    private static final long serialVersionUID = 1L;
    protected CmsModuleApp m_app;
    protected CmsModuleImportFile m_importFile;

    public A_CmsModuleImportForm(CmsModuleApp app, final VerticalLayout start, final VerticalLayout report, final Runnable run) {
        report.setVisible(false);
        CmsObject cms = A_CmsUI.getCmsObject();
        this.m_app = app;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.getOkButton().setEnabled(false);
        IndexedContainer availableSites = CmsVaadinUtils.getAvailableSitesContainer(cms, "name");
        this.getSiteSelector().setContainerDataSource((Container)availableSites);
        if (availableSites.getItem((Object)cms.getRequestContext().getSiteRoot()) != null) {
            this.getSiteSelector().setValue(cms.getRequestContext().getSiteRoot());
        }
        this.getSiteSelector().setNullSelectionAllowed(false);
        this.getSiteSelector().setItemCaptionPropertyId("name");
        this.getSiteSelector().setNewValueHandler(new CmsSiteSelectorNewValueHandler("name"));
        this.getCancelButton().addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsVaadinUtils.getWindow((Component)A_CmsModuleImportForm.this.getCancelButton()).close();
            }
        });
        this.getOkButton().addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    start.setVisible(false);
                    report.setVisible(true);
                    A_CmsModuleImportForm.this.getOkButton().setVisible(false);
                    CmsObject importCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    importCms.getRequestContext().setSiteRoot((String)A_CmsModuleImportForm.this.getSiteSelector().getValue());
                    CmsModuleImportThread thread = new CmsModuleImportThread(importCms, A_CmsModuleImportForm.this.m_importFile.getModule(), A_CmsModuleImportForm.this.m_importFile.getPath());
                    CmsReportWidget reportWidget = new CmsReportWidget(thread);
                    reportWidget.setWidth("100%");
                    reportWidget.setHeight("100%");
                    report.addComponent((Component)reportWidget);
                    thread.start();
                    A_CmsModuleImportForm.this.getOkButton().setEnabled(false);
                    A_CmsModuleImportForm.this.getCancelButton().setCaption(CmsVaadinUtils.messageClose());
                    A_CmsModuleImportForm.this.getCancelButton().addClickListener(new Button.ClickListener(){
                        private static final long serialVersionUID = 1L;

                        public void buttonClick(Button.ClickEvent event) {
                            run.run();
                        }
                    });
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    CmsErrorDialog.showErrorDialog(e);
                }
            }
        });
    }

    public List<Button> getButtons() {
        return Arrays.asList(this.getOkButton(), this.getCancelButton());
    }

    protected abstract Button getCancelButton();

    protected abstract Button getOkButton();

    protected abstract CmsAutoItemCreatingComboBox getSiteSelector();

    protected String processFileName(String name) {
        int pos = name.lastIndexOf("/");
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        if ((pos = name.lastIndexOf("\\")) >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    protected void validateModuleFile() {
        try {
            this.m_importFile.loadAndValidate();
            CmsModule importModule = this.m_importFile.getModule();
            String site = importModule.getSite();
            if (site != null) {
                if (importModule.hasImportSite()) {
                    this.getSiteSelector().setEnabled(false);
                    this.getSiteSelector().setValue(site);
                } else {
                    String itemId = CmsVaadinUtils.getPathItemId(this.getSiteSelector().getContainerDataSource(), site);
                    if (itemId != null) {
                        this.getSiteSelector().setValue(itemId);
                    }
                }
            }
            this.getOkButton().setEnabled(true);
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_importFile = null;
            this.getOkButton().setEnabled(false);
            CmsErrorDialog.showErrorDialog(e);
        }
    }
}

