/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.FileInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.report.A_CmsReportThread;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.report.CmsReportWidget;

public class CmsModuleExportDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsModuleExportDialog.class);
    private static final long serialVersionUID = 1L;
    private CmsModuleImportExportHandler m_exportHandler;

    public CmsModuleExportDialog(CmsModuleImportExportHandler exportHandler, A_CmsReportThread thread, final Window window) {
        this.m_exportHandler = exportHandler;
        Button close = this.createButtonClose();
        Button download = new Button(CmsVaadinUtils.getMessageText("GUI_BUTTON_DOWNLOAD_0", new Object[0]));
        close.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        download.setEnabled(false);
        this.addButton((Component)download, true);
        this.addButton((Component)close, true);
        CmsReportWidget report = new CmsReportWidget(thread);
        report.addReportFinishedHandler(() -> {
            if (thread.getErrors().size() == 0) {
                FileDownloader downloadContext = new FileDownloader(this.getDownloadResource());
                downloadContext.extend((AbstractComponent)download);
                download.setEnabled(true);
            }
        });
        this.setHeight("100%");
        report.setWidth("100%");
        report.setHeight("100%");
        VerticalLayout container = new VerticalLayout();
        container.setHeight("100%");
        container.addComponent((Component)report);
        this.setContent((Component)container);
        thread.start();
    }

    private Resource getDownloadResource() {
        return new StreamResource((StreamResource.StreamSource & Serializable)() -> {
            try {
                FileInputStream stream = new FileInputStream(this.m_exportHandler.getFileName() + ".zip");
                return stream;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }, CmsResource.getName(this.m_exportHandler.getFileName() + ".zip"));
    }
}

