/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.modules;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleManager;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;

public class CmsModuleImportThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsModuleImportThread.class);
    private CmsObject m_cms;
    private CmsModule m_module;
    private String m_path;

    public CmsModuleImportThread(CmsObject cms, CmsModule module, String path) {
        super(cms, "Import of " + path);
        this.m_module = module;
        this.m_path = path;
        this.m_cms = cms;
        this.initHtmlReport(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    @Override
    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    @Override
    public void run() {
        LOG.info((Object)("Starting import thread for " + this.m_module.getName() + ", import =  " + this.m_path));
        I_CmsReport report = this.getReport();
        try {
            CmsObject cms = this.m_cms;
            CmsModuleManager manager = OpenCms.getModuleManager();
            manager.replaceModule(cms, this.m_path, report);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            report.addError(e);
        }
    }
}

