/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.projects;

import com.vaadin.server.Resource;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.projects.CmsProjectManager;

public class CmsProjectOverviewConfiguration
extends A_CmsWorkplaceAppConfiguration {
    public static final String APP_ID = "project-overview";

    @Override
    public String getAppCategory() {
        return "Administration";
    }

    @Override
    public I_CmsWorkplaceApp getAppInstance() {
        return new CmsProjectManager();
    }

    @Override
    public String getHelpText(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_PROJECTS_OVERVIEW_HELP_0");
    }

    @Override
    public Resource getIcon() {
        return FontOpenCms.PROJECT;
    }

    @Override
    public String getId() {
        return APP_ID;
    }

    @Override
    public String getName(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_PROJECTS_OVERVIEW_TITLE_0");
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    public CmsAppVisibilityStatus getVisibility(CmsObject cms) {
        CmsAppVisibilityStatus status = !OpenCms.getRoleManager().hasRole(cms, CmsRole.PROJECT_MANAGER) && OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_USER) ? CmsAppVisibilityStatus.ACTIVE : CmsAppVisibilityStatus.INVISIBLE;
        return status;
    }
}

