/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.publishqueue;

import com.vaadin.v7.ui.Table;
import java.util.List;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsResource;

class CmsResourcesCellGenerator
implements Table.ColumnGenerator {
    private static final long serialVersionUID = -3349782291910407616L;
    private int m_charLimit;

    public CmsResourcesCellGenerator(int charLimit) {
        this.m_charLimit = charLimit;
    }

    public static String formatResourcesForTable(List<?> resources, int charLimit) {
        String out = "";
        if (!resources.isEmpty()) {
            out = CmsResourcesCellGenerator.getRootPath(resources.get(0));
            int i = 1;
            while (resources.size() > i & out.length() < charLimit) {
                out = out + ", " + CmsResourcesCellGenerator.getRootPath(resources.get(i));
            }
            if (resources.size() > i) {
                out = out + " ...";
            }
        }
        return out;
    }

    private static String getRootPath(Object resource) {
        if (resource instanceof CmsResource) {
            return ((CmsResource)resource).getRootPath();
        }
        if (resource instanceof CmsPublishedResource) {
            return ((CmsPublishedResource)resource).getRootPath();
        }
        throw new IllegalArgumentException("wrong format of resources");
    }

    public Object generateCell(Table source, Object itemId, Object columnId) {
        List resources = (List)source.getItem(itemId).getItemProperty(columnId).getValue();
        String out = CmsResourcesCellGenerator.formatResourcesForTable(resources, this.m_charLimit);
        return out;
    }
}

