/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.search;

import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSourceSearchApp;
import org.opencms.ui.components.fileselect.CmsPathSelectField;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSourceSearchForm
extends VerticalLayout {
    public static final String REGEX_ALL = ".*";
    public static final String RESOURCE_TYPES_ALL_NON_BINARY = "_NonBinary_";
    static final Log LOG = CmsLog.getLog(CmsSourceSearchForm.class);
    private static final long serialVersionUID = 1023130318064811880L;
    private CmsSourceSearchApp m_app;
    private Button m_download;
    private FileDownloader m_downloader;
    private CheckBox m_ignoreSubSites;
    private ComboBox m_locale;
    private TextField m_newName;
    private TextField m_oldName;
    private ComboBox m_property;
    private CheckBox m_replace;
    private TextField m_replacePattern;
    private CmsPathSelectField m_replaceResource;
    private CmsPathSelectField m_resourceSearch;
    private ComboBox m_resourceType;
    private Button m_search;
    private ComboBox m_searchIndex;
    private TextField m_searchPattern;
    private CmsPathSelectField m_searchRoot;
    private ComboBox m_searchType;
    private ComboBox m_siteSelect;
    private TextField m_solrQuery;
    private ComboBox m_workProject;
    private TextField m_xPath;

    public CmsSourceSearchForm(CmsSourceSearchApp app) {
        this.m_app = app;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.initFields();
        this.m_replace.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceSearchForm.this.updateReplace();
            }
        });
        this.m_searchType.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsSourceSearchForm.this.changedSearchType();
            }
        });
        this.m_search.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSourceSearchForm.this.search();
            }
        });
        this.m_download.setVisible(false);
        this.m_downloader = new FileDownloader((Resource)new StreamResource((StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(new byte[0]), "empty.csv"));
        this.m_downloader.extend((AbstractComponent)this.m_download);
        this.updateReplace();
        this.changedSearchType();
    }

    public void initFormValues(CmsSearchReplaceSettings settings) {
        this.m_siteSelect.setValue((Object)settings.getSiteRoot());
        this.m_ignoreSubSites.setValue((Object)settings.ignoreSubSites());
        this.m_searchType.setValue((Object)settings.getType());
        if (!settings.getPaths().isEmpty()) {
            this.m_searchRoot.setValue(settings.getPaths().get(0));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(settings.getTypes())) {
            if (RESOURCE_TYPES_ALL_NON_BINARY.equals(settings.getTypes())) {
                this.m_resourceType.setValue((Object)RESOURCE_TYPES_ALL_NON_BINARY);
            } else {
                try {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(settings.getTypes());
                    this.m_resourceType.setValue((Object)type);
                }
                catch (CmsLoaderException type) {
                    // empty catch block
                }
            }
        }
        this.m_searchPattern.setValue(settings.getSearchpattern());
        this.m_ignoreSubSites.setValue((Object)settings.ignoreSubSites());
        if (settings.getType().isContentValuesOnly()) {
            if (settings.getLocale() != null) {
                OpenCms.getLocaleManager();
                Locale l = CmsLocaleManager.getLocale(settings.getLocale());
                if (!l.equals(CmsLocaleManager.getDefaultLocale()) || l.toString().equals(settings.getLocale())) {
                    this.m_locale.setValue((Object)l);
                }
            }
            this.m_xPath.setValue(settings.getXpath());
        }
        if (settings.getType().isSolrSearch()) {
            this.m_solrQuery.setValue(settings.getQuery());
            this.m_searchIndex.setValue((Object)settings.getSource());
        }
        if (settings.getType().isPropertySearch()) {
            this.m_property.select((Object)settings.getProperty());
        }
        if (settings.getType().equals((Object)SearchType.resourcetype)) {
            try {
                CmsObject cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                this.m_resourceSearch.setValue(cms.readResource(new CmsUUID(settings.getSearchpattern().substring(settings.getSearchpattern().indexOf("<uuid>") + 6, settings.getSearchpattern().indexOf("</uuid>")))).getRootPath());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read resource", (Throwable)e);
            }
        }
    }

    public void setDownload(StreamResource resource) {
        this.m_downloader.setFileDownloadResource((Resource)resource);
        this.m_download.setVisible(resource != null);
    }

    protected void updateSearchRoot() throws CmsException {
        CmsObject newCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
        newCms.getRequestContext().setSiteRoot((String)this.m_siteSelect.getValue());
        this.m_searchRoot.setCmsObject(newCms);
        this.m_searchRoot.setValue("/");
    }

    void changedSearchType() {
        SearchType type = (SearchType)((Object)this.m_searchType.getValue());
        this.m_property.setVisible(type.isPropertySearch());
        this.m_searchPattern.setVisible(!type.equals((Object)SearchType.resourcetype) & !type.equals((Object)SearchType.renameContainer));
        this.m_resourceSearch.setVisible(type.equals((Object)SearchType.resourcetype) | type.equals((Object)SearchType.renameContainer));
        if (!type.equals((Object)SearchType.resourcetype) & !type.equals((Object)SearchType.renameContainer)) {
            this.m_ignoreSubSites.setValue((Object)Boolean.FALSE);
            this.m_ignoreSubSites.setVisible(false);
        } else {
            this.m_ignoreSubSites.setVisible(true);
        }
        this.m_searchIndex.setVisible(type.isSolrSearch());
        this.m_solrQuery.setVisible(type.isSolrSearch());
        this.updateReplace();
        this.m_xPath.setVisible(type.isContentValuesOnly());
        this.m_locale.setVisible(type.isContentValuesOnly());
        this.m_resourceType.setVisible(!type.isPropertySearch() & !type.equals((Object)SearchType.resourcetype) & !type.equals((Object)SearchType.renameContainer));
        IndexedContainer types = (IndexedContainer)this.m_resourceType.getContainerDataSource();
        types.removeAllContainerFilters();
        types.addContainerFilter(type.isContentValuesOnly() ? CmsVaadinUtils.FILTER_XML_CONTENTS : CmsVaadinUtils.FILTER_NO_FOLDERS);
    }

    void search() {
        CmsResource resource;
        CmsObject cms;
        CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
        settings.setSiteRoot((String)this.m_siteSelect.getValue());
        settings.setType((SearchType)((Object)this.m_searchType.getValue()));
        settings.setPaths(Collections.singletonList(this.m_searchRoot.getValue()));
        settings.setIgnoreSubSites((Boolean)this.m_ignoreSubSites.getValue());
        Object resTypeSelection = this.m_resourceType.getValue();
        if (resTypeSelection != null) {
            if (resTypeSelection instanceof String) {
                settings.setTypes((String)resTypeSelection);
            } else {
                I_CmsResourceType type = (I_CmsResourceType)this.m_resourceType.getValue();
                settings.setTypes(type.getTypeName());
            }
        }
        if (SearchType.resourcetype.equals(this.m_searchType.getValue()) | SearchType.renameContainer.equals(this.m_searchType.getValue())) {
            settings.setTypes(CmsResourceTypeXmlContainerPage.getStaticTypeName() + "," + "modelgroup");
        }
        if (SearchType.renameContainer.equals(this.m_searchType.getValue())) {
            try {
                cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                CmsResource element = cms.readResource(this.m_resourceSearch.getValue());
                settings.setElementResource(element);
            }
            catch (CmsException e) {
                LOG.error((Object)"Can not read resource", (Throwable)e);
            }
        }
        if (((Boolean)this.m_replace.getValue()).booleanValue()) {
            try {
                CmsProject workProject = A_CmsUI.getCmsObject().readProject((CmsUUID)this.m_workProject.getValue());
                settings.setProject(workProject.getName());
            }
            catch (CmsException workProject) {
                // empty catch block
            }
            if (SearchType.resourcetype.equals(this.m_searchType.getValue())) {
                try {
                    cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                    cms.getRequestContext().setSiteRoot("");
                    resource = cms.readResource(this.m_replaceResource.getValue());
                    settings.setReplacepattern(CmsSearchReplaceSettings.replaceElementInPagePattern(resource));
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to read resource.", (Throwable)e);
                }
            } else if (SearchType.renameContainer.equals(this.m_searchType.getValue())) {
                settings.setReplacepattern((String)this.m_oldName.getValue() + ";" + (String)this.m_newName.getValue());
            } else {
                settings.setReplacepattern((String)this.m_replacePattern.getValue());
            }
        }
        settings.setForceReplace((Boolean)this.m_replace.getValue());
        if (SearchType.resourcetype.equals(this.m_searchType.getValue()) | SearchType.renameContainer.equals(this.m_searchType.getValue())) {
            try {
                cms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                resource = cms.readResource(this.m_resourceSearch.getValue());
                settings.setSearchpattern(CmsSearchReplaceSettings.searchElementInPagePattern(resource));
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read resource.", (Throwable)e);
            }
        } else {
            settings.setSearchpattern((String)this.m_searchPattern.getValue());
        }
        if (settings.getType().isContentValuesOnly()) {
            if (this.m_locale.getValue() != null) {
                settings.setLocale(this.m_locale.getValue().toString());
            }
            settings.setXpath((String)this.m_xPath.getValue());
        }
        if (settings.getType().isSolrSearch()) {
            settings.setQuery((String)this.m_solrQuery.getValue());
            settings.setSource((String)this.m_searchIndex.getValue());
        }
        if (settings.getType().isPropertySearch()) {
            settings.setProperty((CmsPropertyDefinition)this.m_property.getValue());
            settings.setForceReplace((Boolean)this.m_replace.getValue());
        }
        this.m_app.search(settings, true);
    }

    void updateReplace() {
        boolean replace = (Boolean)this.m_replace.getValue();
        this.m_replaceResource.setVisible(replace ? SearchType.resourcetype.equals(this.m_searchType.getValue()) : replace);
        this.m_replacePattern.setVisible(replace ? !SearchType.resourcetype.equals(this.m_searchType.getValue()) & !SearchType.renameContainer.equals(this.m_searchType.getValue()) : replace);
        this.m_newName.setVisible(replace ? SearchType.renameContainer.equals(this.m_searchType.getValue()) : replace);
        this.m_oldName.setVisible(replace ? SearchType.renameContainer.equals(this.m_searchType.getValue()) : replace);
        this.m_workProject.setVisible(replace);
        this.m_search.setCaption(replace ? CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_REPLACE_0", new Object[0]) : CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SEARCH_0", new Object[0]));
    }

    private void initFields() {
        CmsObject cms = A_CmsUI.getCmsObject();
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        if (((String)this.m_searchPattern.getValue()).isEmpty()) {
            this.m_searchPattern.setValue(REGEX_ALL);
        }
        this.m_resourceSearch.setUseRootPaths(true);
        this.m_replaceResource.setUseRootPaths(true);
        this.m_resourceSearch.requireFile();
        this.m_replaceResource.requireFile();
        try {
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            this.m_resourceSearch.setCmsObject(rootCms);
            this.m_resourceSearch.setDefaultPath(cms.getRequestContext().getSiteRoot());
            this.m_replaceResource.setCmsObject(rootCms);
            this.m_replaceResource.setDefaultPath(cms.getRequestContext().getSiteRoot());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_siteSelect.setContainerDataSource((Container)CmsVaadinUtils.getAvailableSitesContainer(cms, "label"));
        this.m_siteSelect.setItemCaptionPropertyId((Object)"label");
        this.m_siteSelect.setTextInputAllowed(true);
        this.m_siteSelect.setNullSelectionAllowed(false);
        this.m_siteSelect.setFilteringMode(FilteringMode.CONTAINS);
        this.m_siteSelect.setValue((Object)cms.getRequestContext().getSiteRoot());
        try {
            for (CmsPropertyDefinition cmsPropertyDefinition : A_CmsUI.getCmsObject().readAllPropertyDefinitions()) {
                this.m_property.addItem((Object)cmsPropertyDefinition);
                this.m_property.setItemCaption((Object)cmsPropertyDefinition, cmsPropertyDefinition.getName());
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_siteSelect.addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = -1079794209679015125L;

            public void valueChange(Property.ValueChangeEvent event) {
                try {
                    CmsSourceSearchForm.this.updateSearchRoot();
                }
                catch (CmsException e) {
                    LOG.error((Object)"Unable to initialize CmsObject", (Throwable)e);
                }
            }
        });
        this.m_property.setNullSelectionAllowed(false);
        this.m_property.select(this.m_property.getItemIds().iterator().next());
        this.m_property.setFilteringMode(FilteringMode.CONTAINS);
        this.m_searchType.setFilteringMode(FilteringMode.OFF);
        this.m_searchType.setNullSelectionAllowed(false);
        this.m_searchType.addItem((Object)SearchType.fullText);
        this.m_searchType.setItemCaption((Object)SearchType.fullText, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_FULLTEXT_0", new Object[0]));
        this.m_searchType.addItem((Object)SearchType.contentValues);
        this.m_searchType.setItemCaption((Object)SearchType.contentValues, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_XMLCONTENT_0", new Object[0]));
        this.m_searchType.addItem((Object)SearchType.properties);
        this.m_searchType.setItemCaption((Object)SearchType.properties, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_PROPERTY_SEARCH_0", new Object[0]));
        this.m_searchType.addItem((Object)SearchType.resourcetype);
        this.m_searchType.setItemCaption((Object)SearchType.resourcetype, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_RESOURCE_SEARCH_0", new Object[0]));
        this.m_searchType.addItem((Object)SearchType.renameContainer);
        this.m_searchType.setItemCaption((Object)SearchType.renameContainer, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_RENAME_CONTAINER_SEARCH_0", new Object[0]));
        if (OpenCms.getSearchManager().getSolrServerConfiguration().isEnabled()) {
            this.m_searchIndex.setFilteringMode(FilteringMode.OFF);
            this.m_searchIndex.setNullSelectionAllowed(false);
            Object selectIndex = null;
            for (CmsSearchIndex cmsSearchIndex : OpenCms.getSearchManager().getAllSolrIndexes()) {
                boolean offlineMode = "offline".equals(cmsSearchIndex.getRebuildMode());
                if ((online || !offlineMode) && (!online || offlineMode)) continue;
                this.m_searchIndex.addItem((Object)cmsSearchIndex.getName());
                if (selectIndex != null) continue;
                selectIndex = cmsSearchIndex.getName();
            }
            if (selectIndex != null) {
                this.m_searchIndex.setValue(selectIndex);
                this.m_searchType.addItem((Object)SearchType.solr);
                this.m_searchType.setItemCaption((Object)SearchType.solr, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_SOLR_0", new Object[0]));
                this.m_searchType.addItem((Object)SearchType.solrContentValues);
                this.m_searchType.setItemCaption((Object)SearchType.solrContentValues, CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_SERACH_TYPE_SOLR_CONTENT_VALUES_0", new Object[0]));
            }
        }
        this.m_searchType.setValue((Object)SearchType.fullText);
        this.m_searchRoot.setValue("/");
        this.m_searchRoot.disableSiteSwitch();
        this.m_searchRoot.setResourceFilter(CmsResourceFilter.DEFAULT_FOLDERS);
        this.m_searchRoot.requireFolder();
        this.m_locale.setFilteringMode(FilteringMode.OFF);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            this.m_locale.addItem((Object)locale);
        }
        this.m_resourceType.setNullSelectionAllowed(true);
        IndexedContainer resTypes = CmsVaadinUtils.getResourceTypesContainer();
        Item item = resTypes.addItemAt(0, (Object)RESOURCE_TYPES_ALL_NON_BINARY);
        String string = CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_RESOURCE_TYPE_NON_BINARY_0", new Object[0]);
        item.getItemProperty((Object)CmsVaadinUtils.PropertyId.caption).setValue((Object)string);
        item.getItemProperty((Object)CmsVaadinUtils.PropertyId.icon).setValue(null);
        item.getItemProperty((Object)CmsVaadinUtils.PropertyId.isXmlContent).setValue((Object)Boolean.TRUE);
        item.getItemProperty((Object)CmsVaadinUtils.PropertyId.isFolder).setValue((Object)Boolean.FALSE);
        resTypes.addContainerFilter(CmsVaadinUtils.FILTER_NO_FOLDERS);
        this.m_resourceType.setContainerDataSource((Container)resTypes);
        this.m_resourceType.setItemCaptionPropertyId((Object)CmsVaadinUtils.PropertyId.caption);
        this.m_resourceType.setItemIconPropertyId((Object)CmsVaadinUtils.PropertyId.icon);
        this.m_resourceType.setFilteringMode(FilteringMode.CONTAINS);
        this.m_workProject.setNullSelectionAllowed(false);
        IndexedContainer projects = CmsVaadinUtils.getProjectsContainer(A_CmsUI.getCmsObject(), "caption");
        projects.removeItem((Object)CmsProject.ONLINE_PROJECT_ID);
        this.m_workProject.setContainerDataSource((Container)projects);
        this.m_workProject.setItemCaptionPropertyId((Object)"caption");
        if (online) {
            this.m_replace.setEnabled(false);
        } else {
            this.m_workProject.setValue((Object)cms.getRequestContext().getCurrentProject().getUuid());
        }
    }

    public static enum SearchType {
        contentValues(false, true, false),
        fullText(false, false, false),
        properties(false, false, true),
        renameContainer(false, false, false),
        resourcetype(false, false, false),
        solr(true, false, false),
        solrContentValues(true, true, false);

        private boolean m_contentValuesOnly;
        private boolean m_property;
        private boolean m_solrSearch;

        private SearchType(boolean solrSearch, boolean contentValuesOnly, boolean property) {
            this.m_solrSearch = solrSearch;
            this.m_contentValuesOnly = contentValuesOnly;
            this.m_property = property;
        }

        public boolean isContentValuesOnly() {
            return this.m_contentValuesOnly;
        }

        public boolean isPropertySearch() {
            return this.m_property;
        }

        public boolean isSolrSearch() {
            return this.m_solrSearch;
        }
    }
}

