/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.Setter;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsVariablesConfiguration;
import org.opencms.db.CmsLoginMessage;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsDateField;
import org.opencms.ui.components.CmsRichTextArea;

public class CmsEditLoginView
extends CmsBasicDialog {
    static Log LOG = CmsLog.getLog(CmsEditLoginView.class.getName());
    private static final long serialVersionUID = -1053691437033852491L;
    private Button m_cancel;
    private Button m_deleteBefore;
    private Button m_deleteAfter;
    private CheckBox m_enabledAfter;
    private CheckBox m_enabledBefore;
    private CmsDateField m_endTimeAfter;
    private Binder<CmsLoginMessage> m_formBinderAfter;
    private Binder<CmsLoginMessage> m_formBinderBefore;
    private TabSheet m_tab;
    private CheckBox m_logoutAfter;
    protected CmsRichTextArea m_messageAfter;
    protected CmsRichTextArea m_messageBefore;
    private Button m_ok;
    private CmsDateField m_startTimeAfter;

    public CmsEditLoginView(final Window window) {
        CmsLoginMessage messageBefore;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.setHeight("100%");
        this.bindFields();
        CmsLoginMessage message = OpenCms.getLoginManager().getLoginMessage();
        if (message == null) {
            message = new CmsLoginMessage();
        }
        this.m_formBinderAfter.readBean((Object)message);
        if (!message.isEnabled()) {
            this.m_endTimeAfter.setValue(null);
            this.m_startTimeAfter.setValue(null);
        }
        if ((messageBefore = OpenCms.getLoginManager().getBeforeLoginMessage()) == null) {
            messageBefore = new CmsLoginMessage();
        }
        this.m_formBinderBefore.readBean((Object)messageBefore);
        this.m_cancel.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 4425001638229366505L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
            }
        });
        this.m_ok.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 5512397920545155478L;

            public void buttonClick(Button.ClickEvent event) {
                if (CmsEditLoginView.this.isFormValid()) {
                    CmsEditLoginView.this.submit();
                    window.close();
                }
            }
        });
        this.m_deleteBefore.addClickListener((Button.ClickListener & Serializable)event -> this.m_messageBefore.clear());
        this.m_deleteAfter.addClickListener((Button.ClickListener & Serializable)event -> this.m_messageAfter.clear());
    }

    protected long getEnd() {
        if (this.m_endTimeAfter.getValue() == null) {
            return 0L;
        }
        return this.m_endTimeAfter.getDate().getTime();
    }

    protected long getStart() {
        if (this.m_startTimeAfter.getValue() == null) {
            return 0L;
        }
        return this.m_startTimeAfter.getDate().getTime();
    }

    protected boolean isFormValid() {
        return !this.m_formBinderAfter.validate().hasErrors();
    }

    protected void submit() {
        CmsLoginMessage loginMessage = new CmsLoginMessage();
        CmsLoginMessage beforeLoginMessage = new CmsLoginMessage();
        try {
            this.m_formBinderAfter.writeBean((Object)loginMessage);
            this.m_formBinderBefore.writeBean((Object)beforeLoginMessage);
            OpenCms.getLoginManager().setLoginMessage(A_CmsUI.getCmsObject(), loginMessage);
            OpenCms.getLoginManager().setBeforeLoginMessage(A_CmsUI.getCmsObject(), beforeLoginMessage);
            OpenCms.writeConfiguration(CmsVariablesConfiguration.class);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to save Login Message", (Throwable)e);
        }
    }

    boolean hasValidTimes() {
        if (this.getEnd() > 0L && this.getEnd() < System.currentTimeMillis()) {
            return false;
        }
        return this.getEnd() == 0L | this.getStart() == 0L || this.getEnd() >= this.getStart();
    }

    private void bindFields() {
        this.m_formBinderAfter = new Binder();
        this.m_formBinderAfter.bind((HasValue)this.m_messageAfter, CmsLoginMessage::getMessage, CmsLoginMessage::setMessage);
        this.m_formBinderAfter.bind((HasValue)this.m_enabledAfter, (ValueProvider & Serializable)loginMessage -> loginMessage.isEnabled(), (Setter & Serializable)(loginMessage, enabled) -> loginMessage.setEnabled((boolean)enabled));
        this.m_formBinderAfter.bind((HasValue)this.m_logoutAfter, (ValueProvider & Serializable)loginMessage -> loginMessage.isLoginForbidden(), (Setter & Serializable)(loginMessage, forbidden) -> loginMessage.setLoginForbidden((boolean)forbidden));
        this.m_formBinderAfter.forField((HasValue)this.m_endTimeAfter).withValidator((SerializablePredicate & Serializable)endTime -> this.hasValidTimes(), CmsVaadinUtils.getMessageText("GUI_MESSAGES_LOGINMESSAGE_VAL_DATE_0", new Object[0])).bind((ValueProvider & Serializable)loginMessage -> loginMessage.getTimeEnd() != CmsLoginMessage.DEFAULT_TIME_END ? CmsDateField.dateToLocalDateTime(new Date(loginMessage.getTimeEnd())) : null, (Setter & Serializable)(loginMessage, endTime) -> loginMessage.setTimeEnd(endTime != null ? CmsDateField.localDateTimeToDate(endTime).getTime() : CmsLoginMessage.DEFAULT_TIME_END));
        this.m_formBinderAfter.forField((HasValue)this.m_startTimeAfter).withValidator((SerializablePredicate & Serializable)startTime -> this.hasValidTimes(), CmsVaadinUtils.getMessageText("GUI_MESSAGES_LOGINMESSAGE_VAL_DATE_0", new Object[0])).bind((ValueProvider & Serializable)loginMessage -> loginMessage.getTimeStart() != CmsLoginMessage.DEFAULT_TIME_START ? CmsDateField.dateToLocalDateTime(new Date(loginMessage.getTimeStart())) : null, (Setter & Serializable)(loginMessage, startTime) -> loginMessage.setTimeStart(startTime != null ? CmsDateField.localDateTimeToDate(startTime).getTime() : CmsLoginMessage.DEFAULT_TIME_START));
        this.m_formBinderBefore = new Binder();
        this.m_formBinderBefore.bind((HasValue)this.m_messageBefore, CmsLoginMessage::getMessage, CmsLoginMessage::setMessage);
        this.m_formBinderBefore.bind((HasValue)this.m_enabledBefore, (ValueProvider & Serializable)loginMessage -> loginMessage.isEnabled(), (Setter & Serializable)(loginMessage, enabled) -> loginMessage.setEnabled((boolean)enabled));
    }
}

