/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.sessions.CmsEditLoginView;
import org.opencms.ui.apps.sessions.CmsSendBroadcastDialog;
import org.opencms.ui.apps.sessions.CmsSessionsTable;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsInfoButton;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.CmsToolBar;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSessionsApp
extends A_CmsWorkplaceApp {
    static Log LOG = CmsLog.getLog(CmsSessionsApp.class.getName());
    CmsSessionsTable m_table;
    CmsInfoButton m_infoButton;

    protected static List<CmsResourceInfo> getUserInfos(Set<String> ids) {
        ArrayList<CmsResourceInfo> ret = new ArrayList<CmsResourceInfo>();
        try {
            for (String id : ids) {
                CmsUser user = A_CmsUI.getCmsObject().readUser(OpenCms.getSessionManager().getSessionInfo(new CmsUUID(id)).getUserId());
                ret.add(CmsAccountsApp.getPrincipalInfo(user));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to read user", (Throwable)e);
        }
        return ret;
    }

    protected static String getUserNames(Set<String> ids, String andLocalized) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (String id : ids) {
            CmsSessionInfo session = OpenCms.getSessionManager().getSessionInfo(new CmsUUID(id));
            try {
                String name = A_CmsUI.getCmsObject().readUser(session.getUserId()).getName();
                if (userNames.contains(name)) continue;
                userNames.add(name);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read user information", (Throwable)e);
            }
        }
        Iterator iterator = userNames.iterator();
        String res = "";
        while (iterator.hasNext()) {
            res = res + (String)iterator.next();
            if (!iterator.hasNext()) continue;
            res = res + ", ";
        }
        int lastPosSeperation = res.lastIndexOf(", ");
        return lastPosSeperation == -1 ? res : res.substring(0, lastPosSeperation) + " " + andLocalized + " " + res.substring(lastPosSeperation + 2, res.length());
    }

    protected static void showSendBroadcastDialog(Set<String> ids, String caption, CmsSessionsTable table) {
        Window window = CmsBasicDialog.prepareWindow();
        window.setCaption(caption);
        CmsSendBroadcastDialog dialog = new CmsSendBroadcastDialog(ids, CmsSessionsTable.getCloseRunnable(window, table));
        window.setContent((Component)dialog);
        dialog.setWindowMinFullHeight(500);
        A_CmsUI.get().addWindow(window);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state)) {
            crumbs.put("", CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_ADMIN_TOOL_NAME_0", new Object[0]));
            return crumbs;
        }
        return new LinkedHashMap<String, String>();
    }

    @Override
    protected Component getComponentForState(String state) {
        this.addToolbarButtons();
        this.addInfoLayoutComponents();
        this.m_rootLayout.setMainHeightFull(true);
        if (state.isEmpty()) {
            this.m_table = new CmsSessionsTable();
            return this.m_table;
        }
        return null;
    }

    protected Map<String, String> getInfoMap() {
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        List<CmsSessionInfo> sessions = OpenCms.getSessionManager().getSessionInfos();
        ArrayList<CmsUUID> user = new ArrayList<CmsUUID>();
        for (CmsSessionInfo info : sessions) {
            CmsUUID id = info.getUserId();
            if (user.contains(id)) continue;
            user.add(id);
        }
        infos.put(CmsVaadinUtils.getMessageText("GUI_MESSAGES_SESSION_COUNT_0", new Object[0]), String.valueOf(sessions.size()));
        infos.put(CmsVaadinUtils.getMessageText("GUI_MESSAGES_USER_COUNT_0", new Object[0]), String.valueOf(user.size()));
        return infos;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected void openEditLoginMessageDialog() {
        Window window = CmsBasicDialog.prepareWindow();
        CmsEditLoginView dialog = new CmsEditLoginView(window);
        window.setContent((Component)dialog);
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_MESSAGES_LOGINMESSAGE_TOOL_NAME_0", new Object[0]));
        dialog.setWindowMinFullHeight(500);
        A_CmsUI.get().addWindow(window);
    }

    private void addInfoLayoutComponents() {
        TextField siteTableFilter = new TextField();
        siteTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        siteTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        siteTableFilter.addStyleName("inline-icon");
        siteTableFilter.setWidth("200px");
        siteTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsSessionsApp.this.m_table.filterTable(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)siteTableFilter);
    }

    private void addToolbarButtons() {
        Button add = CmsToolBar.createButton((Resource)FontOpenCms.LOGIN, CmsVaadinUtils.getMessageText("GUI_MESSAGES_LOGINMESSAGE_TOOL_NAME_0", new Object[0]));
        add.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSessionsApp.this.openEditLoginMessageDialog();
            }
        });
        this.m_uiContext.addToolbarButton((Component)add);
        Button broadcastToAll = CmsToolBar.createButton((Resource)FontOpenCms.BROADCAST, CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_TO_ALL_0", new Object[0]));
        broadcastToAll.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSessionsApp.showSendBroadcastDialog(null, CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_TO_ALL_0", new Object[0]), CmsSessionsApp.this.m_table);
            }
        });
        this.m_uiContext.addToolbarButton((Component)broadcastToAll);
        this.m_infoButton = this.getStatisticButton();
        this.m_uiContext.addToolbarButton((Component)this.m_infoButton);
        Button button = CmsToolBar.createButton((Resource)FontOpenCms.RESET, CmsVaadinUtils.getMessageText("GUI_MESSAGES_REFRESH_0", new Object[0]));
        button.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    CmsSessionsApp.this.m_table.ini();
                    CmsSessionsApp.this.m_infoButton.replaceData(CmsSessionsApp.this.getInfoMap());
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
        });
        this.m_uiContext.addToolbarButton((Component)button);
    }

    private CmsInfoButton getStatisticButton() {
        CmsInfoButton ret = new CmsInfoButton(this.getInfoMap());
        ret.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_MESSAGES_STATISTICS_CAPTION_0", new Object[0]));
        ret.setDescription(CmsVaadinUtils.getMessageText("GUI_MESSAGES_STATISTICS_CAPTION_0", new Object[0]));
        return ret;
    }

    static class MessageValidator
    implements Validator {
        private static final long serialVersionUID = -7720843154577253852L;

        MessageValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            if (value == null) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_MESSAGES_LOGINMESSAGE_VAL_EMPTY_MESSAGE_0", new Object[0]));
            }
            String message = (String)value;
            if (message.isEmpty()) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_MESSAGES_LOGINMESSAGE_VAL_EMPTY_MESSAGE_0", new Object[0]));
            }
        }
    }
}

