/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sessions;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.sessions.CmsSessionsTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsUserInfo;
import org.opencms.util.CmsDateUtil;

public class CmsUserInfoDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = -8358238253459658269L;
    static final Log LOG = CmsLog.getLog(CmsUserInfoDialog.class);
    protected CmsObject m_cms;
    protected CmsSessionInfo m_session;
    private Button m_cancelButton;
    private VerticalLayout m_layout;
    private Button m_okButton;
    private CmsUser m_user;

    private CmsUserInfoDialog() {
    }

    private CmsUserInfoDialog(CmsSessionInfo sessionInfo, Runnable closeRunnable) {
        this.m_session = sessionInfo;
        this.m_cms = A_CmsUI.getCmsObject();
        try {
            this.m_user = this.m_cms.readUser(sessionInfo.getUserId());
            this.init(closeRunnable);
        }
        catch (CmsException e) {
            LOG.error((Object)"Can not read user.", (Throwable)e);
        }
    }

    private CmsUserInfoDialog(CmsUser user, Runnable closeRunnable) {
        this.m_cms = A_CmsUI.getCmsObject();
        this.m_user = user;
        this.init(closeRunnable);
    }

    public static String getStatusForItem(Long lastActivity) {
        if (lastActivity < 450000L) {
            return CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_COLS_STATUS_ACTIVE_0", new Object[0]);
        }
        return CmsVaadinUtils.getMessageText("GUI_MESSAGES_BROADCAST_COLS_STATUS_INACTIVE_0", new Object[0]);
    }

    public static String getStatusStyleForItem(Long lastActivity) {
        if (lastActivity < 450000L) {
            return " o-box-cyan";
        }
        return " o-box-gray";
    }

    public static void showUserInfo(CmsSessionInfo session) {
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsUserInfoDialog dialog = new CmsUserInfoDialog(session, new Runnable(){

            @Override
            public void run() {
                window.close();
            }
        });
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_MESSAGES_SHOW_USER_0", new Object[0]));
        window.setContent((Component)dialog);
        A_CmsUI.get().addWindow(window);
    }

    public static void showUserInfo(CmsUser user) {
        final Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        CmsUserInfoDialog dialog = new CmsUserInfoDialog(user, new Runnable(){

            @Override
            public void run() {
                window.close();
            }
        });
        window.setCaption(CmsVaadinUtils.getMessageText("GUI_MESSAGES_SHOW_USER_0", new Object[0]));
        window.setContent((Component)dialog);
        A_CmsUI.get().addWindow(window);
    }

    private List<String> getFurtherInfoLines(CmsSessionInfo currentSession) {
        boolean neverActive = false;
        Long inacTime = 0L;
        ArrayList<String> res = new ArrayList<String>();
        if (currentSession == null) {
            inacTime = System.currentTimeMillis() - this.m_user.getLastlogin();
            neverActive = this.m_user.getLastlogin() == 0L;
        } else {
            inacTime = System.currentTimeMillis() - currentSession.getTimeLastAction();
        }
        String[] inactiveTime = CmsSessionInfo.getHourMinuteSecondTimeString(inacTime);
        if (!neverActive) {
            if (currentSession != null) {
                res.add("");
                res.add("<p>" + CmsVaadinUtils.getMessageText("GUI_SESSIONS_SESSION_INFO_0", new Object[0]) + "</p>");
                res.add(CmsVaadinUtils.getMessageText("GUI_MESSAGES_LAST_ACTIVITY_2", inactiveTime[1] + ":" + inactiveTime[2], CmsVaadinUtils.getMessageText("GUI_MESSAGES_MINUTES_0", new Object[0])) + this.getStatusHTML(inacTime));
            } else {
                res.add(this.getLastLoginMessage(inacTime));
            }
        }
        res.add(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_DATE_CREATED_0", new Object[0]) + ": " + CmsDateUtil.getDateTime(new Date(this.m_user.getDateCreated()), 3, A_CmsUI.get().getLocale()));
        if (currentSession != null) {
            res.add(CmsSessionsTable.TableProperty.Site.getLocalizedMessage() + ": " + this.getSiteTitle(currentSession));
            try {
                res.add(CmsSessionsTable.TableProperty.Project.getLocalizedMessage() + ": " + A_CmsUI.getCmsObject().readProject(currentSession.getProject()).getName());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to read project", (Throwable)e);
            }
        }
        return res;
    }

    private String getLastLoginMessage(Long inacTime) {
        int days = (int)(inacTime / 86400000L);
        if (days == 0) {
            return CmsVaadinUtils.getMessageText("GUI_USER_INFO_LAST_LOGIN_LESS_A_DAY_0", new Object[0]);
        }
        if (days == 1) {
            return CmsVaadinUtils.getMessageText("GUI_USER_INFO_LAST_LOGIN_YESTERDAY_0", new Object[0]);
        }
        return CmsVaadinUtils.getMessageText("GUI_USER_INFO_LAST_LOGIN_DAYS_AGO_1", days);
    }

    private CmsSessionInfo getSessionForUser(CmsUser user) {
        List<CmsSessionInfo> sessions = OpenCms.getSessionManager().getSessionInfos(user.getId());
        if (sessions.isEmpty()) {
            return null;
        }
        CmsSessionInfo currentSession = sessions.get(0);
        for (CmsSessionInfo session : sessions) {
            if (session.getTimeUpdated() <= currentSession.getTimeUpdated()) continue;
            currentSession = session;
        }
        return currentSession;
    }

    private String getSiteTitle(CmsSessionInfo currentSession) {
        String siteRoot = currentSession.getSiteRoot();
        return siteRoot.isEmpty() | siteRoot.equals("/") ? CmsVaadinUtils.getMessageText("GUI_ROOT_SITE_0", new Object[0]) : OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot).getTitle();
    }

    private String getStatusHTML(Long inacTime) {
        return "<span class=\"" + CmsUserInfoDialog.getStatusStyleForItem(inacTime) + "\">" + CmsUserInfoDialog.getStatusForItem(inacTime) + "</span> ";
    }

    private void init(final Runnable closeRunnable) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        CmsUserInfo info = new CmsUserInfo(this.m_user.getId(), "640px");
        final CmsSessionInfo session = this.m_session == null ? this.getSessionForUser(this.m_user) : this.m_session;
        Iterator<String> iterator = this.getFurtherInfoLines(session).iterator();
        while (iterator.hasNext()) {
            info.addDetailLine(iterator.next());
        }
        this.m_layout.addComponent((Component)info);
        if (session != null) {
            this.m_okButton.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 3096577957489665752L;

                public void buttonClick(Button.ClickEvent event) {
                    try {
                        A_CmsUI.get().changeProject(CmsUserInfoDialog.this.m_cms.readProject(session.getProject()));
                        A_CmsUI.get().changeSite(session.getSiteRoot());
                        String path = OpenCms.getSessionManager().switchUserFromSession(CmsUserInfoDialog.this.m_cms, CmsVaadinUtils.getRequest(), CmsUserInfoDialog.this.m_cms.readUser(session.getUserId()), session);
                        if (path == null) {
                            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
                            parameters.put("_lrid", new String[]{String.valueOf(System.currentTimeMillis())});
                            path = CmsVaadinUtils.getWorkplaceLink("explorer", session.getProject().getStringValue() + "!!" + session.getSiteRoot() + "!!" + "!!", parameters);
                        }
                        A_CmsUI.get().getPage().setLocation(path);
                        if (path.contains("/workplace#")) {
                            A_CmsUI.get().getPage().reload();
                        }
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                    closeRunnable.run();
                }
            });
        }
        this.setHideSwitchButton(session);
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -1033076596404978498L;

            public void buttonClick(Button.ClickEvent event) {
                closeRunnable.run();
            }
        });
    }

    private void setHideSwitchButton(CmsSessionInfo session) {
        boolean visible;
        boolean bl = visible = session != null;
        if (visible) {
            visible = !OpenCms.getSessionManager().getSessionInfo(CmsVaadinUtils.getRequest()).getSessionId().equals(session.getSessionId());
        }
        this.m_okButton.setVisible(visible);
    }
}

