/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Window;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsVfsImportExportHandler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.dbmanager.CmsExportThreadDialog;
import org.opencms.ui.apps.sitemanager.CmsSiteManager;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.util.CmsFileUtil;
import org.opencms.workplace.threads.CmsExportThread;

public class CmsExportSiteForm
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsExportSiteForm.class);
    protected Button m_cancel;
    protected CmsObject m_cms;
    protected CmsSiteManager m_manager;
    protected Button m_ok;
    protected Label m_projectLabel;
    protected String m_siteRoot;

    public CmsExportSiteForm(CmsObject cms, CmsSiteManager manager, String siteRoot) {
        this.m_manager = manager;
        this.m_siteRoot = siteRoot;
        this.m_cms = cms;
        String projectName = cms.getRequestContext().getCurrentProject().getName();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_projectLabel.setValue(CmsVaadinUtils.getMessageText("GUI_SITE_EXPORT_PROJECT_LABEL_1", projectName));
        this.m_cancel.addClickListener((Button.ClickListener & Serializable)event -> CmsVaadinUtils.closeWindow((Component)this));
        CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        if (site != null) {
            CmsResourceInfo resourceInfo = new CmsResourceInfo(site.getTitle(), site.getSiteRoot(), this.m_manager.getFavIcon(site.getSiteRoot()));
            resourceInfo.addStyleName("o-res-site-info");
            this.displayResourceInfoDirectly(Collections.singletonList(resourceInfo));
        }
        this.m_ok.addClickListener((Button.ClickListener & Serializable)event -> this.startThread());
    }

    protected void startThread() {
        CmsObject cms = null;
        try {
            cms = OpenCms.initCmsObject(this.m_cms);
        }
        catch (CmsException e1) {
            LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
        }
        cms.getRequestContext().setSiteRoot(this.m_siteRoot);
        CmsExportParameters m_exportParams = new CmsExportParameters();
        m_exportParams.setExportAccountData(false);
        m_exportParams.setExportAsFiles(false);
        m_exportParams.setExportProjectData(false);
        m_exportParams.setExportResourceData(true);
        m_exportParams.setInProject(false);
        m_exportParams.setIncludeSystemFolder(false);
        m_exportParams.setIncludeUnchangedResources(true);
        m_exportParams.setSkipParentFolders(false);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String dateStr = fmt.format(new Date());
        String filename = dateStr + "_" + CmsFileUtil.removeTrailingSeparator(CmsFileUtil.removeLeadingSeparator(this.m_siteRoot)).replace("/", "_") + ".zip";
        String exportFilePath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + File.separator + filename);
        m_exportParams.setPath(exportFilePath);
        m_exportParams.setRecursive(true);
        m_exportParams.setResources(Collections.singletonList("/"));
        m_exportParams.setExportMode(CmsModule.ExportMode.DEFAULT);
        m_exportParams.setContentAge(0L);
        CmsVfsImportExportHandler handler = new CmsVfsImportExportHandler();
        handler.setExportParams(m_exportParams);
        CmsExportThread exportThread = new CmsExportThread(cms, handler, false);
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.max);
        window.setContent((Component)new CmsExportThreadDialog(handler, exportThread, window));
        A_CmsUI.get().addWindow(window);
        CmsVaadinUtils.closeWindow((Component)this);
        exportThread.start();
    }
}

