/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.sitemanager;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.TextField;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSitesConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCRUDApp;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.sitemanager.CmsDeleteSiteDialog;
import org.opencms.ui.apps.sitemanager.CmsEditSiteForm;
import org.opencms.ui.apps.sitemanager.CmsGlobalForm;
import org.opencms.ui.apps.sitemanager.CmsSitesTable;
import org.opencms.ui.apps.sitemanager.CmsWebServerConfigForm;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsInfoButton;
import org.opencms.ui.components.CmsToolBar;

public class CmsSiteManager
extends A_CmsWorkplaceApp
implements I_CmsCRUDApp<CmsSite> {
    public static final String BUNDLE_NAME = "siteMacroBundle";
    public static final String FAVICON = "favicon.ico";
    public static final String MACRO_FOLDER = ".macros";
    public static final String PATH_NAME_ADD = "newSite";
    public static final String PATH_NAME_EDIT = "editSite";
    public static final String PATH_NAME_GLOBAL = "global";
    public static final String PATH_NAME_WEBSERVER = "webserver";
    public static final String SITE_ROOT = "siteRoot";
    static Log LOG = CmsLog.getLog(CmsSiteManager.class.getName());
    static final String PATH_SITES = "/sites/";
    protected Window m_dialogWindow;
    protected CmsSitesTable m_sitesTable;
    protected TextField m_siteTableFilter;
    private CmsInfoButton m_infoButton;
    private Button m_publishButton;
    private CmsObject m_rootCms;

    public static boolean isFolderWithMacros(CmsObject cms, String folderPathRoot) {
        if (!CmsResource.isFolder(folderPathRoot)) {
            folderPathRoot = folderPathRoot.concat("/");
        }
        try {
            cms.readResource(folderPathRoot + MACRO_FOLDER);
            cms.readResource(folderPathRoot + MACRO_FOLDER + "/" + BUNDLE_NAME + "_desc");
        }
        catch (CmsException e) {
            return false;
        }
        return true;
    }

    public static boolean isLetsEncryptConfiguredForWebserverThread() {
        return OpenCms.getLetsEncryptConfig() != null && OpenCms.getLetsEncryptConfig().isValidAndEnabled() && OpenCms.getLetsEncryptConfig().getTrigger() == CmsLetsEncryptConfiguration.Trigger.webserverThread;
    }

    public void centerWindow() {
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.center();
        }
    }

    public void closeDialogWindow(boolean updateTable) {
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.close();
            this.m_dialogWindow = null;
        }
        if (updateTable) {
            A_CmsUI.get().reload();
        }
    }

    @Override
    public void createElement(CmsSite element) {
        try {
            OpenCms.getSiteManager().addSite(this.getRootCmsObject(), element);
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to save site", (Throwable)e);
        }
    }

    @Override
    public void defaultAction(String elementId) {
        this.openEditDialog(elementId);
    }

    @Override
    public void deleteElements(List<String> elementId) {
        for (String siteRoot : elementId) {
            try {
                CmsSite site = this.getElement(siteRoot);
                if (site == null) continue;
                OpenCms.getSiteManager().removeSite(this.getRootCmsObject(), site);
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to delete site", (Throwable)e);
            }
        }
        this.updateInfo();
    }

    @Override
    public List<CmsSite> getAllElements() {
        List<CmsSite> res = OpenCms.getSiteManager().getAvailableSites(this.getRootCmsObject(), false).stream().filter(site -> !site.isGenerated()).collect(Collectors.toList());
        return res;
    }

    public List<CmsSite> getCorruptedSites() {
        return OpenCms.getSiteManager().getAvailableCorruptedSites(this.getRootCmsObject(), true);
    }

    @Override
    public CmsSite getElement(String elementId) {
        return OpenCms.getSiteManager().getSiteForSiteRoot(elementId);
    }

    public Resource getFavIcon(String siteRoot) {
        CmsResource iconResource = null;
        try {
            iconResource = this.getRootCmsObject().readResource(siteRoot + "/" + FAVICON);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (iconResource != null) {
            return new ExternalResource(OpenCms.getLinkManager().getPermalink(this.getRootCmsObject(), iconResource.getRootPath()));
        }
        return new CmsCssIcon("oc-icon-24-site");
    }

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(changes -> A_CmsUI.get().reload());
        super.initUI(context);
    }

    public boolean isExportEnabled() {
        return this.getClass() == CmsSiteManager.class;
    }

    public void openDeleteDialog(Set<String> data) {
        CmsDeleteSiteDialog form = new CmsDeleteSiteDialog(this, data);
        this.openDialog(form, CmsVaadinUtils.getMessageText("GUI_SITE_DELETE_0", new Object[0]));
    }

    public void openEditDialog(String siteRoot) {
        String caption;
        CmsEditSiteForm form;
        if (siteRoot != null) {
            form = new CmsEditSiteForm(this.m_rootCms, this, siteRoot);
            caption = CmsVaadinUtils.getMessageText("GUI_SITE_CONFIGURATION_EDIT_1", this.m_sitesTable.getContainer().getItem((Object)siteRoot).getItemProperty((Object)CmsSitesTable.TableProperty.Title).getValue());
        } else {
            form = new CmsEditSiteForm(this.m_rootCms, this);
            caption = CmsVaadinUtils.getMessageText("GUI_SITE_ADD_0", new Object[0]);
        }
        this.openDialog(form, caption);
    }

    public void openSettingsDailog() {
        CmsGlobalForm form = new CmsGlobalForm(this);
        this.openDialog(form, CmsVaadinUtils.getMessageText("GUI_SITE_GLOBAL_CONFIGURATION_0", new Object[0]));
    }

    public void openUpdateServerConfigDailog() {
        CmsWebServerConfigForm form = new CmsWebServerConfigForm(this);
        this.openDialog(form, CmsVaadinUtils.getMessageText("GUI_SITE_WEBSERVERCONFIG_0", new Object[0]));
    }

    public void updateGeneralSettings(CmsObject cms, String defaultUri, Map<String, CmsSSLMode> workplaceServers, String sharedFolder) {
        try {
            OpenCms.getSiteManager().updateGeneralSettings(cms, defaultUri, workplaceServers, sharedFolder);
            OpenCms.writeConfiguration(CmsSitesConfiguration.class);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    @Override
    public void writeElement(CmsSite element) {
        try {
            OpenCms.getSiteManager().updateSite(this.m_rootCms, this.getElement(element.getSiteRoot()), element);
        }
        catch (CmsException e) {
            LOG.error((Object)"Unabel to update site", (Throwable)e);
        }
    }

    protected CmsSitesTable createSitesTable() {
        CmsSitesTable table = new CmsSitesTable(this);
        table.loadSites();
        return table;
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        crumbs.put("", CmsVaadinUtils.getMessageText("GUI_SITE_MANAGER_TITLE_SHORT_0", new Object[0]));
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        this.m_sitesTable = this.createSitesTable();
        this.m_rootLayout.setMainHeightFull(true);
        this.m_siteTableFilter = new TextField();
        this.m_siteTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        this.m_siteTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_siteTableFilter.addStyleName("inline-icon");
        this.m_siteTableFilter.setWidth("200px");
        this.m_siteTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                CmsSiteManager.this.m_sitesTable.filter(event.getText());
            }
        });
        this.m_infoLayout.addComponent((Component)this.m_siteTableFilter);
        this.addToolbarButtons();
        return this.m_sitesTable;
    }

    protected CmsObject getRootCmsObject() {
        if (this.m_rootCms == null) {
            this.m_rootCms = this.getOfflineCmsObject(A_CmsUI.getCmsObject());
            this.m_rootCms.getRequestContext().setSiteRoot("");
        }
        return this.m_rootCms;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }

    protected void openDialog(CmsBasicDialog dialog, String windowCaption) {
        if (this.m_dialogWindow != null) {
            this.m_dialogWindow.close();
        }
        this.m_dialogWindow = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        this.m_dialogWindow.setContent((Component)dialog);
        this.m_dialogWindow.setCaption(windowCaption);
        A_CmsUI.get().addWindow(this.m_dialogWindow);
        this.m_dialogWindow.center();
    }

    protected void updateInfo() {
        this.m_infoButton.replaceData(this.getInfoMap());
    }

    private void addToolbarButtons() {
        Button add = CmsToolBar.createButton((Resource)FontOpenCms.WAND, CmsVaadinUtils.getMessageText("GUI_SITE_ADD_0", new Object[0]));
        add.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteManager.this.openEditDialog(null);
            }
        });
        this.m_uiContext.addToolbarButton((Component)add);
        Button settings = CmsToolBar.createButton((Resource)FontOpenCms.SETTINGS, CmsVaadinUtils.getMessageText("GUI_SITE_GLOBAL_0", new Object[0]));
        settings.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSiteManager.this.openSettingsDailog();
            }
        });
        this.m_uiContext.addToolbarButton((Component)settings);
        if (OpenCms.getSiteManager().isConfigurableWebServer() || CmsSiteManager.isLetsEncryptConfiguredForWebserverThread()) {
            Button webServer = CmsToolBar.createButton((Resource)FontAwesome.SERVER, CmsVaadinUtils.getMessageText("GUI_SITE_WEBSERVERCONFIG_0", new Object[0]));
            webServer.addClickListener(new Button.ClickListener(){
                private static final long serialVersionUID = 1L;

                public void buttonClick(Button.ClickEvent event) {
                    CmsSiteManager.this.openUpdateServerConfigDailog();
                }
            });
            this.m_uiContext.addToolbarButton((Component)webServer);
        }
        this.m_infoButton = new CmsInfoButton(this.getInfoMap());
        this.m_infoButton.setWindowCaption(CmsVaadinUtils.getMessageText("GUI_SITE_STATISTICS_CAPTION_0", new Object[0]));
        this.m_infoButton.setDescription(CmsVaadinUtils.getMessageText("GUI_SITE_STATISTICS_CAPTION_0", new Object[0]));
        this.m_uiContext.addToolbarButton((Component)this.m_infoButton);
    }

    private Map<String, String> getInfoMap() {
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        int corruptedSites = this.getCorruptedSites().size();
        infos.put(CmsVaadinUtils.getMessageText("GUI_SITE_STATISTICS_NUM_WEBSITES_0", new Object[0]), String.valueOf(this.getAllElements().size() + corruptedSites));
        if (corruptedSites > 0) {
            infos.put(CmsVaadinUtils.getMessageText("GUI_SITE_STATISTICS_NUM_CORRUPTED_WEBSITES_0", new Object[0]), String.valueOf(corruptedSites));
        }
        return infos;
    }
}

