/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsPrincipal;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsAvailableRoleOrPrincipalTable;
import org.opencms.ui.apps.user.CmsCurrentRoleOrPrincipalTable;
import org.opencms.ui.apps.user.FixedHeightPanel;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsUUID;

public abstract class A_CmsEditUserGroupRoleDialog
extends CmsBasicDialog {
    private static final String ITEM_HEIGHT = "550px";
    private static final Log LOG = CmsLog.getLog(A_CmsEditUserGroupRoleDialog.class);
    private static final long serialVersionUID = -5088800626506962263L;
    protected CmsAccountsApp m_app;
    protected CmsObject m_cms;
    protected CmsPrincipal m_principal;

    public A_CmsEditUserGroupRoleDialog(CmsObject cms, CmsUUID userId, final Window window, final CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cms = cms;
        this.m_app = app;
        try {
            this.m_principal = this.m_cms.readUser(userId);
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_principal)));
            window.setCaption(CmsVaadinUtils.getMessageText(this.getWindowCaptionMessageKey(), this.m_principal.getSimpleName()));
        }
        catch (CmsException e) {
            LOG.error((Object)"Can't read user", (Throwable)e);
        }
        this.getHLayout().setExpandRatio(this.getHLayout().getComponent(0), 1.0f);
        this.getHLayout().setExpandRatio(this.getHLayout().getComponent(1), 1.0f);
        this.getCloseButton().addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -6272630588945629762L;

            public void buttonClick(Button.ClickEvent event) {
                window.close();
                app.reload();
            }
        });
        this.init();
    }

    public abstract void addItem(Set<String> var1);

    public abstract String getAddActionCaption();

    public abstract String getAddCaptionText();

    public abstract IndexedContainer getAvailableItemsIndexedContainer(String var1, String var2);

    public abstract Button getCloseButton();

    public abstract String getCurrentTableCaption();

    public abstract String getDescriptionForItemId(Object var1);

    public abstract String getEmptyMessage();

    public abstract String getFurtherColumnId();

    public abstract HorizontalLayout getHLayout();

    public abstract String getItemName();

    public abstract IndexedContainer getItemsOfUserIndexedContainer(String var1, String var2, String var3);

    public abstract VerticalLayout getLeftTableLayout();

    public abstract VerticalLayout getParentLayout();

    public abstract VerticalLayout getRightTableLayout();

    public abstract Set<String> getStringSetValue(Set<Object> var1);

    public abstract String getWindowCaptionMessageKey();

    public abstract void removeItem(Set<String> var1);

    protected void init() {
        this.setHeightUndefined();
        this.removeExistingTable(this.getLeftTableLayout());
        this.removeExistingTable(this.getRightTableLayout());
        final CmsAvailableRoleOrPrincipalTable table = new CmsAvailableRoleOrPrincipalTable(this);
        if (this.getAvailableItemsIndexedContainer("caption", "icon").size() > 0) {
            this.getRightTableLayout().addComponent((Component)new FixedHeightPanel((Component)table, ITEM_HEIGHT), 0);
        } else {
            this.getRightTableLayout().addComponent((Component)new FixedHeightPanel((Component)CmsVaadinUtils.getInfoLayout(this.getEmptyMessage()), ITEM_HEIGHT));
        }
        if (this.getItemsOfUserIndexedContainer("prop1", "prop2", "prop3").size() > 0) {
            this.getLeftTableLayout().addComponent((Component)new FixedHeightPanel((Component)new CmsCurrentRoleOrPrincipalTable(this, this.m_cms, this.m_principal), ITEM_HEIGHT), 0);
        } else {
            this.getLeftTableLayout().addComponent((Component)new FixedHeightPanel((Component)CmsVaadinUtils.getInfoLayout(this.getEmptyMessage()), ITEM_HEIGHT));
        }
        TextField siteTableFilter = new TextField();
        siteTableFilter.setIcon((Resource)FontOpenCms.FILTER);
        siteTableFilter.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        siteTableFilter.addStyleName("inline-icon");
        siteTableFilter.setWidth("200px");
        siteTableFilter.addTextChangeListener(new FieldEvents.TextChangeListener(){
            private static final long serialVersionUID = 1L;

            public void textChange(FieldEvents.TextChangeEvent event) {
                table.filterTable(event.getText());
            }
        });
        if (this.getParentLayout().getComponent(0) instanceof TextField) {
            this.getParentLayout().removeComponent(this.getParentLayout().getComponent(1));
            this.getParentLayout().removeComponent(this.getParentLayout().getComponent(0));
        }
        HorizontalLayout caps = new HorizontalLayout();
        caps.setSpacing(true);
        caps.setWidth("100%");
        caps.setHeight("30px");
        caps.addComponent((Component)new Label(this.getCurrentTableCaption()));
        caps.addComponent((Component)new Label(this.getAddCaptionText()));
        this.getParentLayout().addComponent((Component)caps, 0);
        this.getParentLayout().addComponent((Component)siteTableFilter, 0);
        this.getParentLayout().setComponentAlignment((Component)siteTableFilter, Alignment.TOP_RIGHT);
        this.getParentLayout().setExpandRatio(this.getParentLayout().getComponent(2), 1.0f);
    }

    private void removeExistingTable(VerticalLayout layout) {
        ArrayList<Component> tobeRemoved = new ArrayList<Component>();
        for (Component comp : layout) {
            if (!(comp instanceof FixedHeightPanel | comp instanceof TextField | comp instanceof VerticalLayout)) continue;
            tobeRemoved.add(comp);
        }
        for (Component c : tobeRemoved) {
            layout.removeComponent(c);
        }
    }
}

