/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.apps.user.CmsGroupsOfUserTable;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.util.CmsUUID;

public class CmsMoveUserToOU
extends CmsBasicDialog {
    static Log LOG = CmsLog.getLog(CmsMoveUserToOU.class.getName());
    private static final long serialVersionUID = 1L;
    protected CmsObject m_cms;
    CmsUser m_user;
    private Button m_cancel;
    private VerticalLayout m_error;
    private CmsGroupsOfUserTable m_groupTable;
    private Button m_ok;
    private ComboBox m_ou;
    private CheckBox m_removeAll;

    public CmsMoveUserToOU(CmsObject cms, CmsUUID userID, Window window, CmsAccountsApp app) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_cms = cms;
        try {
            this.m_user = cms.readUser(userID);
            this.displayResourceInfoDirectly(Collections.singletonList(CmsAccountsApp.getPrincipalInfo(this.m_user)));
            List<CmsGroup> groups = cms.getGroupsOfUser(this.m_user.getName(), true);
            if (!groups.isEmpty()) {
                this.m_error.setVisible(true);
                this.m_groupTable.init(app, this.m_cms, this.m_user, groups);
                this.m_ok.setEnabled(false);
                this.m_removeAll.addValueChangeListener(new Property.ValueChangeListener(){
                    private static final long serialVersionUID = 1L;

                    public void valueChange(Property.ValueChangeEvent event) {
                        CmsMoveUserToOU.this.setOkState();
                    }
                });
            }
            this.m_ou.setContainerDataSource(CmsVaadinUtils.getOUComboBox(this.m_cms, "", LOG, false).getContainerDataSource());
            this.m_ou.setItemCaptionPropertyId((Object)"desc");
            this.m_ou.setNewItemsAllowed(false);
            this.m_ou.setFilteringMode(FilteringMode.CONTAINS);
            this.m_ou.select((Object)"");
            this.m_ou.setNullSelectionAllowed(false);
        }
        catch (CmsException e2) {
            LOG.error((Object)("Cannot read user with id " + userID), (Throwable)e2);
        }
        this.m_ou.addValidator((Validator)new OUValidator());
        this.m_ok.addClickListener((Button.ClickListener & Serializable)e -> this.submit(window, app));
        this.m_cancel.addClickListener((Button.ClickListener & Serializable)e -> window.close());
    }

    protected void setOkState() {
        this.m_ok.setEnabled(((Boolean)this.m_removeAll.getValue()).booleanValue());
    }

    protected void submit(Window window, CmsAccountsApp app) {
        if (this.m_ou.isValid()) {
            try {
                ArrayList<CmsGroup> userGroups = new ArrayList<CmsGroup>();
                for (CmsGroup group : this.m_cms.getGroupsOfUser(this.m_user.getName(), true)) {
                    userGroups.add(group);
                }
                ArrayList<CmsRole> directOURoles = new ArrayList<CmsRole>();
                ArrayList<CmsRole> otherRoles = new ArrayList<CmsRole>();
                for (CmsRole role : OpenCms.getRoleManager().getRolesOfUser(this.m_cms, this.m_user.getName(), this.m_user.getOuFqn(), true, true, false)) {
                    if (this.m_user.getOuFqn().equals(role.getOuFqn())) {
                        directOURoles.add(role);
                        OpenCms.getRoleManager().removeUserFromRole(this.m_cms, role, this.m_user.getName());
                        continue;
                    }
                    if (role.getOuFqn().startsWith(this.m_user.getOuFqn())) {
                        OpenCms.getRoleManager().removeUserFromRole(this.m_cms, role, this.m_user.getName());
                        continue;
                    }
                    otherRoles.add(role);
                }
                for (CmsGroup group : userGroups) {
                    try {
                        this.m_cms.removeUserFromGroup(this.m_user.getName(), group.getName());
                    }
                    catch (CmsIllegalArgumentException e) {
                        LOG.error((Object)"User cannot be removed from group", (Throwable)e);
                    }
                }
                OpenCms.getOrgUnitManager().setUsersOrganizationalUnit(this.m_cms, (String)this.m_ou.getValue(), this.m_user.getName());
                this.m_user = this.m_cms.readUser(this.m_user.getId());
                for (CmsRole role : directOURoles) {
                    OpenCms.getRoleManager().addUserToRole(this.m_cms, role.forOrgUnit((String)this.m_ou.getValue()), this.m_user.getName());
                }
                for (CmsRole role : otherRoles) {
                    OpenCms.getRoleManager().addUserToRole(this.m_cms, role, this.m_user.getName());
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to move the user to anouther OU", (Throwable)e);
            }
            window.close();
            app.reload();
        }
    }

    class OUValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        OUValidator() {
        }

        public void validate(Object value) throws Validator.InvalidValueException {
            String ou = (String)value;
            if (CmsMoveUserToOU.this.m_user.getOuFqn().equals(ou)) {
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_MOVE_OU_SAME_OU_0", new Object[0]));
            }
            try {
                CmsMoveUserToOU.this.m_cms.readUser(ou + CmsMoveUserToOU.this.m_user.getSimpleName());
                throw new Validator.InvalidValueException(CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_MOVE_OU_USERNAME_COLLISION_0", new Object[0]));
            }
            catch (CmsException cmsException) {
                return;
            }
        }
    }
}

