/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import org.opencms.file.CmsObject;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.I_CmsOuTreeType;

public enum CmsOuTreeType implements I_CmsOuTreeType
{
    GROUP("GUI_USERMANAGEMENT_GROUPS_0", "g", true, new CmsCssIcon("oc-icon-24-group"), "GUI_USERMANAGEMENT_NO_GROUPS_0"),
    OU("GUI_USERMANAGEMENT_USER_OU_0", "o", true, new CmsCssIcon("oc-icon-24-orgunit"), ""),
    ROLE("GUI_USERMANAGEMENT_ROLES_0", "r", true, new CmsCssIcon("oc-icon-24-role"), "GUI_USERMANAGEMENT_NO_USER_0"),
    USER("GUI_USERMANAGEMENT_USERS_0", "u", false, new CmsCssIcon("oc-icon-24-user"), "GUI_USERMANAGEMENT_NO_USER_0");

    private String m_emptyMessageKey;
    private CmsCssIcon m_icon;
    private String m_id;
    private boolean m_isExpandable;
    private String m_name;

    private CmsOuTreeType(String name, String id, boolean isExpandable, CmsCssIcon icon, String empty) {
        this.m_name = name;
        this.m_id = id;
        this.m_isExpandable = isExpandable;
        this.m_icon = icon;
        this.m_emptyMessageKey = empty;
    }

    @Override
    public String getEmptyMessageKey() {
        return this.m_emptyMessageKey;
    }

    @Override
    public CmsCssIcon getIcon() {
        return this.m_icon;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return CmsVaadinUtils.getMessageText(this.m_name, new Object[0]);
    }

    @Override
    public boolean isExpandable() {
        return this.m_isExpandable;
    }

    @Override
    public boolean isGroup() {
        return GROUP.equals(this);
    }

    @Override
    public boolean isOrgUnit() {
        return OU.equals(this);
    }

    @Override
    public boolean isRole() {
        return ROLE.equals(this);
    }

    @Override
    public boolean isUser() {
        return USER.equals(this);
    }

    @Override
    public boolean isValidForOu(CmsObject cms, String ou) {
        return true;
    }

    @Override
    public boolean showInOuTable() {
        return !OU.equals(this);
    }
}

