/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.notification.A_CmsNotification;
import org.opencms.util.CmsMacroResolver;

public class CmsSendPasswordNotification
extends A_CmsNotification {
    private static final String FIELD_CHANGE_PASSWORD = "TextChangePassword";
    private static final String FIELD_KEEP_PASSWORD = "TextKeepPassword";
    private boolean m_new;
    private boolean m_tempPassword;

    public CmsSendPasswordNotification(CmsObject cms, String password, CmsUser receiver, String ou, CmsUser adminUser, boolean newUser, boolean tempPassword) {
        super(cms, receiver);
        this.m_new = newUser;
        this.m_tempPassword = tempPassword;
        this.addMacro("password", password);
        String link = OpenCms.getLinkManager().getWorkplaceLink(cms, "/system/login", false) + "?" + "ocUname" + "=" + receiver.getSimpleName() + "&" + "ocOuFqn" + "=" + receiver.getOuFqn();
        this.addMacro("workplace.login-url.html", "<a href =\"" + link + "\">" + link + "</a>");
        this.addMacro("receiver.ou-fqn", ou);
        try {
            this.addMacro("receiver.ou", OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, ou).getDisplayName(new CmsUserSettings(receiver).getLocale()));
        }
        catch (CmsException e) {
            this.addMacro("receiver.ou", receiver.getOuFqn());
        }
    }

    @Deprecated
    public CmsSendPasswordNotification(CmsObject cms, String password, CmsUser receiver, String ou, CmsUser adminUser, String link, boolean newUser, boolean tempPassword) {
        this(cms, password, receiver, ou, adminUser, newUser, tempPassword);
    }

    @Override
    protected void appendXMLContent(StringBuffer msg) {
        String xmlName = this.m_tempPassword ? FIELD_CHANGE_PASSWORD : FIELD_KEEP_PASSWORD;
        msg.append(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, xmlName, this.m_locale), this.m_macroResolver));
        msg.append("\n<br/><br/>\n");
        msg.append(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Footer", this.m_locale), this.m_macroResolver));
    }

    @Override
    protected String generateHtmlMsg() {
        return "";
    }

    @Override
    protected String getNotificationContent() {
        if (this.m_new) {
            return OpenCms.getSystemInfo().getConfigFilePath(this.m_cms, "notification/password-new-user-notification");
        }
        return OpenCms.getSystemInfo().getConfigFilePath(this.m_cms, "notification/password-new-password-from-admin-notification");
    }
}

