/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.user;

import com.vaadin.ui.Button;
import com.vaadin.ui.Window;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.A_CmsEditUserGroupRoleDialog;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.util.CmsUUID;

public class CmsUserEditRoleDialog
extends A_CmsEditUserGroupRoleDialog {
    private static final Log LOG = CmsLog.getLog(CmsUserEditRoleDialog.class);
    private static final long serialVersionUID = -5734296145021453705L;
    Button m_close;
    HorizontalLayout m_hlayout;
    VerticalLayout m_leftTableHolder;
    VerticalLayout m_rightTableHolder;
    VerticalLayout m_vlayout;

    public CmsUserEditRoleDialog(CmsObject cms, CmsUUID userId, Window window, CmsAccountsApp app) {
        super(cms, userId, window, app);
    }

    @Override
    public void addItem(Set<String> data) {
        for (String roleName : data) {
            try {
                OpenCms.getRoleManager().addUserToRole(this.m_cms, CmsRole.valueOfRoleName(roleName), this.m_principal.getName());
            }
            catch (CmsException e) {
                LOG.error((Object)"Unable to add user to role", (Throwable)e);
            }
        }
    }

    @Override
    public String getAddActionCaption() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_ADD_ROLE_0", new Object[0]);
    }

    @Override
    public String getAddCaptionText() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_CHOOSE_ROLE_0", new Object[0]);
    }

    @Override
    public IndexedContainer getAvailableItemsIndexedContainer(String caption, String icon) {
        try {
            List<CmsRole> roles = OpenCms.getRoleManager().getRoles(this.m_cms, this.m_principal.getOuFqn(), false);
            ArrayList<CmsRole> invisibleRoles = new ArrayList<CmsRole>();
            for (CmsRole role : roles) {
                if (OpenCms.getRoleManager().hasRole(this.m_cms, this.m_cms.getRequestContext().getCurrentUser().getName(), role)) continue;
                invisibleRoles.add(role);
            }
            roles.removeAll(invisibleRoles);
            CmsRole.applySystemRoleOrder(roles);
            List<CmsRole> userRoles = OpenCms.getRoleManager().getRolesOfUser(this.m_cms, this.m_principal.getName(), this.m_principal.getOuFqn(), false, false, false);
            IndexedContainer container = new IndexedContainer();
            container.addContainerProperty((Object)caption, String.class, (Object)"");
            container.addContainerProperty((Object)icon, CmsCssIcon.class, (Object)new CmsCssIcon("oc-icon-24-role"));
            for (CmsRole role : roles) {
                if (userRoles.contains(role)) continue;
                Item item = container.addItem((Object)role);
                item.getItemProperty((Object)caption).setValue((Object)role.getDisplayName(this.m_cms, A_CmsUI.get().getLocale()));
            }
            return container;
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to get roles", (Throwable)e);
            return null;
        }
    }

    @Override
    public Button getCloseButton() {
        return this.m_close;
    }

    @Override
    public String getCurrentTableCaption() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_EDIT_CURRENTLY_SET_ROLES_0", new Object[0]);
    }

    @Override
    public String getDescriptionForItemId(Object itemId) {
        CmsRole role = (CmsRole)itemId;
        return role.getDescription(this.m_cms.getRequestContext().getLocale());
    }

    @Override
    public String getEmptyMessage() {
        return "GUI_USERMANAGEMENT_EDIT_EMPTY_ROLES_0";
    }

    @Override
    public String getFurtherColumnId() {
        return null;
    }

    @Override
    public HorizontalLayout getHLayout() {
        return this.m_hlayout;
    }

    @Override
    public String getItemName() {
        return CmsVaadinUtils.getMessageText("GUI_USERMANAGEMENT_USER_NAME_0", new Object[0]);
    }

    @Override
    public IndexedContainer getItemsOfUserIndexedContainer(String propName, String propIcon, String propStatus) {
        try {
            List<CmsRole> userRoles = OpenCms.getRoleManager().getRolesOfUser(this.m_cms, this.m_principal.getName(), this.m_principal.getOuFqn(), false, false, false);
            CmsRole.applySystemRoleOrder(userRoles);
            List<CmsRole> directRoles = OpenCms.getRoleManager().getRolesOfUser(this.m_cms, this.m_principal.getName(), "", true, true, true);
            for (CmsRole directRole : directRoles) {
                if (userRoles.contains(directRole)) continue;
                userRoles.add(directRole);
            }
            IndexedContainer container = new IndexedContainer();
            container.addContainerProperty((Object)propName, String.class, (Object)"");
            container.addContainerProperty((Object)propIcon, CmsCssIcon.class, (Object)new CmsCssIcon("oc-icon-24-role"));
            container.addContainerProperty((Object)propStatus, Boolean.class, (Object)true);
            for (CmsRole role : userRoles) {
                Item item = container.addItem((Object)role);
                item.getItemProperty((Object)propName).setValue((Object)role.getDisplayName(this.m_cms, A_CmsUI.get().getLocale()));
                item.getItemProperty((Object)propStatus).setValue((Object)directRoles.contains(role));
            }
            return container;
        }
        catch (CmsException e) {
            LOG.error((Object)"unable to get roles", (Throwable)e);
            return null;
        }
    }

    @Override
    public VerticalLayout getLeftTableLayout() {
        return this.m_leftTableHolder;
    }

    @Override
    public VerticalLayout getParentLayout() {
        return this.m_vlayout;
    }

    @Override
    public VerticalLayout getRightTableLayout() {
        return this.m_rightTableHolder;
    }

    @Override
    public Set<String> getStringSetValue(Set<Object> value) {
        HashSet<String> res = new HashSet<String>();
        for (Object o : value) {
            CmsRole role = (CmsRole)o;
            res.add(role.getFqn());
        }
        return res;
    }

    @Override
    public String getWindowCaptionMessageKey() {
        return "GUI_USERMANAGEMENT_EDIT_USERROLES_1";
    }

    @Override
    public void removeItem(Set<String> items) {
        try {
            Iterator<String> iterator = items.iterator();
            while (iterator.hasNext()) {
                CmsRole role = CmsRole.valueOfRoleName(iterator.next());
                OpenCms.getRoleManager().removeUserFromRole(this.m_cms, role, this.m_principal.getName());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)"Unable to remove user from role", (Throwable)e);
        }
    }
}

