/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsCopyToClipboardButton;
import org.opencms.util.CmsUUID;

public class CmsErrorDialog
extends CmsBasicDialog {
    private static final long serialVersionUID = 1L;
    private Label m_errorLabel;
    private Label m_errorMessage;
    private Label m_icon;
    private Label m_hiddenStack;
    private Button m_okButton;
    private Runnable m_onClose;
    private Window m_window;
    private CssLayout m_details;
    private CmsCopyToClipboardButton m_copyText;
    private Button m_detailsButton;

    public CmsErrorDialog(String message, Throwable t, Runnable onClose, Window window) {
        this.m_onClose = onClose;
        this.m_window = window;
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        this.m_icon.setContentMode(ContentMode.HTML);
        this.m_icon.setValue(FontOpenCms.ERROR.getHtml());
        this.m_errorLabel.setContentMode(ContentMode.PREFORMATTED);
        String labelId = "label" + new CmsUUID().toString();
        String stacktrace = message + "\n\n" + ExceptionUtils.getStackTrace((Throwable)t);
        this.m_hiddenStack.setId(labelId);
        this.m_hiddenStack.setValue(stacktrace);
        this.m_errorLabel.setValue(stacktrace);
        this.m_errorLabel.addStyleName("o-full-width-padding");
        this.m_errorMessage.setContentMode(ContentMode.HTML);
        this.m_errorMessage.setValue(message);
        this.m_copyText.setSelector("#" + labelId);
        this.m_details.setVisible(false);
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsErrorDialog.this.onClose();
            }
        });
        this.m_detailsButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsErrorDialog.this.toggleDetails();
            }
        });
        if (this.m_window != null) {
            this.m_window.addCloseListener(new Window.CloseListener(){
                private static final long serialVersionUID = 1L;

                public void windowClose(Window.CloseEvent e) {
                    CmsErrorDialog.this.onClose();
                }
            });
        }
    }

    public static void showErrorDialog(String message, Throwable t) {
        CmsErrorDialog.showErrorDialog(message, t, null);
    }

    public static void showErrorDialog(String message, Throwable t, Runnable onClose) {
        Window window = CmsErrorDialog.prepareWindow(CmsBasicDialog.DialogWidth.wide);
        window.setCaption(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_ERROR_0"));
        window.setContent((Component)new CmsErrorDialog(message, t, onClose, window));
        A_CmsUI.get().addWindow(window);
    }

    public static void showErrorDialog(Throwable t) {
        CmsErrorDialog.showErrorDialog(t.getLocalizedMessage(), t, null);
    }

    public static void showErrorDialog(Throwable t, Runnable onClose) {
        CmsErrorDialog.showErrorDialog(t.getLocalizedMessage(), t, onClose);
    }

    void onClose() {
        if (this.m_onClose != null) {
            this.m_onClose.run();
        }
        if (this.m_window != null) {
            this.m_window.close();
        }
    }

    void toggleDetails() {
        this.m_details.setVisible(!this.m_details.isVisible());
        if (this.m_window != null) {
            this.m_window.center();
        }
    }
}

