/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.server.Resource;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import java.util.List;
import org.opencms.file.types.A_CmsResourceTypeFolderBase;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsTypeSelector
extends ComboBox {
    private static final long serialVersionUID = 1L;

    public CmsTypeSelector() {
        this.setCaption(CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_RESOURCE_TYPE_0", new Object[0]));
        this.setDescription(CmsVaadinUtils.getMessageText("GUI_SOURCESEARCH_RESOURCE_TYPE_HELP_0", new Object[0]));
        this.setWidthFull();
    }

    public void updateTypes(List<I_CmsResourceType> resourceTypes) {
        IndexedContainer types = this.generateResourceTypesContainer(resourceTypes);
        types.addContainerFilter(CmsVaadinUtils.FILTER_NO_FOLDERS);
        this.setContainerDataSource((Container)types);
        this.setItemCaptionPropertyId((Object)CmsVaadinUtils.PropertyId.caption);
        this.setItemIconPropertyId((Object)CmsVaadinUtils.PropertyId.icon);
        this.setFilteringMode(FilteringMode.CONTAINS);
    }

    private IndexedContainer generateResourceTypesContainer(List<I_CmsResourceType> resourceTypes) {
        CmsVaadinUtils.sortResourceTypes(resourceTypes);
        IndexedContainer types = new IndexedContainer();
        types.addContainerProperty((Object)CmsVaadinUtils.PropertyId.caption, String.class, null);
        types.addContainerProperty((Object)CmsVaadinUtils.PropertyId.icon, Resource.class, null);
        types.addContainerProperty((Object)CmsVaadinUtils.PropertyId.isFolder, Boolean.class, null);
        types.addContainerProperty((Object)CmsVaadinUtils.PropertyId.isXmlContent, Boolean.class, null);
        for (I_CmsResourceType type : resourceTypes) {
            CmsExplorerTypeSettings typeSetting = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
            if (typeSetting == null) continue;
            Item typeItem = types.addItem((Object)type);
            String caption = CmsVaadinUtils.getMessageText(typeSetting.getKey(), new Object[0]) + " (" + type.getTypeName() + ")";
            typeItem.getItemProperty((Object)CmsVaadinUtils.PropertyId.caption).setValue((Object)caption);
            typeItem.getItemProperty((Object)CmsVaadinUtils.PropertyId.icon).setValue((Object)CmsResourceUtil.getSmallIconResource(typeSetting, null));
            typeItem.getItemProperty((Object)CmsVaadinUtils.PropertyId.isXmlContent).setValue((Object)(type instanceof CmsResourceTypeXmlContent));
            typeItem.getItemProperty((Object)CmsVaadinUtils.PropertyId.isFolder).setValue((Object)(type instanceof A_CmsResourceTypeFolderBase));
        }
        return types;
    }
}

