/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.components;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.data.util.ObjectProperty;
import com.vaadin.v7.data.util.PropertysetItem;
import com.vaadin.v7.data.util.converter.Converter;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.ui.TextField;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.util.CmsNullToEmptyConverter;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsAccountInfo;

public class CmsUserDataFormLayout
extends FormLayout {
    private static final Log LOG = CmsLog.getLog(CmsUserDataFormLayout.class);
    private static final long serialVersionUID = 4893705558720239863L;
    private FieldGroup m_binder;
    private EditLevel m_editLevel;
    private PropertysetItem m_infos;

    public void initFields(CmsUser user) {
        this.initFields(user, EditLevel.configured);
    }

    public void initFields(CmsUser user, EditLevel editLevel) {
        this.m_editLevel = editLevel;
        this.m_infos = new PropertysetItem();
        for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
            String value = "";
            if (user != null && (value = info.getValue(user)) == null) {
                value = "";
            }
            this.m_infos.addItemProperty((Object)info, (Property)new ObjectProperty((Object)value));
        }
        this.m_binder = new FieldGroup((Item)this.m_infos);
        for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
            this.addComponent((Component)this.buildField(this.getLabel(info), info));
        }
    }

    public boolean isValid() {
        boolean valid = true;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Component comp = (Component)iterator.next();
            if (!(comp instanceof TextField)) continue;
            valid = valid && ((TextField)comp).isValid();
        }
        return valid;
    }

    public void submit(CmsUser user, CmsObject cms, Runnable afterWrite) {
        this.submit(user, cms, afterWrite, false);
    }

    public void submit(CmsUser user, CmsObject cms, Runnable afterWrite, boolean force) {
        try {
            if (this.isValid() | force) {
                if (force) {
                    this.removeValidators();
                }
                this.m_binder.commit();
                PropertyUtilsBean propUtils = new PropertyUtilsBean();
                for (CmsAccountInfo info : OpenCms.getWorkplaceManager().getAccountInfos()) {
                    boolean editable = this.m_editLevel == EditLevel.all || this.m_editLevel == EditLevel.configured && info.isEditable();
                    if (!editable) continue;
                    if (info.isAdditionalInfo()) {
                        user.setAdditionalInfo(info.getAddInfoKey(), this.m_infos.getItemProperty((Object)info).getValue());
                        continue;
                    }
                    String valueToSet = (String)this.m_infos.getItemProperty((Object)info).getValue();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(valueToSet)) {
                        valueToSet = null;
                    }
                    propUtils.setProperty((Object)user, info.getField().name(), (Object)valueToSet);
                }
                cms.writeUser(user);
                afterWrite.run();
            }
        }
        catch (FieldGroup.CommitException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | CmsException e) {
            LOG.error((Object)"Unable to commit changes to user..", e);
        }
    }

    private TextField buildField(String label, CmsAccountInfo info) {
        TextField field = (TextField)this.m_binder.buildAndBind(label, (Object)info);
        field.setConverter((Converter)new CmsNullToEmptyConverter());
        field.setWidth("100%");
        boolean editable = this.m_editLevel == EditLevel.all || info.isEditable() && this.m_editLevel == EditLevel.configured;
        field.setEnabled(editable);
        if (editable) {
            field.addValidator((Validator)new FieldValidator(info.getField()));
        }
        field.setImmediate(true);
        return field;
    }

    private String getLabel(CmsAccountInfo info) {
        if (info.isAdditionalInfo()) {
            String label = CmsVaadinUtils.getMessageText("GUI_USER_DATA_" + info.getAddInfoKey().toUpperCase() + "_0", new Object[0]);
            if (CmsMessages.isUnknownKey(label)) {
                return info.getAddInfoKey();
            }
            return label;
        }
        return CmsVaadinUtils.getMessageText("GUI_USER_DATA_" + info.getField().name().toUpperCase() + "_0", new Object[0]);
    }

    private void removeValidators() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Component comp = (Component)iterator.next();
            ((TextField)comp).removeAllValidators();
        }
    }

    public static enum EditLevel {
        all,
        configured,
        none;

    }

    private static class FieldValidator
    extends AbstractStringValidator {
        private static final long serialVersionUID = 4432834072807177046L;
        private CmsAccountInfo.Field m_field;

        public FieldValidator(CmsAccountInfo.Field field) {
            super(null);
            this.m_field = field;
        }

        protected boolean isValidValue(String value) {
            boolean result = true;
            try {
                switch (this.m_field) {
                    case email: {
                        OpenCms.getValidationHandler().checkEmail(value);
                        break;
                    }
                    case firstname: {
                        OpenCms.getValidationHandler().checkFirstname(value);
                        break;
                    }
                    case lastname: {
                        OpenCms.getValidationHandler().checkLastname(value);
                        break;
                    }
                    case zipcode: {
                        OpenCms.getValidationHandler().checkZipCode(value);
                    }
                }
            }
            catch (CmsIllegalArgumentException e) {
                result = false;
                this.setErrorMessage(e.getLocalizedMessage(UI.getCurrent().getLocale()));
            }
            return result;
        }
    }
}

