/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import java.util.ArrayList;
import java.util.List;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsContextMenuTreeBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuBuilder;
import org.opencms.ui.contextmenu.I_CmsContextMenuItem;
import org.opencms.ui.contextmenu.I_CmsContextMenuItemProvider;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsTreeNode;

public class CmsResourceContextMenuBuilder
implements I_CmsContextMenuBuilder {
    private List<I_CmsContextMenuItemProvider> m_itemProviders = new ArrayList<I_CmsContextMenuItemProvider>();
    private CmsContextMenuTreeBuilder m_treeBuilder;

    public void addMenuItemProvider(I_CmsContextMenuItemProvider provider) {
        this.m_itemProviders.add(provider);
    }

    @Override
    public void buildContextMenu(I_CmsDialogContext context, CmsContextMenu menu) {
        CmsContextMenuTreeBuilder treeBuilder;
        this.m_treeBuilder = treeBuilder = new CmsContextMenuTreeBuilder(context);
        CmsTreeNode<I_CmsContextMenuItem> tree = treeBuilder.buildAll(this.getMenuItems());
        I_CmsContextMenuItem defaultActionItem = treeBuilder.getDefaultActionItem();
        for (CmsTreeNode<I_CmsContextMenuItem> node : tree.getChildren()) {
            this.createItem((Object)menu, node, context, defaultActionItem);
        }
    }

    @Override
    public List<I_CmsContextMenuItem> getMenuItems() {
        if (this.m_itemProviders.isEmpty()) {
            return OpenCms.getWorkplaceAppManager().getMenuItemProvider().getMenuItems();
        }
        ArrayList<I_CmsContextMenuItem> items = new ArrayList<I_CmsContextMenuItem>();
        for (I_CmsContextMenuItemProvider provider : this.m_itemProviders) {
            items.addAll(provider.getMenuItems());
        }
        return items;
    }

    String getTitle(I_CmsContextMenuItem item) {
        return CmsVaadinUtils.localizeString(item.getTitle(A_CmsUI.get().getLocale()));
    }

    private CmsContextMenu.ContextMenuItem createItem(Object parent, CmsTreeNode<I_CmsContextMenuItem> node, final I_CmsDialogContext context, I_CmsContextMenuItem defaultAction) {
        final I_CmsContextMenuItem data = node.getData();
        CmsContextMenu.ContextMenuItem guiMenuItem = null;
        guiMenuItem = parent instanceof CmsContextMenu ? ((CmsContextMenu)((Object)parent)).addItem(this.getTitle(data)) : ((CmsContextMenu.ContextMenuItem)parent).addItem(this.getTitle(data));
        if (this.m_treeBuilder.getVisibility(data).isInActive()) {
            guiMenuItem.setEnabled(false);
            String key = this.m_treeBuilder.getVisibility(data).getMessageKey();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(key)) {
                guiMenuItem.setDescription(CmsVaadinUtils.getMessageText(key, new Object[0]));
            }
        }
        if (node.getChildren().size() > 0) {
            for (CmsTreeNode<I_CmsContextMenuItem> childNode : node.getChildren()) {
                this.createItem(guiMenuItem, childNode, context, defaultAction);
            }
        } else {
            guiMenuItem.addItemClickListener(new CmsContextMenu.ContextMenuItemClickListener(){

                @Override
                public void contextMenuItemClicked(CmsContextMenu.ContextMenuItemClickEvent event) {
                    data.executeAction(context);
                }
            });
        }
        if (data.equals(defaultAction)) {
            guiMenuItem.addStyleName("bold");
        }
        return guiMenuItem;
    }
}

