/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.contextmenu;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.contextmenu.A_CmsSimpleVisibilityCheck;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsVisibilityCheckFlag;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.ui.editors.messagebundle.CmsMessageBundleEditorTypes;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.content.CmsXmlContentFactory;

public final class CmsStandardVisibilityCheck
extends A_CmsSimpleVisibilityCheck {
    public static final CmsStandardVisibilityCheck COPY_PAGE = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.pagefolder);
    public static final CmsStandardVisibilityCheck DEFAULT = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final I_CmsHasMenuItemVisibility DEFAULT_AUTHOR = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleelementauthor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final I_CmsHasMenuItemVisibility DEFAULT_DEFAULTFILE = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject, CmsVisibilityCheckFlag.defaultfile);
    public static final CmsStandardVisibilityCheck DEFAULT_FOLDERS = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.folder, CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck EDIT = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.file, CmsVisibilityCheckFlag.notpointer, CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject, CmsVisibilityCheckFlag.xmlunmarshal, CmsVisibilityCheckFlag.haseditor, CmsVisibilityCheckFlag.restrictedconfig);
    public static final CmsStandardVisibilityCheck EDIT_CODE = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.file, CmsVisibilityCheckFlag.hassourcecodeeditor, CmsVisibilityCheckFlag.rolevfsmanager, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject, CmsVisibilityCheckFlag.haseditor, CmsVisibilityCheckFlag.restrictedconfig);
    public static final I_CmsHasMenuItemVisibility EDIT_POINTER = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.file, CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject, CmsVisibilityCheckFlag.pointer);
    public static final CmsStandardVisibilityCheck LOCK = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.unlocked, CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck OTHER_PROJECT = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.notinproject);
    public static final I_CmsHasMenuItemVisibility PERMISSIONS = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.controlpermission, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck PUBLISH = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.notunchangedfile, CmsVisibilityCheckFlag.publishpermission, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck REINDEX = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.rolerootadmin);
    public static final CmsStandardVisibilityCheck REPLACE = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.replacable, CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck REPLACE_AUTHOR = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.replacable, CmsVisibilityCheckFlag.roleelementauthor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck SHOW_LOCKS = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.inproject, CmsVisibilityCheckFlag.folder);
    public static final I_CmsHasMenuItemVisibility STEAL_LOCK = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.otherlock, CmsVisibilityCheckFlag.noinheritedlock, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck UNDELETE = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.deleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck UNDO = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.notunchangedfile, CmsVisibilityCheckFlag.notnew, CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck UNDO_AUTHOR = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.notunchangedfile, CmsVisibilityCheckFlag.notnew, CmsVisibilityCheckFlag.roleelementauthor, CmsVisibilityCheckFlag.notonline, CmsVisibilityCheckFlag.notdeleted, CmsVisibilityCheckFlag.writepermisssion, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck UNLOCK = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.mylock, CmsVisibilityCheckFlag.noinheritedlock, CmsVisibilityCheckFlag.inproject);
    public static final CmsStandardVisibilityCheck VIEW = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleeditor, CmsVisibilityCheckFlag.notdeleted);
    public static final CmsStandardVisibilityCheck VIEW_AUTHOR = new CmsStandardVisibilityCheck(CmsVisibilityCheckFlag.roleelementauthor, CmsVisibilityCheckFlag.notdeleted);
    public static final I_CmsHasMenuItemVisibility VISIBLE = new CmsStandardVisibilityCheck(new CmsVisibilityCheckFlag[0]);
    private static final Log LOG = CmsLog.getLog(CmsStandardVisibilityCheck.class);
    private Set<CmsVisibilityCheckFlag> m_flags = Sets.newHashSet();

    public CmsStandardVisibilityCheck(CmsVisibilityCheckFlag ... flags) {
        for (CmsVisibilityCheckFlag flag : flags) {
            this.m_flags.add(flag);
        }
    }

    public boolean flag(CmsVisibilityCheckFlag flag) {
        return this.m_flags.contains((Object)flag);
    }

    @Override
    public CmsMenuItemVisibilityMode getSingleVisibility(CmsObject cms, CmsResource resource) {
        boolean prioritize = false;
        String inActiveKey = null;
        if (resource != null) {
            if (this.flag(CmsVisibilityCheckFlag.roleeditor) && !OpenCms.getRoleManager().hasRoleForResource(cms, CmsRole.EDITOR, resource)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.roleelementauthor) && !OpenCms.getRoleManager().hasRoleForResource(cms, CmsRole.ELEMENT_AUTHOR, resource)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.rolewpuser) && !OpenCms.getRoleManager().hasRoleForResource(cms, CmsRole.WORKPLACE_USER, resource)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.rolevfsmanager) && !OpenCms.getRoleManager().hasRoleForResource(cms, CmsRole.VFS_MANAGER, resource)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.rolerootadmin) && !OpenCms.getRoleManager().hasRoleForResource(cms, CmsRole.ROOT_ADMIN, resource)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        } else {
            if (this.flag(CmsVisibilityCheckFlag.roleeditor) && !OpenCms.getRoleManager().hasRole(cms, CmsRole.EDITOR)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.rolewpuser) && !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_USER)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        }
        if (this.flag(CmsVisibilityCheckFlag.notonline) && cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        if (resource != null) {
            CmsLock lock;
            I_CmsResourceType type;
            CmsResourceUtil resUtil = new CmsResourceUtil(cms, resource);
            if (this.flag(CmsVisibilityCheckFlag.file) && !resource.isFile()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.defaultfile)) {
                if (!resource.isFile()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
                try {
                    CmsResource parentFolder = cms.readParentFolder(resource.getStructureId());
                    if (parentFolder == null) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                    CmsResource defaultFile = cms.readDefaultFile(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
                    if (defaultFile == null || !defaultFile.getStructureId().equals(resource.getStructureId())) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.folder) && resource.isFile()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.pagefolder)) {
                if (!resource.isFolder()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
                try {
                    CmsResource defaultFile = cms.readDefaultFile("" + resource.getStructureId());
                    if (defaultFile == null || !CmsResourceTypeXmlContainerPage.isContainerPage(defaultFile)) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.pointer) && !OpenCms.getResourceManager().matchResourceType(CmsResourceTypePointer.getStaticTypeName(), resource.getTypeId())) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.notpointer) && OpenCms.getResourceManager().matchResourceType(CmsResourceTypePointer.getStaticTypeName(), resource.getTypeId())) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.replacable)) {
                boolean usesDumpLoader;
                type = OpenCms.getResourceManager().getResourceType(resource);
                boolean bl = usesDumpLoader = type.getLoaderId() == 1;
                if (!usesDumpLoader && !(type instanceof CmsResourceTypeImage)) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.hassourcecodeeditor)) {
                boolean hasSourcecodeEditor;
                type = resUtil.getResourceType();
                boolean bl = hasSourcecodeEditor = type instanceof CmsResourceTypeXmlContent || type instanceof CmsResourceTypeXmlPage || type instanceof CmsResourceTypePointer || OpenCms.getResourceManager().matchResourceType(CmsMessageBundleEditorTypes.BundleType.PROPERTY.toString(), resource.getTypeId());
                if (!hasSourcecodeEditor) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.unlocked)) {
                lock = resUtil.getLock();
                if (!lock.isUnlocked()) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
                prioritize = true;
            }
            if (this.flag(CmsVisibilityCheckFlag.otherlock)) {
                lock = resUtil.getLock();
                if (lock.isUnlocked() || lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
                prioritize = true;
            }
            if (this.flag(CmsVisibilityCheckFlag.nootherlock) && !(lock = resUtil.getLock()).isUnlocked() && !lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.mylock)) {
                lock = resUtil.getLock();
                if (!lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
                prioritize = true;
            }
            if (this.flag(CmsVisibilityCheckFlag.noinheritedlock) && (lock = resUtil.getLock()).isInherited()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.notunchangedfile) && resource.isFile() && resUtil.getResource().getState().isUnchanged()) {
                inActiveKey = "GUI_CONTEXTMENU_TITLE_INACTIVE_UNCHANGED_0";
            }
            if (this.flag(CmsVisibilityCheckFlag.notnew) && inActiveKey == null && resource.getState().isNew()) {
                inActiveKey = "GUI_CONTEXTMENU_TITLE_INACTIVE_NEW_UNCHANGED_0";
            }
            if (this.flag(CmsVisibilityCheckFlag.restrictedconfig) && OpenCms.getADEManager().isEditorRestricted(cms, resource)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.xmlunmarshal) && CmsResourceTypeXmlContent.isXmlContent(resource)) {
                try {
                    CmsXmlContentFactory.unmarshal(cms, cms.readFile(resource));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.haseditor) && OpenCms.getWorkplaceAppManager().getEditorForResource(cms, resource, false) == null) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.inproject) && (!resUtil.isInsideProject() || resUtil.getProjectState().isLockedForPublishing())) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.notinproject) && (resUtil.isInsideProject() || resUtil.getProjectState().isLockedForPublishing())) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
            if (this.flag(CmsVisibilityCheckFlag.publishpermission)) {
                try {
                    if (!cms.hasPermissions(resource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL)) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.controlpermission)) {
                try {
                    if (!cms.hasPermissions(resource, CmsPermissionSet.ACCESS_CONTROL, false, CmsResourceFilter.IGNORE_EXPIRATION)) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                }
                catch (CmsException e) {
                    LOG.warn((Object)"Error checking context menu entry permissions", (Throwable)e);
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.writepermisssion)) {
                try {
                    if (!resUtil.getLock().isLockableBy(cms.getRequestContext().getCurrentUser())) {
                        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                    }
                    if (!resUtil.isEditable() || !cms.hasPermissions(resUtil.getResource(), CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL)) {
                        inActiveKey = "GUI_CONTEXTMENU_TITLE_INACTIVE_PERM_WRITE_0";
                    }
                }
                catch (CmsException e) {
                    LOG.debug((Object)"Error checking context menu entry permissions.", (Throwable)e);
                    return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
                }
            }
            if (this.flag(CmsVisibilityCheckFlag.notdeleted) && inActiveKey == null && resUtil.getResource().getState().isDeleted()) {
                inActiveKey = "GUI_CONTEXTMENU_TITLE_INACTIVE_DELETED_0";
            }
            if (this.flag(CmsVisibilityCheckFlag.deleted) && !resource.getState().isDeleted()) {
                return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
            }
        } else {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        if (inActiveKey != null) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE.addMessageKey(inActiveKey).prioritize(prioritize);
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE.prioritize(prioritize);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        return this.getVisibility(context.getCms(), context.getResources());
    }

    public String toString() {
        return "visibility[" + this.m_flags + "]";
    }
}

