/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vaadin.data.HasValue;
import com.vaadin.event.LayoutEvents;
import com.vaadin.server.Resource;
import com.vaadin.server.VaadinService;
import com.vaadin.shared.ui.ValueChangeMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.declarative.Design;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.CmsAddDialogTypeHelper;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.util.CmsJspElFunctions;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.components.extensions.CmsMaxHeightExtension;
import org.opencms.ui.dialogs.CmsNewDialog;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;

public abstract class A_CmsSelectResourceTypeDialog
extends CmsBasicDialog {
    public static final Boolean DEFAULT_LOCATION_DEFAULT = Boolean.TRUE;
    public static final CmsUUID ID_VIEW_ALL = CmsUUID.getConstantUUID("view-all");
    public static final String SETTING_STANDARD_VIEW = "newDialogStandardView";
    public static final CmsElementView VIEW_ALL = new CmsElementView(ID_VIEW_ALL);
    private static final Log LOG = CmsLog.getLog(CmsNewDialog.class);
    private static final long serialVersionUID = 1L;
    protected CmsResource m_createdResource;
    protected CmsElementView m_currentView;
    protected I_CmsDialogContext m_dialogContext;
    protected TextField[] m_filterField = new TextField[]{new TextField()};
    protected boolean m_filterMode;
    protected String m_filterString;
    protected CmsResource m_folderResource;
    protected CmsResourceTypeBean m_selectedType;
    protected CmsAddDialogTypeHelper m_typeHelper;
    private List<CmsResourceTypeBean> m_allTypes;
    private Map<CmsResourceTypeBean, CmsResourceInfo> m_resourceInfoMap = new HashMap<CmsResourceTypeBean, CmsResourceInfo>();
    private Runnable m_selectedRunnable;

    public A_CmsSelectResourceTypeDialog(CmsResource folderResource, I_CmsDialogContext context) {
        this.m_folderResource = folderResource;
        this.m_dialogContext = context;
        Design.read((Component)this);
        CmsVaadinUtils.visitDescendants((Component)this, new Predicate<Component>(){

            public boolean apply(Component component) {
                component.setCaption(CmsVaadinUtils.localizeString(component.getCaption()));
                return true;
            }
        });
        this.getModeToggle().addStyleName("borderless");
        this.getModeToggle().addStyleName("o-type-filter-button");
        CmsUUID initViewId = (CmsUUID)VaadinService.getCurrentRequest().getWrappedSession().getAttribute(SETTING_STANDARD_VIEW);
        if (initViewId == null) {
            try {
                CmsUserSettings settings = new CmsUserSettings(A_CmsUI.getCmsObject());
                String viewSettingStr = settings.getAdditionalPreference("explorerElementView", true);
                if (viewSettingStr != null && CmsUUID.isValidUUID(viewSettingStr)) {
                    initViewId = new CmsUUID(viewSettingStr);
                }
            }
            catch (Exception e2) {
                LOG.error((Object)e2.getLocalizedMessage(), (Throwable)e2);
            }
        }
        if (initViewId == null) {
            initViewId = CmsUUID.getNullUUID();
        }
        CmsElementView initView = this.initViews(initViewId);
        this.getCancelButton().addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                A_CmsSelectResourceTypeDialog.this.finish(new ArrayList<CmsUUID>());
            }
        });
        this.getViewSelector().setNullSelectionAllowed(false);
        this.getViewSelector().setTextInputAllowed(false);
        this.getVerticalLayout().addLayoutClickListener(new LayoutEvents.LayoutClickListener(){
            private static final long serialVersionUID = 1L;

            public void layoutClick(LayoutEvents.LayoutClickEvent event) {
                try {
                    CmsResourceTypeBean clickedType = (CmsResourceTypeBean)((AbstractComponent)event.getChildComponent()).getData();
                    if (clickedType != null) {
                        A_CmsSelectResourceTypeDialog.this.handleSelection(clickedType);
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        this.m_filterField[0].setValueChangeMode(ValueChangeMode.LAZY);
        this.m_filterField[0].setValueChangeTimeout(200);
        this.m_filterField[0].setWidth("250px");
        this.m_filterField[0].setIcon((Resource)FontOpenCms.FILTER);
        this.m_filterField[0].setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_FILTER_0"));
        this.m_filterField[0].addStyleName("inline-icon");
        this.m_filterField[0].addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.m_filterField[0].getParent() != null) {
                this.init(this.m_currentView, this.useDefault(), (String)event.getValue());
            }
        });
        this.getModeToggle().addClickListener((Button.ClickListener & Serializable)e -> this.setFilterMode(!this.m_filterMode));
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                A_CmsSelectResourceTypeDialog.this.finish(new ArrayList<CmsUUID>());
            }

            @Override
            protected void ok() {
            }
        });
        this.init(initView, true, null);
        this.setFilterModeStyle(false);
    }

    public void finish(List<CmsUUID> ids) {
        if (this.m_selectedRunnable == null) {
            this.m_dialogContext.finish(ids);
            if (ids.size() == 1) {
                this.m_dialogContext.focus(ids.get(0));
            }
        } else {
            this.m_selectedRunnable.run();
        }
    }

    public abstract Button getCancelButton();

    public abstract Button getModeToggle();

    public CmsResourceInfo getTypeInfoLayout() {
        return this.m_selectedType != null ? this.m_resourceInfoMap.get(this.m_selectedType) : null;
    }

    public abstract VerticalLayout getVerticalLayout();

    public abstract ComboBox getViewSelector();

    public abstract void handleSelection(CmsResourceTypeBean var1);

    public void init(CmsElementView view, boolean useDefault, String filter) {
        this.m_currentView = view;
        this.m_filterString = filter;
        if (filter != null) {
            filter = filter.toLowerCase();
        }
        if (!view.getId().equals(this.getViewSelector().getValue())) {
            this.getViewSelector().setValue((Object)view.getId());
        }
        this.getVerticalLayout().removeAllComponents();
        List<CmsResourceTypeBean> typeBeans = this.m_typeHelper.getPrecomputedTypes(view);
        if (view.getId().equals(ID_VIEW_ALL)) {
            typeBeans = this.m_allTypes;
        }
        if (typeBeans == null) {
            LOG.warn((Object)("precomputed type list is null: " + view.getTitle(A_CmsUI.getCmsObject(), Locale.ENGLISH)));
            return;
        }
        if (typeBeans.size() == 0) {
            Label label = new Label(CmsVaadinUtils.getMessageText("GUI_NEWRESOURCEDIALOG_NO_TYPES_AVAILABLE_0", new Object[0]));
            this.getVerticalLayout().addComponent((Component)label);
            return;
        }
        HashSet<String> nonstandardTypes = new HashSet<String>();
        for (CmsModule module : OpenCms.getModuleManager().getAllInstalledModules()) {
            if (module.getName().equals("org.opencms.base")) continue;
            for (CmsExplorerTypeSettings expType : module.getExplorerTypes()) {
                nonstandardTypes.add(expType.getName());
            }
        }
        for (CmsResourceTypeBean type : typeBeans) {
            String filterable;
            String typeName;
            String title = typeName = type.getType();
            String subtitle = this.getSubtitle(type, useDefault);
            CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            title = CmsVaadinUtils.getMessageText(explorerType.getKey(), new Object[0]);
            if (filter != null && !(filterable = (title + "\n" + typeName).toLowerCase()).contains(filter)) continue;
            CmsResourceInfo info = new CmsResourceInfo();
            info.getTopLine().setContentMode(ContentMode.HTML);
            String suffix = "";
            if (nonstandardTypes.contains(type.getType())) {
                suffix = " <span class='o-internal-type-name'>" + CmsEncoder.escapeHtml(type.getType()) + "</span>";
            }
            info.getTopLine().setValue(CmsEncoder.escapeHtml(title) + suffix);
            info.getBottomLine().setValue(CmsJspElFunctions.stripHtml(subtitle));
            Resource iconResource = CmsResourceUtil.getBigIconResource(explorerType, null);
            info.getResourceIcon().initContent(null, iconResource, null, false, true);
            info.setData(type);
            this.m_resourceInfoMap.put(type, info);
            this.getVerticalLayout().addComponent((Component)info);
        }
    }

    public void setSelectedRunnable(Runnable run) {
        this.m_selectedRunnable = run;
    }

    public abstract boolean useDefault();

    protected CmsAddDialogTypeHelper createTypeHelper() {
        return new CmsAddDialogTypeHelper(CmsResourceTypeConfig.AddMenuType.workplace){

            @Override
            protected boolean exclude(CmsResourceTypeBean type) {
                String typeName = type.getType();
                CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
                boolean noCreate = !type.isCreatableType() || type.isDeactivated();
                return noCreate || explorerType == null || !explorerType.isCreatable();
            }
        };
    }

    protected String getSubtitle(CmsResourceTypeBean type, boolean useDefault) {
        String subtitle = "";
        CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getType());
        if (explorerType != null && explorerType.getInfo() != null) {
            subtitle = CmsVaadinUtils.getMessageText(explorerType.getInfo(), new Object[0]);
        }
        if (useDefault && type.getOrigin() == CmsResourceTypeBean.Origin.config && type.getCreatePath() != null) {
            String path = type.getCreatePath();
            CmsObject cms = A_CmsUI.getCmsObject();
            path = cms.getRequestContext().removeSiteRoot(path);
            subtitle = CmsVaadinUtils.getMessageText("GUI_NEW_CREATE_IN_PATH_1", path);
        }
        return subtitle;
    }

    protected void setFilterMode(boolean filterMode) {
        HasComponents typePanel = this.getVerticalLayout().getParent();
        Layout row = null;
        row = this.m_filterField[0].isAttached() ? (Layout)this.m_filterField[0].getParent() : (Layout)this.getViewSelector().getParent();
        this.m_filterMode = filterMode;
        this.setFilterModeStyle(filterMode);
        if (filterMode) {
            this.getViewSelector().setValue((Object)ID_VIEW_ALL);
            row.replaceComponent((Component)this.getViewSelector(), (Component)this.m_filterField[0]);
            this.m_filterField[0].focus();
            typePanel.setHeight("425px");
            this.setMaxHeightEnabled(false);
            CmsVaadinUtils.getWindow((Component)this).center();
        } else {
            row.replaceComponent((Component)this.m_filterField[0], (Component)this.getViewSelector());
            this.m_filterField[0].clear();
            typePanel.setHeight("100%");
            this.setMaxHeightEnabled(true);
            this.init(this.m_currentView, this.useDefault(), null);
            CmsVaadinUtils.getWindow((Component)this).center();
        }
    }

    protected void setFilterModeStyle(boolean filterMode) {
        if (filterMode) {
            this.getModeToggle().addStyleName("o-type-filter-button-active");
            this.getModeToggle().setIcon((Resource)FontOpenCms.FILTER);
        } else {
            this.getModeToggle().setIcon((Resource)FontOpenCms.FILTER);
            this.getModeToggle().removeStyleName("o-type-filter-button-active");
        }
    }

    private CmsElementView initViews(CmsUUID startId) {
        Map<CmsUUID, CmsElementView> viewMap = OpenCms.getADEManager().getElementViews(A_CmsUI.getCmsObject());
        ArrayList<CmsElementView> viewList = new ArrayList<CmsElementView>(viewMap.values());
        Collections.sort(viewList, new Comparator<CmsElementView>(){

            @Override
            public int compare(CmsElementView arg0, CmsElementView arg1) {
                return ComparisonChain.start().compare(arg0.getOrder(), arg1.getOrder()).result();
            }
        });
        this.getViewSelector().setItemCaptionMode(AbstractSelect.ItemCaptionMode.EXPLICIT);
        this.m_typeHelper = this.createTypeHelper();
        this.m_typeHelper.precomputeTypeLists(A_CmsUI.getCmsObject(), this.m_folderResource.getRootPath(), A_CmsUI.getCmsObject().getRequestContext().removeSiteRoot(this.m_folderResource.getRootPath()), viewList, null);
        LinkedHashMap allTypes = Maps.newLinkedHashMap();
        for (CmsElementView view : viewList) {
            List<CmsResourceTypeBean> typeBeans;
            if (!view.hasPermission(A_CmsUI.getCmsObject(), this.m_folderResource) || (typeBeans = this.m_typeHelper.getPrecomputedTypes(view)).isEmpty()) continue;
            for (CmsResourceTypeBean typeBean : typeBeans) {
                allTypes.put(typeBean.getType(), typeBean);
            }
            this.getViewSelector().addItem((Object)view.getId());
            this.getViewSelector().setItemCaption((Object)view.getId(), view.getTitle(A_CmsUI.getCmsObject(), A_CmsUI.get().getLocale()));
        }
        this.getViewSelector().addItem((Object)VIEW_ALL.getId());
        this.getViewSelector().setItemCaption((Object)VIEW_ALL.getId(), CmsVaadinUtils.getMessageText("GUI_VIEW_ALL_0", new Object[0]));
        this.m_allTypes = Lists.newArrayList(allTypes.values());
        if (allTypes.size() <= 8) {
            startId = ID_VIEW_ALL;
        }
        if (this.getViewSelector().getItem((Object)startId) == null) {
            startId = (CmsUUID)this.getViewSelector().getItemIds().iterator().next();
        }
        this.getViewSelector().addValueChangeListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                CmsUUID viewId = (CmsUUID)event.getProperty().getValue();
                CmsElementView selectedView = viewId.equals(ID_VIEW_ALL) ? VIEW_ALL : OpenCms.getADEManager().getElementViews(A_CmsUI.getCmsObject()).get(event.getProperty().getValue());
                A_CmsSelectResourceTypeDialog.this.init(selectedView, A_CmsSelectResourceTypeDialog.this.useDefault(), null);
                if (selectedView != VIEW_ALL) {
                    VaadinService.getCurrentRequest().getWrappedSession().setAttribute(A_CmsSelectResourceTypeDialog.SETTING_STANDARD_VIEW, event.getProperty().getValue());
                }
            }
        });
        if (startId.equals(ID_VIEW_ALL)) {
            return VIEW_ALL;
        }
        return OpenCms.getADEManager().getElementViews(A_CmsUI.getCmsObject()).get(startId);
    }

    private void setMaxHeightEnabled(boolean enabled) {
        this.getExtensions().forEach(ext -> {
            if (ext instanceof CmsMaxHeightExtension) {
                ((CmsMaxHeightExtension)ext).setEnabled(enabled);
            }
        });
    }
}

