/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValidationException;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializableComparator;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.server.VaadinService;
import com.vaadin.server.WrappedSession;
import com.vaadin.shared.Position;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsCssIcon;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsConfirmationDialog;
import org.opencms.ui.components.CmsGwtContextMenuButton;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.shared.rpc.I_CmsGwtContextMenuServerRpc;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsGalleryOptimizeDialog
extends CmsBasicDialog {
    static final String GALLERY_OPTIMIZE_ATTR_SORT_ORDER = "GALLERY_OPTIMIZE_ATTR_SORT_ORDER";
    static final Log LOG = CmsLog.getLog(CmsGalleryOptimizeDialog.class);
    private static final String IMAGE_HEIGHT = "170";
    private static final String IMAGE_WIDTH = "200";
    private static final long serialVersionUID = 1L;
    private Button m_buttonSave;
    private Button m_buttonSaveAndExit;
    private I_CmsDialogContext m_context;
    private Object m_compositeDataListHeader;
    private VerticalLayout m_dataListHeaderView;
    private Panel m_dataListViewScrollable;
    private GridLayout m_dataListView;
    private CmsResource m_gallery;
    private CmsLockActionRecord m_lockActionRecord;
    private String m_messageSortDateLastModifiedAscending;
    private String m_messageSortDateLastModifiedDescending;
    private String m_messageSortPathAscending;
    private String m_messageSortPathDescending;
    private String m_messageSortTitleAscending;
    private String m_messageSortTitleDescending;
    private String m_messageSortUnusedFirst;
    private String m_messageSortNoCopyrightFirst;
    private FilterHandler m_filterHandler = new FilterHandler();
    private PageHandler m_pageHandler = new PageHandler();
    private Provider m_provider;
    private SaveHandler m_saveHandler = new SaveHandler();

    public CmsGalleryOptimizeDialog(I_CmsDialogContext context, CmsResource gallery) {
        this.m_context = context;
        this.m_gallery = gallery;
        this.initMessages();
        this.initDialog();
        this.initLock();
        this.initEvents();
        this.dataListLoad();
        this.displayDataListHeaderView();
        this.displayDataListViewSorted(this.getSessionSortOrder());
    }

    public CmsObject getCms() {
        return this.m_context.getCms();
    }

    protected boolean isReadOnly() {
        return this.m_context.getCms().getRequestContext().getCurrentProject().isOnlineProject();
    }

    void finishDialog(List<CmsUUID> changedIds) {
        this.m_context.finish(changedIds);
    }

    void handleDataListDelete(List<DataItem> dataItemList) {
        this.m_provider.getItems().removeAll(dataItemList);
        ((DataListHeaderComposite)((Object)this.m_compositeDataListHeader)).refresh();
        this.displayDataListView(false);
    }

    void handleDataListUpdate(List<DataItem> dataItemList) throws CmsException {
        for (DataItem dataItem : dataItemList) {
            CmsResourceFilter resourceFilter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireFile();
            CmsResource reload = this.getCms().readResource(dataItem.getResource().getStructureId(), resourceFilter);
            dataItem.setResource(reload);
        }
        this.displayDataListView(false);
    }

    void handleDialogAttach() {
        Window window = CmsVaadinUtils.getWindow((Component)this);
        window.removeAllCloseShortcuts();
        Page.getCurrent().getStyles().add(".o-gallery-grid-force-scroll { min-height: 1000px; }");
        this.m_dataListView.addStyleName("o-gallery-grid-force-scroll");
    }

    void handleDialogCancel() {
        if (this.dataListHasChanges()) {
            String title = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_CONFIRM_CANCEL_TITLE_0", new Object[0]);
            String message = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_CONFIRM_CANCEL_0", new Object[0]);
            CmsConfirmationDialog.show(title, message, new Runnable(){

                @Override
                public void run() {
                    CmsGalleryOptimizeDialog.this.finishDialog(new ArrayList<CmsUUID>());
                }
            });
        } else {
            this.finishDialog(new ArrayList<CmsUUID>());
        }
    }

    void handleDialogDetach() {
        this.unlock();
    }

    void handleDialogSave(final boolean exit) {
        this.m_saveHandler.save((List<DataItem>)this.m_provider.getItems());
        if (this.m_saveHandler.hasDeletedCurrent()) {
            String title = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_CONFIRM_DELETE_TITLE_0", new Object[0]);
            String message = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_CONFIRM_DELETE_0", new Object[0]);
            CmsConfirmationDialog confirmationDialog = CmsConfirmationDialog.show(title, message, new Runnable(){

                @Override
                public void run() {
                    CmsGalleryOptimizeDialog.this.persist();
                    CmsGalleryOptimizeDialog.this.m_saveHandler.setFlagCancelSave(false);
                    if (exit) {
                        CmsGalleryOptimizeDialog.this.finishDialog(CmsGalleryOptimizeDialog.this.m_saveHandler.getChangedIds());
                    }
                }
            }, new Runnable(){

                @Override
                public void run() {
                    CmsGalleryOptimizeDialog.this.m_saveHandler.setFlagCancelSave(true);
                }
            });
            confirmationDialog.displayResourceInfo(this.m_saveHandler.getDeletedCurrentResource(), "GUI_SELECTED_0");
        } else {
            this.persist();
            if (exit) {
                this.finishDialog(this.m_saveHandler.getChangedIds());
            }
        }
    }

    private HorizontalLayout createDisplayGalleryInUse() throws CmsException {
        HorizontalLayout layout1 = new HorizontalLayout();
        layout1.setWidthFull();
        layout1.addStyleNames(new String[]{"v-panel", "o-error-dialog", "o-gallery-alert-in-use"});
        HorizontalLayout layout2 = new HorizontalLayout();
        layout2.setWidthUndefined();
        Label icon = new Label(FontOpenCms.WARNING.getHtml());
        icon.setContentMode(ContentMode.HTML);
        icon.setWidthUndefined();
        icon.setStyleName("o-warning-icon");
        String galleryTitle = this.getGalleryTitle();
        Label message = new Label(CmsVaadinUtils.getMessageText("GUI_GALLERY_DIRECTLY_USED_1", galleryTitle));
        message.setContentMode(ContentMode.HTML);
        message.setWidthUndefined();
        layout2.addComponent((Component)icon);
        layout2.addComponent((Component)message);
        layout2.setComponentAlignment((Component)message, Alignment.MIDDLE_LEFT);
        layout1.addComponent((Component)layout2);
        layout1.setComponentAlignment((Component)layout2, Alignment.MIDDLE_CENTER);
        return layout1;
    }

    private HorizontalLayout createDisplayInOnlineProject() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidthFull();
        layout.addStyleNames(new String[]{"v-panel", "o-error-dialog"});
        Label icon = new Label(FontOpenCms.WARNING.getHtml());
        icon.setContentMode(ContentMode.HTML);
        icon.setWidthUndefined();
        icon.setStyleName("o-warning-icon");
        Label message = new Label(CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_IN_ONLINE_PROJECT_0", new Object[0]));
        message.setContentMode(ContentMode.HTML);
        message.setWidthUndefined();
        layout.addComponent((Component)icon);
        layout.addComponent((Component)message);
        layout.setComponentAlignment((Component)message, Alignment.MIDDLE_LEFT);
        layout.setExpandRatio((Component)message, 1.0f);
        return layout;
    }

    private boolean dataListHasChanges() {
        boolean hasChanges = false;
        for (DataItem dataItem : this.m_provider.getItems()) {
            if (!dataItem.getBinder().hasChanges()) continue;
            hasChanges = true;
        }
        return hasChanges;
    }

    private void dataListLoad() {
        ArrayList<DataItem> dataList = new ArrayList<DataItem>();
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsResourceFilter resourceFilter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireFile();
            List<CmsResource> resources = cms.readResources(cms.getSitePath(this.m_gallery), resourceFilter);
            for (CmsResource resource : resources) {
                DataItem dataItem = new DataItem(resource);
                dataList.add(dataItem);
            }
        }
        catch (CmsException exception) {
            this.m_context.error(exception);
        }
        this.m_provider = new Provider(dataList);
    }

    private void displayDataListHeaderView() {
        if (this.isReadOnly()) {
            this.m_dataListHeaderView.addComponent((Component)this.createDisplayInOnlineProject());
        } else {
            try {
                List<CmsRelation> relations = this.getCms().getRelationsForResource(this.m_gallery, CmsRelationFilter.SOURCES);
                if (relations != null && !relations.isEmpty()) {
                    this.m_dataListHeaderView.addComponent((Component)this.createDisplayGalleryInUse());
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.m_compositeDataListHeader = new DataListHeaderComposite();
        this.m_dataListHeaderView.addComponent((Component)this.m_compositeDataListHeader);
    }

    private void displayDataListView(boolean scrollToTop) {
        this.m_dataListView.removeAllComponents();
        List<DataItem> dataItemList = this.m_provider.fetch(this.m_pageHandler, this.m_filterHandler);
        this.m_dataListView.setColumns(3);
        this.m_dataListView.setRows(dataItemList.size() + 2);
        this.m_dataListView.setColumnExpandRatio(2, 1.0f);
        int i = 1;
        Label dummy = new Label(" ");
        dummy.setId("scrollToTop");
        dummy.setHeight("0px");
        this.m_dataListView.addComponent((Component)dummy, 0, 0);
        for (DataItem dataItem : dataItemList) {
            dataItem.getCompositeFile().removeStyleName("o-gallery-grid-row-odd");
            dataItem.getCompositeFileDelete().removeStyleName("o-gallery-grid-row-odd");
            dataItem.getCompositeForm().removeStyleName("o-gallery-grid-row-odd");
            if (i % 2 == 0) {
                dataItem.getCompositeFile().addStyleName("o-gallery-grid-row-odd");
                dataItem.getCompositeFileDelete().addStyleName("o-gallery-grid-row-odd");
                dataItem.getCompositeForm().addStyleName("o-gallery-grid-row-odd");
            }
            this.m_dataListView.addComponent((Component)dataItem.getCompositeFile(), 0, i);
            this.m_dataListView.addComponent((Component)dataItem.getCompositeFileDelete(), 1, i);
            this.m_dataListView.addComponent((Component)dataItem.getCompositeForm(), 2, i);
            ++i;
        }
        if (scrollToTop) {
            this.m_dataListViewScrollable.setScrollTop(0);
        }
    }

    private void displayDataListViewSorted(String sortOrder) {
        SerializableComparator<DataItem> defaultSortOrder = this.m_provider.SORT_PATH_ASCENDING;
        if (sortOrder == null) {
            this.m_provider.setSortComparator(this.m_provider.SORT_TITLE_ASCENDING);
        } else if (sortOrder == this.m_messageSortTitleAscending) {
            this.m_provider.setSortComparator(this.m_provider.SORT_TITLE_ASCENDING);
        } else if (sortOrder == this.m_messageSortTitleDescending) {
            this.m_provider.setSortComparator(this.m_provider.SORT_TITLE_DESCENDING);
        } else if (sortOrder == this.m_messageSortDateLastModifiedAscending) {
            this.m_provider.setSortComparator(this.m_provider.SORT_DATE_ASCENDING);
        } else if (sortOrder == this.m_messageSortDateLastModifiedDescending) {
            this.m_provider.setSortComparator(this.m_provider.SORT_DATE_DESCENDING);
        } else if (sortOrder == this.m_messageSortPathAscending) {
            this.m_provider.setSortComparator(this.m_provider.SORT_PATH_ASCENDING);
        } else if (sortOrder == this.m_messageSortPathDescending) {
            this.m_provider.setSortComparator(this.m_provider.SORT_PATH_DESCENDING);
        } else if (sortOrder == this.m_messageSortUnusedFirst) {
            this.m_provider.setSortComparator(this.m_provider.SORT_UNUSED_FIRST);
        } else if (sortOrder == this.m_messageSortNoCopyrightFirst) {
            this.m_provider.setSortComparator(this.m_provider.SORT_NOCOPYRIGHT_FIRST);
        } else {
            this.m_provider.setSortComparator(defaultSortOrder);
        }
        this.setSessionSortOrder(sortOrder);
        this.displayDataListView(true);
    }

    private String getGalleryTitle() throws CmsException {
        String galleryTitle = this.getCms().readPropertyObject(this.m_gallery, "Title", false).getValue();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(galleryTitle)) {
            galleryTitle = this.m_gallery.getName();
        }
        return galleryTitle;
    }

    private String getSessionSortOrder() {
        WrappedSession wrappedSession = VaadinService.getCurrentRequest().getWrappedSession();
        String currentSortOrder = (String)wrappedSession.getAttribute(GALLERY_OPTIMIZE_ATTR_SORT_ORDER);
        if (currentSortOrder == null) {
            wrappedSession.setAttribute(GALLERY_OPTIMIZE_ATTR_SORT_ORDER, (Object)this.m_messageSortPathAscending);
        }
        return (String)wrappedSession.getAttribute(GALLERY_OPTIMIZE_ATTR_SORT_ORDER);
    }

    private void initDialog() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.displayResourceInfo(this.m_gallery);
        Button buttonCancel = this.createButtonCancel();
        buttonCancel.addClickListener((Button.ClickListener & Serializable)event -> this.handleDialogCancel());
        this.addButton((Component)buttonCancel, false);
        this.m_buttonSave.setEnabled(!this.isReadOnly());
        this.m_buttonSaveAndExit.setEnabled(!this.isReadOnly());
    }

    private void initEvents() {
        this.m_buttonSave.addClickListener((Button.ClickListener & Serializable)event -> this.handleDialogSave(false));
        this.m_buttonSaveAndExit.addClickListener((Button.ClickListener & Serializable)event -> this.handleDialogSave(true));
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsGalleryOptimizeDialog.this.handleDialogCancel();
            }

            @Override
            protected void ok() {
                CmsGalleryOptimizeDialog.this.handleDialogSave(true);
            }
        });
        this.addAttachListener((ClientConnector.AttachListener & Serializable)event -> this.handleDialogAttach());
        this.addDetachListener((ClientConnector.DetachListener & Serializable)event -> this.handleDialogDetach());
    }

    private void initLock() {
        try {
            this.m_lockActionRecord = CmsLockUtil.ensureLock(this.getCms(), this.m_gallery);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void initMessages() {
        this.m_messageSortDateLastModifiedAscending = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_DATE_MODIFIED_ASCENDING_0", new Object[0]);
        this.m_messageSortDateLastModifiedDescending = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_DATE_MODIFIED_DESCENDING_0", new Object[0]);
        this.m_messageSortPathAscending = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_PATH_ASCENDING_0", new Object[0]);
        this.m_messageSortPathDescending = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_PATH_DESCENDING_0", new Object[0]);
        this.m_messageSortTitleAscending = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_TITLE_ASCENDING_0", new Object[0]);
        this.m_messageSortTitleDescending = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_TITLE_DESCENDING_0", new Object[0]);
        this.m_messageSortUnusedFirst = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_UNUSED_FIRST_0", new Object[0]);
        this.m_messageSortNoCopyrightFirst = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SORT_NOCOPYRIGHT_FIRST_0", new Object[0]);
    }

    private void persist() {
        StringBuilder errorMessageList = new StringBuilder();
        this.persistUpdateAndRename(errorMessageList);
        this.persistDelete(errorMessageList);
        if (errorMessageList.length() == 0) {
            String message = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_SUCCESSFULLY_SAVED_0", new Object[0]);
            Notification notification = new Notification(message, "", Notification.Type.HUMANIZED_MESSAGE);
            notification.setPosition(Position.TOP_CENTER);
            notification.show(Page.getCurrent());
        } else {
            Notification notification = new Notification("", errorMessageList.toString(), Notification.Type.ERROR_MESSAGE);
            notification.setHtmlContentAllowed(true);
            notification.setPosition(Position.TOP_CENTER);
            notification.show(Page.getCurrent());
        }
    }

    private void persistDelete(StringBuilder errorMessageList) {
        ArrayList<DataItem> deleted = new ArrayList<DataItem>();
        for (DataItem dataItem : this.m_saveHandler.getDeletedCurrent()) {
            CmsResource resource = dataItem.getResource();
            try {
                this.getCms().deleteResource(this.getCms().getSitePath(resource), CmsResource.DELETE_PRESERVE_SIBLINGS);
                deleted.add(dataItem);
            }
            catch (CmsException e) {
                errorMessageList.append("<div>" + e.getLocalizedMessage() + "</div>");
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.handleDataListDelete(deleted);
        if (this.m_saveHandler.hasDeletedCurrent()) {
            this.displayDataListView(true);
        }
    }

    private void persistUpdateAndRename(StringBuilder errorMessageList) {
        ArrayList<DataItem> updated = new ArrayList<DataItem>();
        for (DataItem dataItem : this.m_saveHandler.getChangedCurrent()) {
            CmsResource resource = dataItem.getResource();
            if (dataItem.hasChanges()) {
                try {
                    this.getCms().writePropertyObjects(resource, dataItem.getPropertyList());
                    this.getCms().writeResource(resource);
                    updated.add(dataItem);
                }
                catch (CmsException e) {
                    errorMessageList.append("<div>" + e.getLocalizedMessage() + "</div>");
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!dataItem.isRenamed()) continue;
            String source = this.getCms().getSitePath(resource);
            String destination = CmsStringUtil.joinPaths(CmsResource.getParentFolder(source), dataItem.getName());
            try {
                this.getCms().renameResource(source, destination);
                if (updated.contains(dataItem)) continue;
                updated.add(dataItem);
            }
            catch (CmsException e) {
                errorMessageList.append("<div>" + e.getLocalizedMessage() + "</div>");
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        try {
            this.handleDataListUpdate(updated);
        }
        catch (CmsException e) {
            errorMessageList.append("<div>" + e.getLocalizedMessage() + "</div>");
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void setSessionSortOrder(String sortOrder) {
        WrappedSession wrappedSession = VaadinService.getCurrentRequest().getWrappedSession();
        wrappedSession.setAttribute(GALLERY_OPTIMIZE_ATTR_SORT_ORDER, (Object)sortOrder);
    }

    private void unlock() {
        if (this.m_lockActionRecord != null) {
            try {
                this.getCms().unlockResource(this.m_gallery);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private class SaveHandler {
        Set<DataItem> m_changed = new HashSet<DataItem>();
        Set<DataItem> m_changedCurrent = new HashSet<DataItem>();
        Set<CmsUUID> m_changedIds = new HashSet<CmsUUID>();
        Set<CmsUUID> m_changedIdsCurrent = new HashSet<CmsUUID>();
        Set<DataItem> m_deleted = new HashSet<DataItem>();
        Set<DataItem> m_deletedCurrent = new HashSet<DataItem>();
        Set<CmsResource> m_deletedCurrentResource = new HashSet<CmsResource>();
        boolean m_flagCancelSave = false;

        public void setFlagCancelSave(boolean flagCancelSave) {
            this.m_flagCancelSave = flagCancelSave;
        }

        Set<DataItem> getChangedCurrent() {
            return this.m_changedCurrent;
        }

        List<CmsUUID> getChangedIds() {
            return new ArrayList<CmsUUID>(this.m_changedIds);
        }

        Set<DataItem> getDeletedCurrent() {
            return this.m_deletedCurrent;
        }

        List<CmsResource> getDeletedCurrentResource() {
            return new ArrayList<CmsResource>(this.m_deletedCurrentResource);
        }

        boolean hasDeletedCurrent() {
            return this.m_deletedCurrent.size() > 0;
        }

        void save(List<DataItem> dataList) {
            if (!this.m_flagCancelSave) {
                this.flush();
            }
            for (DataItem dataItem : dataList) {
                boolean dataItemHasChanges = dataItem.getBinder().hasChanges();
                if (!dataItemHasChanges) continue;
                try {
                    dataItem.getBinder().writeBean((Object)dataItem);
                    this.m_changedCurrent.add(dataItem);
                    if (dataItem.getDeleteFlag().booleanValue()) {
                        this.m_deletedCurrent.add(dataItem);
                        this.m_deletedCurrentResource.add(dataItem.getResource());
                        continue;
                    }
                    if (dataItem.getDeleteFlag().booleanValue() || !this.m_deletedCurrent.contains(dataItem)) continue;
                    this.m_deletedCurrent.remove(dataItem);
                    this.m_deletedCurrentResource.remove(dataItem.getResource());
                }
                catch (ValidationException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }

        private void flush() {
            this.m_deleted.addAll(this.m_deletedCurrent);
            this.m_changed.addAll(this.m_changedCurrent);
            this.m_changedIds.addAll(this.m_changedIdsCurrent);
            this.m_deletedCurrent.clear();
            this.m_changedCurrent.clear();
            this.m_changedIdsCurrent.clear();
            this.m_deletedCurrentResource.clear();
        }
    }

    private class Provider
    extends ListDataProvider<DataItem> {
        private static final long serialVersionUID = 1L;
        final SerializableComparator<DataItem> SORT_DATE_ASCENDING;
        final SerializableComparator<DataItem> SORT_DATE_DESCENDING;
        final SerializableComparator<DataItem> SORT_PATH_ASCENDING;
        final SerializableComparator<DataItem> SORT_PATH_DESCENDING;
        final SerializableComparator<DataItem> SORT_TITLE_ASCENDING;
        final SerializableComparator<DataItem> SORT_TITLE_DESCENDING;
        final SerializableComparator<DataItem> SORT_UNUSED_FIRST;
        final SerializableComparator<DataItem> SORT_NOCOPYRIGHT_FIRST;

        public Provider(List<DataItem> dataItemList) {
            super(dataItemList);
            this.SORT_DATE_ASCENDING = Comparator.comparing(DataItem::getDateLastModified)::compare;
            this.SORT_DATE_DESCENDING = Comparator.comparing(DataItem::getDateLastModified).reversed()::compare;
            this.SORT_PATH_ASCENDING = Comparator.comparing(DataItem::getPath, String.CASE_INSENSITIVE_ORDER)::compare;
            this.SORT_PATH_DESCENDING = Comparator.comparing(DataItem::getPath, String.CASE_INSENSITIVE_ORDER).reversed()::compare;
            this.SORT_TITLE_ASCENDING = Comparator.comparing(DataItem::getTitle, String.CASE_INSENSITIVE_ORDER)::compare;
            this.SORT_TITLE_DESCENDING = Comparator.comparing(DataItem::getTitle, String.CASE_INSENSITIVE_ORDER).reversed()::compare;
            this.SORT_UNUSED_FIRST = Comparator.comparing(DataItem::getIsUsed)::compare;
            this.SORT_NOCOPYRIGHT_FIRST = Comparator.comparing(DataItem::getNoCopyright)::compare;
        }

        public List<DataItem> fetch(PageHandler pageHandler, FilterHandler filterHandler) {
            SerializablePredicate filter = null;
            Query<DataItem, SerializablePredicate<DataItem>> filterQuery = this.composeFilterQuery(filterHandler);
            if (filterQuery != null) {
                filter = filterQuery.getFilter().orElse(null);
            }
            Query query = new Query(pageHandler.getOffset(), pageHandler.getLimit(), Collections.emptyList(), (Comparator)this.getSortComparator(), (Object)filter);
            return super.fetch(query).collect(Collectors.toList());
        }

        public List<DataItem> getItems() {
            return (List)super.getItems();
        }

        public int size(FilterHandler filterHandler) {
            Query<DataItem, SerializablePredicate<DataItem>> filterQuery = this.composeFilterQuery(filterHandler);
            return filterQuery == null ? this.getItems().size() : super.size(filterQuery);
        }

        private Query<DataItem, SerializablePredicate<DataItem>> composeFilterQuery(FilterHandler filterHandler) {
            Query filterQuery = null;
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(filterHandler.getQuery())) {
                filterQuery = new Query((SerializablePredicate & Serializable)dataItem -> dataItem.getFilterText().contains(filterHandler.getQuery()));
            }
            return filterQuery;
        }
    }

    private class FilterHandler {
        private String m_query;

        public String getQuery() {
            return this.m_query != null ? this.m_query.toLowerCase() : null;
        }

        public void setQuery(String query) {
            this.m_query = query;
        }
    }

    private class PageHandler {
        public static final int LIMIT = 50;
        private int m_currentPage = 0;

        public int getLimit() {
            return 50;
        }

        public int getNumFirstItem() {
            return 50 * this.m_currentPage + 1;
        }

        public int getNumLastItem() {
            int lastItem = 50 * this.m_currentPage + 50;
            int sizeItem = this.getSizeItem();
            if (lastItem > sizeItem) {
                lastItem = sizeItem;
            }
            return lastItem;
        }

        public int getNumPages() {
            return (int)Math.ceil((double)this.getSizeItem() / 50.0);
        }

        public int getOffset() {
            return 50 * this.m_currentPage;
        }

        public int getSizeItem() {
            return CmsGalleryOptimizeDialog.this.m_provider.size(CmsGalleryOptimizeDialog.this.m_filterHandler);
        }

        public boolean hasPages() {
            return this.getSizeItem() > 50;
        }

        public void setCurrentPage(int index) {
            this.m_currentPage = index;
        }
    }

    private class DataListHeaderComposite
    extends AbsoluteLayout {
        private static final long serialVersionUID = 1L;
        private Label m_labelPageInfo;
        private NativeSelect<Integer> m_selectPage;
        private NativeSelect<String> m_selectSortOrder;
        private TextField m_textFieldFilter;

        public DataListHeaderComposite() {
            this.setHeight("34px");
            this.setWidthFull();
            this.m_selectSortOrder = this.createSelectSortOrder();
            this.m_textFieldFilter = this.createTextFieldFilter();
            this.addComponent((Component)this.m_selectSortOrder, "left: 2px; top: 2px;");
            this.addComponent((Component)this.m_textFieldFilter, "right: 2px; top: 2px;");
            this.refresh();
        }

        public void refresh() {
            NativeSelect<Integer> selectPage = this.createSelectPage();
            Label pageInfo = this.createLabelPageInfo();
            if (this.m_selectPage == null) {
                this.m_selectPage = selectPage;
                this.addComponent((Component)this.m_selectPage, "left: 436px; top: 2px;");
            } else {
                this.replaceComponent((Component)this.m_selectPage, (Component)selectPage);
                this.m_selectPage = selectPage;
            }
            if (this.m_labelPageInfo == null) {
                this.m_labelPageInfo = pageInfo;
                this.addComponent((Component)this.m_labelPageInfo, "right: 228px; top: 6px;");
            } else {
                this.replaceComponent((Component)this.m_labelPageInfo, (Component)pageInfo);
                this.m_labelPageInfo = pageInfo;
            }
        }

        public void selectPage(int index) {
            this.m_selectPage.setValue(null);
            this.handlePageChange(index, false);
        }

        private Label createLabelPageInfo() {
            String text = "";
            text = CmsGalleryOptimizeDialog.this.m_pageHandler.hasPages() ? CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_PAGE_INFO_3", String.valueOf(CmsGalleryOptimizeDialog.this.m_pageHandler.getNumFirstItem()), String.valueOf(CmsGalleryOptimizeDialog.this.m_pageHandler.getNumLastItem()), String.valueOf(CmsGalleryOptimizeDialog.this.m_pageHandler.getSizeItem())) : (CmsGalleryOptimizeDialog.this.m_pageHandler.getSizeItem() == 1 ? CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_PAGE_INFO_ONE_0", String.valueOf(CmsGalleryOptimizeDialog.this.m_pageHandler.getSizeItem())) : CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_PAGE_INFO_1", String.valueOf(CmsGalleryOptimizeDialog.this.m_pageHandler.getSizeItem())));
            Label label = new Label(text);
            label.setWidthUndefined();
            return label;
        }

        private NativeSelect<Integer> createSelectPage() {
            NativeSelect selectPage = new NativeSelect();
            selectPage.setWidthUndefined();
            final int numPages = CmsGalleryOptimizeDialog.this.m_pageHandler.getNumPages();
            selectPage.setItemCaptionGenerator((ItemCaptionGenerator)new ItemCaptionGenerator<Integer>(){
                private static final long serialVersionUID = 1L;

                public String apply(Integer item) {
                    return CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_SELECTED_PAGE_2", String.valueOf(item + 1), String.valueOf(numPages));
                }
            });
            Integer firstItem = 0;
            ArrayList<Integer> items = new ArrayList<Integer>();
            for (int i = 0; i < numPages; ++i) {
                if (i <= 0) continue;
                items.add(i);
            }
            selectPage.setEmptySelectionCaption(selectPage.getItemCaptionGenerator().apply((Object)firstItem));
            selectPage.setItems(items);
            selectPage.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (event.isUserOriginated()) {
                    int index = event.getValue() != null ? (Integer)event.getValue() : 0;
                    this.handlePageChange(index, true);
                }
            });
            selectPage.setVisible(CmsGalleryOptimizeDialog.this.m_pageHandler.hasPages());
            return selectPage;
        }

        private NativeSelect<String> createSelectSortOrder() {
            NativeSelect selectSortOrder = new NativeSelect();
            selectSortOrder.setWidthUndefined();
            selectSortOrder.setEmptySelectionCaption(CmsGalleryOptimizeDialog.this.m_messageSortTitleAscending);
            selectSortOrder.setItems((Object[])new String[]{CmsGalleryOptimizeDialog.this.m_messageSortTitleDescending, CmsGalleryOptimizeDialog.this.m_messageSortDateLastModifiedAscending, CmsGalleryOptimizeDialog.this.m_messageSortDateLastModifiedDescending, CmsGalleryOptimizeDialog.this.m_messageSortPathAscending, CmsGalleryOptimizeDialog.this.m_messageSortPathDescending, CmsGalleryOptimizeDialog.this.m_messageSortUnusedFirst, CmsGalleryOptimizeDialog.this.m_messageSortNoCopyrightFirst});
            selectSortOrder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (event.isUserOriginated()) {
                    this.selectPage(0);
                    CmsGalleryOptimizeDialog.this.m_provider.refreshAll();
                    CmsGalleryOptimizeDialog.this.displayDataListViewSorted((String)event.getValue());
                }
            });
            selectSortOrder.setValue((Object)CmsGalleryOptimizeDialog.this.getSessionSortOrder());
            return selectSortOrder;
        }

        private TextField createTextFieldFilter() {
            TextField textField = new TextField();
            textField.setPlaceholder(CmsVaadinUtils.getMessageText("GUI_EXPLORER_FILTER_0", new Object[0]));
            textField.setWidth("200px");
            textField.addStyleName("inline-icon");
            textField.setIcon((Resource)FontOpenCms.FILTER);
            textField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.handleFilterChange((String)event.getValue()));
            return textField;
        }

        private void handleFilterChange(String query) {
            String clean = query.trim();
            CmsGalleryOptimizeDialog.this.m_filterHandler.setQuery(clean);
            CmsGalleryOptimizeDialog.this.m_pageHandler.setCurrentPage(0);
            this.refresh();
            CmsGalleryOptimizeDialog.this.displayDataListView(true);
        }

        private void handlePageChange(int index, boolean display) {
            CmsGalleryOptimizeDialog.this.m_pageHandler.setCurrentPage(index);
            Label label = this.createLabelPageInfo();
            this.replaceComponent((Component)this.m_labelPageInfo, (Component)label);
            this.m_labelPageInfo = label;
            if (display) {
                CmsGalleryOptimizeDialog.this.displayDataListView(true);
            }
        }
    }

    private class DataItem {
        private Binder<DataItem> m_binder = new Binder();
        private FormComposite m_compositeForm;
        private FileComposite m_compositeFile;
        private FileDeleteComposite m_compositeFileDelete;
        private String m_copyright;
        private Long m_dateLastModified;
        private Boolean m_deleteFlag = false;
        private String m_description;
        private Boolean m_isUsed;
        private String m_name;
        private String m_path;
        private CmsResource m_resource;
        private CmsResourceUtil m_resourceUtil;
        private String m_title;

        public DataItem(CmsResource resource) {
            this.m_resource = resource;
            this.initData();
            this.initComponent();
        }

        public Binder<DataItem> getBinder() {
            return this.m_binder;
        }

        public FileComposite getCompositeFile() {
            return this.m_compositeFile;
        }

        public FileDeleteComposite getCompositeFileDelete() {
            return this.m_compositeFileDelete;
        }

        public FormComposite getCompositeForm() {
            return this.m_compositeForm;
        }

        public String getCopyright() {
            return this.m_copyright;
        }

        public Long getDateLastModified() {
            return this.m_dateLastModified;
        }

        public Boolean getDeleteFlag() {
            return this.m_deleteFlag;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getFilterText() {
            return (this.m_name + " " + this.m_title + " " + this.m_copyright + " " + this.m_description).toLowerCase();
        }

        public Boolean getIsUsed() {
            return this.m_isUsed;
        }

        public String getName() {
            return this.m_name;
        }

        public Boolean getNoCopyright() {
            return CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_copyright);
        }

        public String getPath() {
            return this.m_path;
        }

        public List<CmsProperty> getPropertyList() {
            ArrayList<CmsProperty> propertyList = new ArrayList<CmsProperty>();
            propertyList.add(new CmsProperty("Title", this.m_title, null));
            propertyList.add(new CmsProperty("Copyright", this.m_copyright, null));
            propertyList.add(new CmsProperty("Description", this.m_description, null));
            return propertyList;
        }

        public CmsResource getResource() {
            return this.m_resource;
        }

        public CmsResourceUtil getResourceUtil() {
            return this.m_resourceUtil;
        }

        public String getTitle() {
            return this.m_title;
        }

        public boolean hasChanges() {
            boolean hasChanges = false;
            try {
                if (!hasChanges) {
                    boolean bl = hasChanges = !this.m_title.equals(this.readPropertyTitle());
                }
                if (!hasChanges) {
                    boolean bl = hasChanges = !this.m_copyright.equals(this.readPropertyCopyright());
                }
                if (!hasChanges) {
                    hasChanges = !this.m_description.equals(this.readPropertyDescription());
                }
            }
            catch (CmsException e) {
                hasChanges = true;
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return hasChanges;
        }

        public boolean isRenamed() {
            boolean isRenamed = false;
            try {
                isRenamed = !this.m_name.equals(this.readName());
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return isRenamed;
        }

        public boolean isTypeImage() {
            return OpenCms.getResourceManager().getResourceType(this.m_resource) instanceof CmsResourceTypeImage;
        }

        public void setCopyright(String copyright) {
            this.m_copyright = copyright;
        }

        public void setDeleteFlag(Boolean deleteFlag) {
            this.m_deleteFlag = deleteFlag;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setResource(CmsResource resource) {
            this.m_resource = resource;
            this.initData();
            this.initComponent();
        }

        public void setTitle(String title) {
            this.m_title = title;
        }

        private void initComponent() {
            this.m_compositeFile = new FileComposite(this);
            this.m_compositeFileDelete = new FileDeleteComposite(this);
            this.m_compositeForm = new FormComposite(this);
            this.m_binder.readBean((Object)this);
        }

        private void initData() {
            this.m_resourceUtil = new CmsResourceUtil(A_CmsUI.getCmsObject(), this.m_resource);
            try {
                List<CmsRelation> relations = CmsGalleryOptimizeDialog.this.getCms().getRelationsForResource(this.m_resource, CmsRelationFilter.SOURCES);
                this.m_name = this.m_resource.getName();
                this.m_path = this.m_resource.getRootPath();
                this.m_title = this.readPropertyTitle();
                this.m_copyright = this.readPropertyCopyright();
                this.m_description = this.readPropertyDescription();
                this.m_dateLastModified = this.m_resource.getDateLastModified();
                this.m_isUsed = relations != null && !relations.isEmpty();
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }

        private String readName() throws CmsException {
            CmsResourceFilter resourceFilter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireFile();
            return CmsGalleryOptimizeDialog.this.getCms().readResource(this.m_resource.getStructureId(), resourceFilter).getName();
        }

        private String readPropertyCopyright() throws CmsException {
            String value = CmsGalleryOptimizeDialog.this.getCms().readPropertyObject(this.m_resource, "Copyright", false).getValue();
            return value == null ? "" : value;
        }

        private String readPropertyDescription() throws CmsException {
            String value = CmsGalleryOptimizeDialog.this.getCms().readPropertyObject(this.m_resource, "Description", false).getValue();
            return value == null ? "" : value;
        }

        private String readPropertyTitle() throws CmsException {
            String value = CmsGalleryOptimizeDialog.this.getCms().readPropertyObject(this.m_resource, "Title", false).getValue();
            return value == null ? "" : value;
        }
    }

    private class FileComposite
    extends HorizontalLayout {
        private static final String PANEL_HEIGHT = "176px";
        private static final String PANEL_WIDTH = "206px";
        private static final String SCALE_PARAMETERS = "t:1,c:ffffff,w:200,h:170";
        private static final String SCALE_QUERY_STRING = "?__scale=t:1,c:ffffff,w:200,h:170";
        private static final long serialVersionUID = 1L;
        private DataItem m_dataItem;
        private AbsoluteLayout m_panel;

        public FileComposite(DataItem dataItem) {
            this.m_dataItem = dataItem;
            this.setSizeUndefined();
            this.setMargin(true);
            this.m_panel = new AbsoluteLayout();
            this.m_panel.setWidth(PANEL_WIDTH);
            this.m_panel.setHeight(PANEL_HEIGHT);
            this.m_panel.addStyleName("v-panel");
            Component link = this.createClickableFile();
            this.m_panel.addComponent(link, "left: 2px; top: 2px;");
            this.addComponent((Component)this.m_panel);
        }

        private Component createClickableFile() {
            Label link = this.m_dataItem.isTypeImage() ? this.createClickableImage() : this.createClickableOther();
            link.setWidth("200px");
            link.setHeight("170px");
            return link;
        }

        private Label createClickableImage() {
            CmsResource resource = this.m_dataItem.getResource();
            String image = "<img width=\"200px\" height=\"170px\" src=\"" + this.getScaleUri(resource) + "\" style=\"background: white;\">";
            String a = "<a target=\"_blank\" href=\"" + this.getPermanentUri(resource) + "\">" + image + "</a>";
            String div = "<div class=\"o-gallery-preview-image\" style=\"width:200px;height:170px;\">" + a + "</div>";
            Label label = new Label(div);
            label.setContentMode(ContentMode.HTML);
            return label;
        }

        private Link createClickableOther() {
            CmsResource resource = this.m_dataItem.getResource();
            CmsCssIcon cssIcon = (CmsCssIcon)this.m_dataItem.getResourceUtil().getSmallIconResource();
            String caption = "<div style=\"width:200px;height:170px;display: flex; justify-content: center; align-items: center;\"><span class=\"" + cssIcon.getStyleName() + "\" style=\"transform: scale(4);\"></span></div>";
            Link link = new Link(caption, (Resource)new ExternalResource(this.getPermanentUri(resource)));
            link.setCaptionAsHtml(true);
            link.setTargetName("_blank");
            return link;
        }

        private String getPermanentUri(CmsResource resource) {
            String structureId = resource.getStructureId().toString();
            String permalink = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/permalink/", structureId);
            return permalink;
        }

        private String getScaleUri(CmsResource resource) {
            String paramTimestamp = "&timestamp=" + System.currentTimeMillis();
            return this.getPermanentUri(resource) + SCALE_QUERY_STRING + paramTimestamp;
        }
    }

    private class FileDeleteComposite
    extends VerticalLayout {
        private static final long serialVersionUID = 1L;
        private static final String WIDTH = "206px";
        private DataItem m_dataItem;

        public FileDeleteComposite(DataItem dataItem) {
            this.m_dataItem = dataItem;
            this.setMargin(new MarginInfo(true, true, true, false));
            this.setSpacing(false);
            this.setWidth(WIDTH);
            this.setHeightFull();
            Label fileSize = this.createDisplayFileSize();
            this.addComponent((Component)fileSize);
            Label dimension = this.createDisplayDimension();
            if (this.m_dataItem.isTypeImage()) {
                this.addComponent((Component)dimension);
            }
            if (!this.m_dataItem.getIsUsed().booleanValue()) {
                CssLayout layout = new CssLayout();
                Label labelInUse = this.createDisplayInUseInfo();
                CheckBox fieldDeleteFlag = this.createFieldDeleteFlag();
                layout.addComponent((Component)labelInUse);
                layout.addComponent((Component)fieldDeleteFlag);
                this.addComponent((Component)layout);
                this.setExpandRatio((Component)layout, 1.0f);
                this.setComponentAlignment((Component)layout, Alignment.BOTTOM_LEFT);
            } else if (this.m_dataItem.isTypeImage()) {
                this.setExpandRatio((Component)dimension, 1.0f);
            } else {
                this.setExpandRatio((Component)fileSize, 1.0f);
            }
        }

        private Label createDisplayDimension() {
            return new Label(this.getFormattedDimension());
        }

        private Label createDisplayFileSize() {
            return new Label(this.getFormattedFileSize());
        }

        private Label createDisplayInUseInfo() {
            String notInUse = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_NOT_IN_USE_0", new Object[0]);
            return new Label(notInUse);
        }

        private CheckBox createFieldDeleteFlag() {
            String caption = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_INPUT_DELETE_UNUSED_0", new Object[0]);
            CheckBox field = new CheckBox(caption);
            field.setCaptionAsHtml(true);
            field.setWidthFull();
            field.setEnabled(!CmsGalleryOptimizeDialog.this.isReadOnly());
            this.m_dataItem.getBinder().bind((HasValue)field, DataItem::getDeleteFlag, DataItem::setDeleteFlag);
            return field;
        }

        private String getFormattedDimension() {
            String[] tokens;
            String imageSize = null;
            try {
                imageSize = CmsGalleryOptimizeDialog.this.getCms().readPropertyObject(this.m_dataItem.getResource(), "image.size", false).getValue();
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            String dimension = "? x ?";
            if (imageSize != null && (tokens = imageSize.split(",")).length == 2 && tokens[0].length() > 2 && tokens[1].length() > 2) {
                dimension = tokens[0].substring(2) + " x " + tokens[1].substring(2);
            }
            return dimension;
        }

        private String getFormattedFileSize() {
            return this.m_dataItem.getResource().getLength() / 1024 + " kb";
        }
    }

    private class FormComposite
    extends VerticalLayout {
        private static final long serialVersionUID = 1L;
        DataItem m_dataItem;

        public FormComposite(DataItem dataItem) {
            this.m_dataItem = dataItem;
            this.setSizeFull();
            this.setMargin(true);
            this.setSpacing(false);
            this.addComponent((Component)this.createCompositeResourceInfo());
            this.addComponent((Component)this.createDisplayResourceDate());
            FormLayout formLayout = new FormLayout();
            formLayout.setMargin(false);
            formLayout.setSpacing(false);
            formLayout.addStyleName("o-gallery-form");
            formLayout.addComponent((Component)this.createFieldTitle());
            formLayout.addComponent((Component)this.createFieldCopyright());
            formLayout.addComponent((Component)this.createFieldDescription());
            this.addComponent((Component)formLayout);
            this.setComponentAlignment((Component)formLayout, Alignment.BOTTOM_LEFT);
            this.setExpandRatio((Component)formLayout, 1.0f);
        }

        private CmsResourceInfo createCompositeResourceInfo() {
            CmsResourceInfo resourceInfo = new CmsResourceInfo(this.m_dataItem.getResource());
            resourceInfo.setTopLineText(this.m_dataItem.getName());
            resourceInfo.decorateTopInput();
            TextField field = resourceInfo.getTopInput();
            this.m_dataItem.getBinder().bind((HasValue)field, DataItem::getName, DataItem::setName);
            CmsGwtContextMenuButton contextMenu = new CmsGwtContextMenuButton(this.m_dataItem.getResource().getStructureId(), new ContextMenu(this.m_dataItem));
            contextMenu.addStyleName("o-gwt-contextmenu-button-margin");
            resourceInfo.setButtonWidget((Component)contextMenu);
            return resourceInfo;
        }

        private Label createDisplayResourceDate() {
            String lastModified = this.formatDateTime(this.m_dataItem.getDateLastModified());
            String lastModifiedBy = this.m_dataItem.getResourceUtil().getUserLastModified();
            String message = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LASTMODIFIED_BY_2", lastModified, lastModifiedBy);
            Label label = new Label(message);
            label.addStyleNames(new String[]{"light", "tiny"});
            return label;
        }

        private TextField createFieldCopyright() {
            String caption = CmsVaadinUtils.getMessageText("GUI_INPUT_COPYRIGHT_0", new Object[0]);
            TextField field = new TextField(caption);
            field.setWidthFull();
            field.setEnabled(!CmsGalleryOptimizeDialog.this.isReadOnly());
            this.m_dataItem.getBinder().bind((HasValue)field, DataItem::getCopyright, DataItem::setCopyright);
            return field;
        }

        private TextField createFieldDescription() {
            String caption = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_INPUT_DESCRIPTION_0", new Object[0]);
            TextField field = new TextField(caption);
            field.setWidthFull();
            field.setEnabled(!CmsGalleryOptimizeDialog.this.isReadOnly());
            this.m_dataItem.getBinder().bind((HasValue)field, DataItem::getDescription, DataItem::setDescription);
            return field;
        }

        private TextField createFieldTitle() {
            String caption = CmsVaadinUtils.getMessageText("GUI_INPUT_TITLE_0", new Object[0]);
            TextField field = new TextField(caption);
            field.setWidthFull();
            field.setEnabled(!CmsGalleryOptimizeDialog.this.isReadOnly());
            this.m_dataItem.getBinder().bind((HasValue)field, DataItem::getTitle, DataItem::setTitle);
            return field;
        }

        private String formatDateTime(long date) {
            return CmsDateUtil.getDateTime(new Date(date), 3, OpenCms.getWorkplaceManager().getWorkplaceLocale(CmsGalleryOptimizeDialog.this.getCms()));
        }
    }

    public class ContextMenu
    implements I_CmsGwtContextMenuServerRpc {
        private static final long serialVersionUID = 1L;
        private final DataItem m_dataItem;

        public ContextMenu(DataItem dataItem) {
            this.m_dataItem = dataItem;
        }

        @Override
        public void refresh(String uuid) {
            if (uuid != null) {
                try {
                    boolean deleted;
                    TimeUnit.SECONDS.sleep(1L);
                    CmsResource resource = CmsGalleryOptimizeDialog.this.getCms().readResource(new CmsUUID(uuid), CmsResourceFilter.ONLY_VISIBLE);
                    boolean bl = deleted = resource.getState() == CmsResourceState.STATE_DELETED;
                    if (deleted) {
                        CmsGalleryOptimizeDialog.this.handleDataListDelete(Arrays.asList(this.m_dataItem));
                    } else {
                        CmsGalleryOptimizeDialog.this.handleDataListUpdate(Arrays.asList(this.m_dataItem));
                    }
                    String message = CmsVaadinUtils.getMessageText("GUI_GALLERY_OPTIMIZE_LABEL_SUCCESSFULLY_SAVED_0", new Object[0]);
                    Notification notification = new Notification(message, "", Notification.Type.HUMANIZED_MESSAGE);
                    notification.setPosition(Position.TOP_CENTER);
                    notification.show(Page.getCurrent());
                    CmsAppWorkplaceUi.get().enableGlobalShortcuts();
                }
                catch (InterruptedException | CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    Notification notification = new Notification("", e.getLocalizedMessage(), Notification.Type.ERROR_MESSAGE);
                    notification.setHtmlContentAllowed(true);
                    notification.setPosition(Position.TOP_CENTER);
                    notification.show(Page.getCurrent());
                }
            }
        }
    }
}

