/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.data.HasValue;
import com.vaadin.server.Page;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.ComboBox;
import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.CmsCoreService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.I_CmsHasAppLaunchCommand;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsExtendedSiteSelector;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsUUID;

public class CmsProjectSelectDialog
extends CmsBasicDialog {
    static final Log LOG = CmsLog.getLog(CmsProjectSelectDialog.class);
    private static final String CAPTION_PROPERTY = "caption";
    private static final long serialVersionUID = 4455901453008760434L;
    private Button m_cancelButton;
    private I_CmsDialogContext m_context;
    private ComboBox m_projectComboBox;
    private CmsExtendedSiteSelector m_siteComboBox;

    public CmsProjectSelectDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.setContent((Component)this.initForm());
        this.m_cancelButton = this.createButtonCancel();
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsProjectSelectDialog.this.cancel();
            }
        });
        this.addButton((Component)this.m_cancelButton);
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsProjectSelectDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsProjectSelectDialog.this.submit();
            }
        });
    }

    public static void changeSiteOrProject(I_CmsDialogContext context, CmsUUID projectId, CmsExtendedSiteSelector.SiteSelectorOption siteOption) {
        String siteRoot = null;
        try {
            CmsProject project = null;
            if (projectId != null) {
                project = context.getCms().readProject(projectId);
                if (!context.getCms().getRequestContext().getCurrentProject().equals(project)) {
                    A_CmsUI.get().changeProject(project);
                } else {
                    project = null;
                }
            }
            if (siteOption != null) {
                siteRoot = siteOption.getSite();
                if (!context.getCms().getRequestContext().getSiteRoot().equals(siteRoot)) {
                    A_CmsUI.get().changeSite(siteRoot);
                } else if (siteOption.getPath() == null) {
                    siteRoot = null;
                }
            }
            if (siteRoot != null && "explorer".equals(context.getAppId())) {
                if (siteOption.getPath() != null) {
                    CmsResource defaultFile = null;
                    try {
                        defaultFile = A_CmsUI.getCmsObject().readDefaultFile(siteOption.getPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (defaultFile != null) {
                        Page.getCurrent().setLocation(OpenCms.getLinkManager().substituteLinkForUnknownTarget(A_CmsUI.getCmsObject(), siteOption.getPath()));
                        return;
                    }
                    Page.getCurrent().open(CmsCoreService.getFileExplorerLink(A_CmsUI.getCmsObject(), siteOption.getSite()) + siteOption.getPath(), "_top");
                } else {
                    I_CmsWorkplaceAppConfiguration editorConf = OpenCms.getWorkplaceAppManager().getAppConfiguration("pageeditor");
                    if (editorConf.getVisibility(context.getCms()).isActive()) {
                        ((I_CmsHasAppLaunchCommand)((Object)editorConf)).getAppLaunchCommand().run();
                        return;
                    }
                }
            }
            context.finish(project, siteRoot);
        }
        catch (CmsException e) {
            context.error(e);
        }
    }

    void cancel() {
        this.m_context.finish(Collections.emptyList());
    }

    void submit() {
        I_CmsDialogContext context = this.m_context;
        CmsUUID projectId = (CmsUUID)this.m_projectComboBox.getValue();
        CmsExtendedSiteSelector.SiteSelectorOption option = (CmsExtendedSiteSelector.SiteSelectorOption)this.m_siteComboBox.getValue();
        CmsProjectSelectDialog.changeSiteOrProject(context, projectId, option);
    }

    private FormLayout initForm() {
        FormLayout form = new FormLayout();
        form.setWidth("100%");
        this.m_siteComboBox = this.prepareSiteSelector("GUI_LABEL_SITE_0");
        this.m_siteComboBox.selectSite(this.m_context.getCms().getRequestContext().getSiteRoot());
        form.addComponent((Component)this.m_siteComboBox);
        this.m_siteComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)evt -> this.submit());
        IndexedContainer projects = CmsVaadinUtils.getProjectsContainer(this.m_context.getCms(), CAPTION_PROPERTY);
        this.m_projectComboBox = this.prepareComboBox(projects, "GUI_LABEL_PROJECT_0");
        CmsUUID currentProjectId = this.m_context.getCms().getRequestContext().getCurrentProject().getUuid();
        if (projects.containsId((Object)currentProjectId)) {
            this.m_projectComboBox.select((Object)currentProjectId);
        } else {
            try {
                CmsUUID ouProject = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.m_context.getCms(), this.m_context.getCms().getRequestContext().getOuFqn()).getProjectId();
                if (projects.containsId((Object)ouProject)) {
                    this.m_projectComboBox.select((Object)ouProject);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)"Error while reading current OU.", (Throwable)e);
            }
        }
        form.addComponent((Component)this.m_projectComboBox);
        this.m_projectComboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)evt -> this.submit());
        return form;
    }

    private ComboBox prepareComboBox(IndexedContainer container, String captionKey) {
        ComboBox result = new ComboBox(CmsVaadinUtils.getWpMessagesForCurrentLocale().key(captionKey), (Container)container);
        result.setTextInputAllowed(true);
        result.setNullSelectionAllowed(false);
        result.setWidth("100%");
        result.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
        result.setItemCaptionPropertyId((Object)CAPTION_PROPERTY);
        result.setFilteringMode(FilteringMode.CONTAINS);
        return result;
    }

    private CmsExtendedSiteSelector prepareSiteSelector(String captionKey) {
        CmsExtendedSiteSelector result = new CmsExtendedSiteSelector();
        boolean isExplorer = "explorer".equals(this.m_context.getAppId());
        result.initOptions(this.m_context.getCms(), isExplorer);
        result.setPageLength(20);
        result.setCaption(CmsVaadinUtils.getWpMessagesForCurrentLocale().key(captionKey));
        result.setWidth("100%");
        result.setPlaceholder(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_EXPLORER_CLICK_TO_EDIT_0"));
        return result;
    }
}

