/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.ui.CheckBox;
import com.vaadin.v7.ui.Label;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.CmsReindexDialogAction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsOkCancelActionHandler;
import org.opencms.util.CmsUUID;

public class CmsReindexDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsReindexDialog.class);
    private static final long serialVersionUID = 1L;
    protected I_CmsDialogContext m_context;
    private Button m_cancelButton;
    private Button m_okButton;
    private Label m_infoText;
    private CheckBox m_reindexRelated;
    private boolean m_isOnline;

    public CmsReindexDialog(I_CmsDialogContext context) {
        this.m_context = context;
        this.m_isOnline = context.getCms().getRequestContext().getCurrentProject().isOnlineProject();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(A_CmsUI.get().getLocale()), null);
        String indexType = CmsVaadinUtils.getMessageText(this.m_isOnline ? "GUI_REINDEX_INDEX_TYPE_ONLINE_0" : "GUI_REINDEX_INDEX_TYPE_OFFLINE_0", new Object[0]);
        this.m_infoText.setValue(CmsVaadinUtils.getMessageText("GUI_REINDEX_CONFIRMATION_1", indexType));
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsReindexDialog.this.cancel();
            }
        });
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsReindexDialog.this.reindex();
                CmsReindexDialog.this.m_context.finish(new ArrayList<CmsUUID>());
            }
        });
        this.displayResourceInfo(this.m_context.getResources());
        this.setActionHandler(new CmsOkCancelActionHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancel() {
                CmsReindexDialog.this.cancel();
            }

            @Override
            protected void ok() {
                CmsReindexDialog.this.reindex();
            }
        });
    }

    protected void reindex() {
        CmsObject cms = A_CmsUI.getCmsObject();
        HashMap<String, Object> eventData = new HashMap<String, Object>(3);
        if (!this.m_isOnline) {
            eventData.put("projectId", cms.getRequestContext().getCurrentProject().getId());
        }
        eventData.put("resources", this.m_context.getResources());
        eventData.put("report", new CmsLogReport(CmsLocaleManager.getDefaultLocale(), CmsReindexDialogAction.class));
        eventData.put("userId", cms.getRequestContext().getCurrentUser().getId());
        Boolean reindexRelated = (Boolean)this.m_reindexRelated.getValue();
        eventData.put("related", reindexRelated);
        CmsEvent reindexEvent = new CmsEvent(this.m_isOnline ? 34 : 35, eventData);
        OpenCms.fireCmsEvent(reindexEvent);
    }

    void cancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }
}

