/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.dialogs.permissions;

import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.IndexedContainer;
import com.vaadin.v7.data.util.filter.Or;
import com.vaadin.v7.data.util.filter.SimpleStringFilter;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.dialogs.permissions.CmsPermissionDialog;
import org.opencms.ui.dialogs.permissions.CmsPermissionView;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPermissionViewTable
extends Table {
    private static final long serialVersionUID = -2759899760528588890L;
    private static final String PROP_VIEW = "view";
    private static final String PROP_NAME = "name";
    boolean m_editable;
    IndexedContainer m_container;
    CmsPermissionDialog m_dialog;

    public CmsPermissionViewTable(CmsObject cms, List<CmsAccessControlEntry> entries, boolean editable, boolean showRes, Map<CmsUUID, String> parents, CmsPermissionDialog dialog) {
        this.m_editable = editable;
        this.m_dialog = dialog;
        this.setHeight("450px");
        this.setWidth("100%");
        this.setPageLength(4);
        this.setColumnHeaderMode(Table.ColumnHeaderMode.HIDDEN);
        this.m_container = new IndexedContainer();
        this.m_container.addContainerProperty((Object)PROP_VIEW, VerticalLayout.class, null);
        this.m_container.addContainerProperty((Object)PROP_NAME, String.class, (Object)"");
        this.setCellStyleGenerator(new Table.CellStyleGenerator(){
            private static final long serialVersionUID = 3943163625035784161L;

            public String getStyle(Table source, Object itemId, Object propertyId) {
                return " o-table-const-color";
            }
        });
        Iterator<CmsAccessControlEntry> i = entries.iterator();
        boolean hasEntries = i.hasNext();
        if (hasEntries) {
            while (i.hasNext()) {
                CmsAccessControlEntry curEntry = i.next();
                CmsPermissionView view = this.m_dialog.buildPermissionEntryForm(curEntry, this.m_editable, false, showRes ? curEntry.getResource() : null);
                Item item = this.m_container.addItem((Object)view);
                item.getItemProperty((Object)PROP_VIEW).setValue((Object)this.getLayoutFromEntry(cms, curEntry, view, showRes ? parents.get(curEntry.getResource()) : null));
                item.getItemProperty((Object)PROP_NAME).setValue((Object)view.getPrincipalName());
            }
        }
        this.setContainerDataSource((Container)this.m_container);
        this.setVisibleColumns(new Object[]{PROP_VIEW});
    }

    public void filterTable(String search) {
        this.m_container.removeAllContainerFilters();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(search)) {
            this.m_container.addContainerFilter((Container.Filter)new Or(new Container.Filter[]{new SimpleStringFilter((Object)PROP_NAME, search, true, false)}));
        }
    }

    private VerticalLayout getLayoutFromEntry(CmsObject cms, CmsAccessControlEntry entry, final CmsPermissionView view, String resPath) {
        VerticalLayout res = new VerticalLayout();
        res.setSpacing(false);
        I_CmsPrincipal principal = null;
        try {
            principal = CmsPrincipal.readPrincipalIncludingHistory(cms, entry.getPrincipal());
        }
        catch (CmsException e) {
            principal = new CmsGroup(entry.getPrincipal(), null, "", "", 0);
        }
        if (principal != null) {
            CmsResourceInfo info = CmsAccountsApp.getPrincipalInfo(principal);
            if (view.isEditable()) {
                CssLayout cssl = new CssLayout();
                Button removeButton = new Button((Resource)FontOpenCms.TRASH_SMALL);
                removeButton.addStyleName("borderless o-toolbar-button o-resourceinfo-toolbar o-toolbar-icon-visible");
                removeButton.addClickListener(new Button.ClickListener(){
                    private static final long serialVersionUID = -6112693137800596485L;

                    public void buttonClick(Button.ClickEvent event) {
                        view.deletePermissionSet();
                    }
                });
                cssl.addComponent((Component)removeButton);
                info.setButtonWidget((Component)cssl);
            }
            res.addComponent((Component)info);
            if (resPath != null) {
                Label resLabel = new Label(CmsVaadinUtils.getMessageText("GUI_PERMISSION_INHERITED_FROM_1", resPath));
                resLabel.addStyleName("o-report");
                res.addComponent((Component)resLabel);
            }
        }
        res.addComponent((Component)view);
        return res;
    }

    class ViewColumn
    implements Table.ColumnGenerator {
        private static final long serialVersionUID = -3772456970393398685L;

        ViewColumn() {
        }

        public Object generateCell(Table source, Object itemId, Object columnId) {
            return CmsPermissionViewTable.this.m_dialog.buildPermissionEntryForm((CmsAccessControlEntry)itemId, CmsPermissionViewTable.this.m_editable, false, null);
        }
    }
}

