/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.editors.messagebundle;

import com.vaadin.event.Action;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ShortcutAction;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.DefaultFieldFactory;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Table;
import com.vaadin.v7.ui.TextArea;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchException;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.components.extensions.CmsAutoGrowingTextArea;
import org.opencms.ui.editors.messagebundle.Messages;
import org.tepi.filtertable.FilterTable;

public final class CmsMessageBundleEditorTypes {
    static final Log LOG = CmsLog.getLog(CmsMessageBundleEditorTypes.class);
    public static final int OPTION_COLUMN_WIDTH = 42;
    public static final String OPTION_COLUMN_WIDTH_PX = "42px";

    private CmsMessageBundleEditorTypes() {
    }

    public static CmsResource getDescriptor(CmsObject cms, String basename) {
        CmsSolrResultList results;
        CmsSolrQuery query = new CmsSolrQuery();
        query.setResourceTypes(BundleType.DESCRIPTOR.toString());
        query.setFilterQueries(new String[]{"filename:\"" + basename + "_desc" + "\""});
        query.add("fl", new String[]{"path"});
        try {
            boolean isOnlineProject = cms.getRequestContext().getCurrentProject().isOnlineProject();
            String indexName = isOnlineProject ? "Solr Online" : "Solr Offline";
            results = OpenCms.getSearchManager().getIndexSolr(indexName).search(cms, query, true, null, true, null);
        }
        catch (CmsSearchException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_BUNDLE_DESCRIPTOR_SEARCH_ERROR_0"), (Throwable)e);
            return null;
        }
        switch (results.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CmsResource)results.get(0);
            }
        }
        String files = "";
        for (CmsResource res : results) {
            files = files + " " + res.getRootPath();
        }
        LOG.warn((Object)Messages.get().getBundle().key("ERR_BUNDLE_DESCRIPTOR_NOT_UNIQUE_1", files));
        return (CmsResource)results.get(0);
    }

    static void showWarning(String caption, String description) {
        Notification warning = new Notification(caption, description, Notification.Type.WARNING_MESSAGE, true);
        warning.setDelayMsec(-1);
        warning.show(UI.getCurrent().getPage());
    }

    public static enum BundleType {
        PROPERTY,
        XML,
        DESCRIPTOR;


        public static BundleType toBundleType(String value) {
            if (null == value) {
                return null;
            }
            if (value.equals(PROPERTY.toString())) {
                return PROPERTY;
            }
            if (value.equals(XML.toString())) {
                return XML;
            }
            if (value.equals(DESCRIPTOR.toString())) {
                return DESCRIPTOR;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case PROPERTY: {
                    return "propertyvfsbundle";
                }
                case XML: {
                    return "xmlvfsbundle";
                }
                case DESCRIPTOR: {
                    return "bundledescriptor";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class Descriptor {
        public static final String N_MESSAGE = "Message";
        public static final String N_KEY = "Key";
        public static final String N_DESCRIPTION = "Description";
        public static final String N_DEFAULT = "Default";
        public static final Locale LOCALE = new Locale("en");
        public static final String POSTFIX = "_desc";
    }

    static class TranslateTableFieldFactory
    extends DefaultFieldFactory {
        private final Map<Integer, Map<Integer, AbstractTextField>> m_valueFields;
        private final List<TableProperty> m_editableColumns;
        final FilterTable m_table;
        private final Set<I_EntryChangeListener> m_keyChangeListeners = new HashSet<I_EntryChangeListener>();

        public TranslateTableFieldFactory(FilterTable table, List<TableProperty> editableColumns) {
            this.m_table = table;
            this.m_valueFields = new HashMap<Integer, Map<Integer, AbstractTextField>>();
            this.m_editableColumns = editableColumns;
        }

        public Field<?> createField(Container container, final Object itemId, Object propertyId, Component uiContext) {
            final TableProperty pid = (TableProperty)((Object)propertyId);
            for (int i = 1; i <= this.m_editableColumns.size(); ++i) {
                TextField tf;
                if (!pid.equals((Object)this.m_editableColumns.get(i - 1))) continue;
                if (pid.equals((Object)TableProperty.KEY)) {
                    tf = new TextField();
                    tf.addValidator((Validator)new KeyValidator());
                } else {
                    TextArea atf = new TextArea();
                    atf.setRows(1);
                    CmsAutoGrowingTextArea.addTo(atf, 20);
                    tf = atf;
                }
                tf.setWidth("100%");
                tf.setResponsive(true);
                tf.setInputPrompt(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_PLEASE_ADD_VALUE_0"));
                tf.setData((Object)new ComponentData(i, itemId, ""));
                if (!this.m_valueFields.containsKey(i)) {
                    this.m_valueFields.put(i, new HashMap());
                }
                this.m_valueFields.get(i).put((Integer)itemId, (AbstractTextField)tf);
                tf.addFocusListener(new FieldEvents.FocusListener(){

                    public void focus(FieldEvents.FocusEvent event) {
                        if (!m_table.isSelected(itemId)) {
                            m_table.select(itemId);
                        }
                        AbstractTextField field = (AbstractTextField)event.getComponent();
                        ComponentData data = (ComponentData)field.getData();
                        data.setLastValue((String)field.getValue());
                        field.setData((Object)data);
                    }
                });
                tf.addBlurListener(new FieldEvents.BlurListener(){

                    public void blur(FieldEvents.BlurEvent event) {
                        AbstractTextField field = (AbstractTextField)event.getComponent();
                        ComponentData data = (ComponentData)field.getData();
                        if (!data.getLastValue().equals(field.getValue())) {
                            EntryChangeEvent ev = new EntryChangeEvent(field, data.getItemId(), (Object)pid, data.getLastValue(), (String)field.getValue());
                            this.fireKeyChangeEvent(ev);
                        }
                    }
                });
                return tf;
            }
            return null;
        }

        public List<TableProperty> getEditableColumns() {
            return this.m_editableColumns;
        }

        public Map<Integer, Map<Integer, AbstractTextField>> getValueFields() {
            return this.m_valueFields;
        }

        public void registerKeyChangeListener(I_EntryChangeListener listener) {
            this.m_keyChangeListeners.add(listener);
        }

        void fireKeyChangeEvent(EntryChangeEvent ev) {
            for (I_EntryChangeListener listener : this.m_keyChangeListeners) {
                listener.handleEntryChange(ev);
            }
        }
    }

    static class TranslateTableCellStyleGenerator
    implements Table.CellStyleGenerator {
        private List<TableProperty> m_editableColums;

        public TranslateTableCellStyleGenerator(List<TableProperty> editableColumns) {
            this.m_editableColums = editableColumns;
            if (null == this.m_editableColums) {
                this.m_editableColums = new ArrayList<TableProperty>();
            }
        }

        public String getStyle(Table source, Object itemId, Object propertyId) {
            String result = TableProperty.KEY.equals(propertyId) ? "key-" : "";
            result = result + (this.m_editableColums.contains(propertyId) ? "editable" : "fix");
            return result;
        }
    }

    static class TableKeyboardHandler
    implements Action.Handler {
        private FilterTable m_table;
        private Action m_tabNext = new ShortcutAction("Tab", 9, null);
        private Action m_tabPrev = new ShortcutAction("Shift+Tab", 9, new int[]{16});
        private Action m_curDown = new ShortcutAction("Down", 40, null);
        private Action m_curUp = new ShortcutAction("Up", 38, null);
        private Action m_enter = new ShortcutAction("Enter", 13, null);

        public TableKeyboardHandler(FilterTable table) {
            this.m_table = table;
        }

        public Action[] getActions(Object target, Object sender) {
            return new Action[]{this.m_tabNext, this.m_tabPrev, this.m_curDown, this.m_curUp, this.m_enter};
        }

        public void handleAction(Action action, Object sender, Object target) {
            TranslateTableFieldFactory fieldFactory = (TranslateTableFieldFactory)this.m_table.getTableFieldFactory();
            List<TableProperty> editableColums = fieldFactory.getEditableColumns();
            if (target instanceof AbstractTextField) {
                int currentRow;
                ComponentData data = (ComponentData)((AbstractTextField)target).getData();
                if (null == data) {
                    return;
                }
                int colId = data.getEditableColumnId();
                Integer rowIdInteger = (Integer)data.getItemId();
                int rowId = rowIdInteger;
                List visibleItemIds = (List)this.m_table.getVisibleItemIds();
                if (action == this.m_curDown || action == this.m_enter) {
                    currentRow = visibleItemIds.indexOf(rowId);
                    if (currentRow < visibleItemIds.size() - 1) {
                        rowId = (Integer)visibleItemIds.get(currentRow + 1);
                    }
                } else if (action == this.m_curUp) {
                    currentRow = visibleItemIds.indexOf(rowId);
                    if (currentRow > 0) {
                        rowId = (Integer)visibleItemIds.get(currentRow - 1);
                    }
                } else if (action == this.m_tabNext) {
                    int nextColId = this.getNextColId(editableColums, colId);
                    if (colId >= nextColId) {
                        int currentRow2 = visibleItemIds.indexOf(rowId);
                        rowId = (Integer)visibleItemIds.get((currentRow2 + 1) % visibleItemIds.size());
                    }
                    colId = nextColId;
                } else if (action == this.m_tabPrev) {
                    int previousColId = this.getPreviousColId(editableColums, colId);
                    if (colId <= previousColId) {
                        int currentRow3 = visibleItemIds.indexOf(rowId);
                        rowId = (Integer)visibleItemIds.get((currentRow3 + visibleItemIds.size() - 1) % visibleItemIds.size());
                    }
                    colId = previousColId;
                }
                AbstractTextField newTF = fieldFactory.getValueFields().get(colId).get(rowId);
                if (newTF != null) {
                    newTF.focus();
                }
            }
        }

        private int getNextColId(List<TableProperty> editableColumns, int colId) {
            int i = colId % editableColumns.size();
            while (i != colId - 1) {
                if (!this.m_table.isColumnCollapsed((Object)editableColumns.get(i))) {
                    return i + 1;
                }
                i = (i + 1) % editableColumns.size();
            }
            return colId;
        }

        private int getPreviousColId(List<TableProperty> editableColumns, int colId) {
            int i = (colId + editableColumns.size() - 2) % editableColumns.size();
            while (i != colId - 1) {
                if (!this.m_table.isColumnCollapsed((Object)editableColumns.get(i))) {
                    return i + 1;
                }
                i = (i + editableColumns.size() - 1) % editableColumns.size();
            }
            return colId;
        }
    }

    static class OptionColumnGenerator
    implements Table.ColumnGenerator {
        Map<Object, Collection<Component>> m_buttons = new HashMap<Object, Collection<Component>>();
        Object m_selectedItem;
        FilterTable m_table;
        I_ItemDeletionListener m_listener;

        public OptionColumnGenerator(FilterTable table) {
            this.m_table = table;
            this.m_table.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    this.selectItem(m_table.getValue());
                }
            });
        }

        public Object generateCell(Table source, final Object itemId, Object columnId) {
            CmsMessages messages = Messages.get().getBundle(UI.getCurrent().getLocale());
            HorizontalLayout options = new HorizontalLayout();
            Button delete = new Button();
            delete.addStyleName("icon-only");
            delete.addStyleName("borderless-colored");
            delete.setDescription(messages.key("GUI_REMOVE_ROW_0"));
            delete.setIcon((Resource)FontOpenCms.CIRCLE_MINUS, messages.key("GUI_REMOVE_ROW_0"));
            delete.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    ItemDeletionEvent e = new ItemDeletionEvent(itemId);
                    if (null == m_listener || m_listener.handleItemDeletion(e)) {
                        m_table.removeItem(itemId);
                    }
                }
            });
            options.addComponent((Component)delete);
            ArrayList<Button> buttons = new ArrayList<Button>(1);
            buttons.add(delete);
            this.m_buttons.put(itemId, buttons);
            if (source.isSelected(itemId)) {
                this.selectItem(itemId);
            }
            return options;
        }

        void registerItemDeletionListener(I_ItemDeletionListener listener) {
            this.m_listener = listener;
        }

        void selectItem(Object itemId) {
            if (null != this.m_selectedItem && null != this.m_buttons.get(this.m_selectedItem)) {
                for (Component button : this.m_buttons.get(this.m_selectedItem)) {
                    button.removeStyleName("borderless");
                    button.addStyleName("borderless-colored");
                }
            }
            this.m_selectedItem = itemId;
            if (null != this.m_selectedItem && null != this.m_buttons.get(this.m_selectedItem)) {
                for (Component button : this.m_buttons.get(this.m_selectedItem)) {
                    button.removeStyleName("borderless-colored");
                    button.addStyleName("borderless");
                }
            }
        }
    }

    static class KeyValidator
    extends AbstractStringValidator {
        public KeyValidator() {
            super(Messages.get().getBundle(UI.getCurrent().getLocale()).key("GUI_INVALID_KEY_0"));
        }

        protected boolean isValidValue(String value) {
            if (null == value) {
                return true;
            }
            return !value.matches(".*\\p{IsWhite_Space}.*");
        }
    }

    static final class KeySet {
        Map<Object, Integer> m_keyset = new HashMap<Object, Integer>();

        public Set<Object> getKeySet() {
            return new HashSet<Object>(this.m_keyset.keySet());
        }

        public void removeKey(String key) {
            this.m_keyset.remove(key);
        }

        public void renameKey(String oldKey, String newKey) {
            if (this.m_keyset.containsKey(oldKey) && !this.m_keyset.containsKey(newKey)) {
                Integer count = this.m_keyset.get(oldKey);
                this.m_keyset.remove(oldKey);
                this.m_keyset.put(newKey, count);
            }
        }

        public void updateKeySet(Set<Object> oldKeys, Set<Object> newKeys) {
            if (null != oldKeys) {
                HashSet<Object> removedKeys = new HashSet<Object>(oldKeys);
                if (null != newKeys) {
                    removedKeys.removeAll(newKeys);
                }
                for (Object e : removedKeys) {
                    int uses;
                    Integer i = this.m_keyset.get(e);
                    int n = uses = null != i ? i : 0;
                    if (uses > 1) {
                        this.m_keyset.put(e, uses - 1);
                        continue;
                    }
                    if (uses != 1) continue;
                    this.m_keyset.remove(e);
                }
            }
            if (null != newKeys) {
                HashSet<Object> addedKeys = new HashSet<Object>(newKeys);
                if (null != oldKeys) {
                    addedKeys.removeAll(oldKeys);
                }
                for (Object e : addedKeys) {
                    if (this.m_keyset.containsKey(e)) {
                        this.m_keyset.put(e, this.m_keyset.get(e) + 1);
                        continue;
                    }
                    this.m_keyset.put(e, 1);
                }
            }
        }
    }

    static class ItemDeletionEvent {
        private Object m_itemId;

        public ItemDeletionEvent(Object itemId) {
            this.m_itemId = itemId;
        }

        public Object getItemId() {
            return this.m_itemId;
        }
    }

    static interface I_OptionListener {
        public boolean handleAddKey(String var1);

        public void handleLanguageChange(Locale var1);

        public void handleModeChange(EditMode var1);
    }

    static interface I_ItemDeletionListener {
        public boolean handleItemDeletion(ItemDeletionEvent var1);
    }

    static interface I_EntryChangeListener {
        public void handleEntryChange(EntryChangeEvent var1);
    }

    static class EntryChangeEvent {
        private AbstractTextField m_source;
        private Object m_itemId;
        private Object m_propertyId;
        private String m_oldValue;
        private String m_newValue;

        public EntryChangeEvent(AbstractTextField source, Object itemId, Object propertyId, String oldKey, String newKey) {
            this.m_source = source;
            this.m_itemId = itemId;
            this.m_propertyId = propertyId;
            this.m_oldValue = oldKey;
            this.m_newValue = newKey;
        }

        public Object getItemId() {
            return this.m_itemId;
        }

        public String getNewValue() {
            return this.m_newValue;
        }

        public String getOldValue() {
            return this.m_oldValue;
        }

        public Object getPropertyId() {
            return this.m_propertyId;
        }

        public AbstractTextField getSource() {
            return this.m_source;
        }
    }

    static class EditorState {
        private List<TableProperty> m_editableColumns;
        private boolean m_showOptions;

        public EditorState(List<TableProperty> editableColumns, boolean showOptions) {
            this.m_editableColumns = editableColumns;
            this.m_showOptions = showOptions;
        }

        public List<TableProperty> getEditableColumns() {
            return this.m_editableColumns;
        }

        public boolean isShowOptions() {
            return this.m_showOptions;
        }
    }

    static enum EditMode {
        MASTER,
        DEFAULT;

    }

    static class ComponentData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int m_editableId;
        private Object m_itemId;
        private String m_lastValue;

        public ComponentData(int editableId, Object itemId, String lastValue) {
            this.m_editableId = editableId;
            this.m_itemId = itemId;
            this.m_lastValue = lastValue;
        }

        public int getEditableColumnId() {
            return this.m_editableId;
        }

        public Object getItemId() {
            return this.m_itemId;
        }

        public String getLastValue() {
            return this.m_lastValue;
        }

        public void setLastValue(String lastValue) {
            this.m_lastValue = lastValue;
        }
    }

    public static enum TableProperty {
        KEY,
        DESCRIPTION,
        DEFAULT,
        TRANSLATION,
        OPTIONS;

    }
}

