/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.google.common.collect.Maps;
import com.vaadin.annotations.DesignRoot;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.OptionGroup;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.opencms.db.CmsLoginMessage;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.components.CmsFakeWindow;
import org.opencms.ui.login.CmsLoginController;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.login.CmsLoginOuSelector;
import org.opencms.ui.login.CmsLoginPasswordField;
import org.opencms.workplace.CmsWorkplaceMessages;

@DesignRoot
public class CmsLoginForm
extends VerticalLayout {
    public static final String PC_TYPE_PRIVATE = "private";
    public static final String PC_TYPE_PUBLIC = "public";
    private static final long serialVersionUID = 1L;
    protected CmsLoginController m_controller;
    private Label m_copyright;
    private Label m_error;
    private Button m_forgotPasswordButton;
    private CmsFakeWindow m_fakeWindow;
    private Label m_additionalMessage;
    private Button m_loginButton;
    private Button m_optionsButton;
    private boolean m_optionsVisible;
    private CmsLoginOuSelector m_ouSelect;
    private CmsLoginPasswordField m_passwordField;
    private Button m_showPasswordButton;
    private OptionGroup m_securityField;
    private TextField m_userField;
    private boolean m_multipleOus;

    public CmsLoginForm(CmsLoginController controller, Locale locale) {
        this.m_controller = controller;
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(locale);
        HashMap macros = Maps.newHashMap();
        macros.put("showSecure", "" + controller.isShowSecure());
        String pctype = controller.getPcType();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, messages, macros);
        this.m_securityField.addItem((Object)PC_TYPE_PUBLIC);
        this.m_securityField.addItem((Object)PC_TYPE_PRIVATE);
        this.m_securityField.setValue((Object)pctype);
        this.m_copyright.setContentMode(ContentMode.HTML);
        this.m_copyright.setValue(CmsLoginHelper.getCopyrightHtml(locale));
        CmsLoginMessage beforeLoginMessage = OpenCms.getLoginManager().getBeforeLoginMessage();
        if (beforeLoginMessage != null && beforeLoginMessage.isEnabled()) {
            this.m_additionalMessage.setVisible(true);
            this.m_additionalMessage.setContentMode(ContentMode.HTML);
            this.m_additionalMessage.setValue(beforeLoginMessage.getMessage());
        }
        this.m_securityField.setItemCaption((Object)PC_TYPE_PRIVATE, messages.key("GUI_LOGIN_PCTYPE_PRIVATE_0"));
        this.m_securityField.setItemCaption((Object)PC_TYPE_PUBLIC, messages.key("GUI_LOGIN_PCTYPE_PUBLIC_0"));
        this.setWidth("600px");
        this.m_loginButton.setClickShortcut(13, new int[0]);
        this.m_loginButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLoginForm.this.m_controller.onClickLogin();
            }
        });
        this.addAttachListener(new ClientConnector.AttachListener(){
            private static final long serialVersionUID = 1L;

            public void attach(ClientConnector.AttachEvent event) {
                CmsLoginForm.this.m_userField.focus();
            }
        });
        Button.ClickListener forgotPasswordListener = new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLoginForm.this.m_controller.onClickForgotPassword();
            }
        };
        this.m_forgotPasswordButton.addClickListener(forgotPasswordListener);
        this.m_optionsButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsLoginForm.this.toggleOptionsVisible();
            }
        });
        this.m_error.setContentMode(ContentMode.HTML);
        this.m_showPasswordButton.addStyleName("o-login-show-password");
        this.m_showPasswordButton.addStyleName("borderless");
        this.m_showPasswordButton.addStyleName("o-button-unpadded");
        this.m_showPasswordButton.setIcon((Resource)FontAwesome.EYE_SLASH);
        this.m_showPasswordButton.addClickListener((Button.ClickListener & Serializable)evt -> this.togglePasswordVisible());
    }

    public void clearError() {
        this.m_error.setVisible(false);
    }

    public String getOrgUnit() {
        return this.m_ouSelect.getValue();
    }

    public String getPassword() {
        return (String)this.m_passwordField.getValue();
    }

    public String getPcType() {
        return "" + this.m_securityField.getValue();
    }

    public String getUser() {
        return (String)this.m_userField.getValue();
    }

    public void resetPassword() {
        this.m_passwordField.clear();
    }

    public void selectOrgUnit(String preselectedOu) {
        if (preselectedOu == null) {
            preselectedOu = OpenCms.getLoginManager().isOrgUnitRequired() ? "OU_NONE" : "/";
        }
        this.m_ouSelect.setValue(preselectedOu);
    }

    public void setOptionsVisible(boolean optionsVisible) {
        this.m_optionsVisible = optionsVisible;
        boolean ousVisible = optionsVisible && !this.m_ouSelect.isAlwaysHidden();
        this.m_ouSelect.setVisible(ousVisible);
        this.m_forgotPasswordButton.setVisible(optionsVisible);
        String optionsMessage = CmsVaadinUtils.getMessageText(optionsVisible ? "GUI_LOGIN_OPTIONS_HIDE_0" : "GUI_LOGIN_OPTIONS_SHOW_0", new Object[0]);
        this.m_optionsButton.setCaption(optionsMessage);
    }

    public void setSelectableOrgUnits(List<CmsOrganizationalUnit> ous) {
        boolean addEmptySelection = OpenCms.getLoginManager().isOrgUnitRequired() && ous.size() > 1;
        this.m_ouSelect.initOrgUnits(ous, addEmptySelection);
        boolean optionsVisible = addEmptySelection && ous.size() > 1;
        this.setOptionsVisible(optionsVisible);
    }

    public void toggleOptionsVisible() {
        this.setOptionsVisible(!this.m_optionsVisible);
    }

    protected void togglePasswordVisible() {
        boolean visible = !this.m_passwordField.isPasswordVisible();
        this.m_showPasswordButton.setIcon((Resource)(visible ? FontAwesome.EYE : FontAwesome.EYE_SLASH));
        this.m_passwordField.setPasswordVisible(visible);
    }

    void displayError(String messageHTML) {
        this.m_error.setValue(messageHTML);
        this.m_error.setVisible(true);
        CmsVaadinUtils.waggleMeOnce((Component)this.m_fakeWindow);
    }
}

