/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsAcceptLanguageHeaderParser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspLoginBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;

public class CmsLoginHelper
extends CmsJspLoginBean {
    public static final int ACTION_DISPLAY = 0;
    public static final int ACTION_LOGIN = 1;
    public static final int ACTION_LOGOUT = 2;
    public static final String PARAM_ACTION_GETOULIST = "getoulist";
    public static final String PARAM_ACTION_LOGIN = "login";
    public static final String PARAM_ACTION_LOGOUT = "logout";
    public static final String PARAM_AUTHTOKEN = "at";
    public static final String PARAM_FORM = "ocLoginForm";
    public static final String PARAM_OUFQN = "ocOuFqn";
    public static final String PARAM_OUSEARCH = "ocOuSearch";
    public static final String PARAM_PASSWORD = "ocPword";
    public static final String PARAM_PCTYPE = "ocPcType";
    public static final String PARAM_PREDEF_OUFQN = "ocPredefOuFqn";
    public static final String PARAM_USERNAME = "ocUname";
    public static final String PARAM_RESET_PASSWORD = "reset";
    public static final String PARAM_WPDATA = "ocWpData";
    public static final String PCTYPE_PRIVATE = "private";
    public static final String PCTYPE_PUBLIC = "public";
    private static final String COOKIE_OUFQN = "OpenCmsOuFqn";
    private static final String COOKIE_PCTYPE = "OpenCmsPcType";
    private static final String COOKIE_USERNAME = "OpenCmsUserName";
    private static final Log LOG = CmsLog.getLog(CmsLoginHelper.class);

    public static String getCopyrightHtml(Locale locale) {
        StringBuffer html = new StringBuffer();
        html.append("<div style=\"text-align: center; font-size: 10px; white-space: nowrap;\">");
        html.append("<a href=\"http://www.opencms.org\" target=\"_blank\">OpenCms</a> ");
        html.append(Messages.get().getBundle(locale).key("GUI_LOGIN_OPENCMS_IS_FREE_SOFTWARE_0"));
        html.append("</div>\n");
        html.append("<div style=\"text-align: center; font-size: 10px; white-space: nowrap;\">");
        html.append(Messages.get().getBundle(locale).key("GUI_LOGIN_TRADEMARKS_0"));
        html.append("</div>\n");
        html.append("<div style=\"text-align: center; font-size: 10px; white-space: nowrap;\">");
        html.append("&copy; 2002 - 2024 Alkacon Software GmbH &amp; Co. KG. ");
        html.append(Messages.get().getBundle(locale).key("GUI_LOGIN_RIGHTS_RESERVED_0"));
        html.append("</div>\n");
        return html.toString();
    }

    public static String getDirectEditPath(CmsObject cms, CmsUserSettings userSettings, boolean forceDirectEdit) {
        if (forceDirectEdit || userSettings.getStartView().equals("/system/workplace/views/explorer/directEdit.jsp") | userSettings.getStartView().equals("pageeditor")) {
            try {
                CmsResource targetRes;
                String folder;
                CmsObject cloneCms = OpenCms.initCmsObject(cms);
                String startSite = CmsWorkplace.getStartSiteRoot(cloneCms, userSettings);
                cloneCms.getRequestContext().setSiteRoot(startSite);
                String projectName = userSettings.getStartProject();
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(projectName)) {
                    cloneCms.getRequestContext().setCurrentProject(cloneCms.readProject(projectName));
                }
                if (!cloneCms.existsResource(folder = userSettings.getStartFolder())) {
                    folder = "/";
                }
                if ((targetRes = cloneCms.readDefaultFile(folder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) != null) {
                    return cloneCms.getSitePath(targetRes);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static LoginParameters getLoginParameters(CmsObject cms, HttpServletRequest request, boolean workplaceUiRequest) {
        String authToken = request.getParameter(PARAM_AUTHTOKEN);
        String actionLogout = CmsRequestUtil.getNotEmptyParameter(request, PARAM_ACTION_LOGOUT);
        boolean logout = Boolean.valueOf(actionLogout);
        String oufqn = request.getParameter(PARAM_OUFQN);
        if (oufqn == null) {
            oufqn = CmsLoginHelper.getPreDefOuFqn(cms, request, logout);
        }
        String pcType = CmsLoginHelper.getPcType(request);
        String username = CmsRequestUtil.getNotEmptyParameter(request, PARAM_USERNAME);
        if (username != null) {
            username = username.trim();
        }
        if (pcType == null || PCTYPE_PRIVATE.equals(pcType)) {
            Cookie ouFqnCookie;
            Cookie userNameCookie = CmsLoginHelper.getCookie(request, COOKIE_USERNAME);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userNameCookie.getValue()) && !"null".equals(userNameCookie.getValue())) {
                if (username == null) {
                    username = userNameCookie.getValue();
                }
                if (pcType == null) {
                    pcType = PCTYPE_PRIVATE;
                }
            }
            if (oufqn == null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((ouFqnCookie = CmsLoginHelper.getCookie(request, COOKIE_OUFQN)).getValue()) && !"null".equals(ouFqnCookie.getValue())) {
                oufqn = ouFqnCookie.getValue();
            }
        }
        String requestedResource = CmsRequestUtil.getNotEmptyParameter(request, "requestedResource");
        boolean validRequestedResource = false;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(requestedResource)) {
            String encryptedRequestedResource = request.getParameter("encryptedRequestedResource");
            try {
                String decryptedResource = OpenCms.getDefaultTextEncryption().decrypt(encryptedRequestedResource);
                if (requestedResource.equals(decryptedResource)) {
                    validRequestedResource = true;
                }
            }
            catch (CmsEncryptionException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (!validRequestedResource) {
                requestedResource = null;
            }
        }
        Locale locale = CmsLoginHelper.getLocaleForRequest(request);
        String resetStr = request.getParameter(PARAM_RESET_PASSWORD);
        boolean reset = resetStr != null;
        return new LoginParameters(username, pcType, oufqn, requestedResource, locale, authToken, logout, reset);
    }

    public static List<CmsOrganizationalUnit> getOrgUnitsForLoginDialog(CmsObject cms, String predefOu) {
        ArrayList<CmsOrganizationalUnit> result = new ArrayList<CmsOrganizationalUnit>();
        try {
            if (predefOu == null) {
                result.add(OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, ""));
                result.addAll(OpenCms.getOrgUnitManager().getOrganizationalUnits(cms, "", true));
                Iterator itOus = result.iterator();
                while (itOus.hasNext()) {
                    CmsOrganizationalUnit ou = (CmsOrganizationalUnit)itOus.next();
                    if (!ou.hasFlagHideLogin() && !ou.hasFlagWebuser()) continue;
                    itOus.remove();
                }
            } else {
                result.add(OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, predefOu));
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public static String getStartView(CmsObject cms) {
        CmsUserSettings settings = new CmsUserSettings(cms);
        String targetView = CmsLoginHelper.getDirectEditPath(cms, settings, false);
        if (targetView == null) {
            if (settings.getStartView().startsWith("/")) {
                if ("/system/workplace/views/explorer/explorer_fs.jsp".equals(settings.getStartView())) {
                    targetView = "#explorer";
                } else if ("/system/workplace/views/admin/admin-fs.jsp".equals(settings.getStartView())) {
                    targetView = "#launchpad";
                }
            } else {
                targetView = "#" + settings.getStartView();
            }
        }
        return targetView;
    }

    public static String getTitle(Locale locale) {
        return Messages.get().getBundle(locale).key("GUI_LOGIN_TITLE_0");
    }

    public static CmsWorkplaceSettings initSiteAndProject(CmsObject cms) {
        CmsWorkplaceSettings workplaceSettings = CmsWorkplace.initWorkplaceSettings(cms, null, false);
        String startSite = CmsWorkplace.getStartSiteRoot(cms, workplaceSettings);
        workplaceSettings.setSite(startSite);
        cms.getRequestContext().setSiteRoot(startSite);
        CmsUserSettings settings = workplaceSettings.getUserSettings();
        try {
            CmsProject project = cms.readProject(settings.getStartProject());
            if (OpenCms.getOrgUnitManager().getAllAccessibleProjects(cms, project.getOuFqn(), false).contains(project)) {
                workplaceSettings.setProject(project.getUuid());
                cms.getRequestContext().setCurrentProject(project);
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_LOGIN_NO_STARTUP_PROJECT_2", cms.getRequestContext().getCurrentUser().getName(), settings.getStartProject()), (Throwable)e);
        }
        return workplaceSettings;
    }

    public static void setCookieData(String pcType, String username, String oufqn, HttpServletRequest request, HttpServletResponse response) {
        Cookie userNameCookie;
        if (CmsStringUtil.isEmpty(oufqn)) {
            oufqn = "/";
        }
        if (OpenCms.getLoginManager().isEnableSecurity() && CmsStringUtil.isNotEmpty(pcType)) {
            Cookie pcTypeCookie = CmsLoginHelper.getCookie(request, COOKIE_PCTYPE);
            pcTypeCookie.setValue(pcType);
            CmsLoginHelper.setCookie(pcTypeCookie, false, request, response);
        }
        if (PCTYPE_PRIVATE.equals(pcType)) {
            userNameCookie = CmsLoginHelper.getCookie(request, COOKIE_USERNAME);
            userNameCookie.setValue(username);
            CmsLoginHelper.setCookie(userNameCookie, false, request, response);
            Cookie ouFqnCookie = CmsLoginHelper.getCookie(request, COOKIE_OUFQN);
            ouFqnCookie.setValue(oufqn);
            CmsLoginHelper.setCookie(ouFqnCookie, false, request, response);
        } else if (OpenCms.getLoginManager().isEnableSecurity() && PCTYPE_PUBLIC.equals(pcType)) {
            userNameCookie = CmsLoginHelper.getCookie(request, COOKIE_USERNAME);
            CmsLoginHelper.setCookie(userNameCookie, true, request, response);
            Cookie ouFqnCookie = CmsLoginHelper.getCookie(request, COOKIE_OUFQN);
            CmsLoginHelper.setCookie(ouFqnCookie, true, request, response);
        }
    }

    public static CmsMessageContainer validateUserAndPasswordNotEmpty(String username, String password) {
        boolean userEmpty = CmsStringUtil.isEmpty(username);
        boolean passwordEmpty = CmsStringUtil.isEmpty(password);
        if (userEmpty && passwordEmpty) {
            return Messages.get().container("GUI_LOGIN_NO_DATA_0");
        }
        if (userEmpty) {
            return Messages.get().container("GUI_LOGIN_NO_NAME_0");
        }
        if (passwordEmpty) {
            return Messages.get().container("GUI_LOGIN_NO_PASSWORD_0");
        }
        return null;
    }

    protected static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i];
        }
        return new Cookie(name, "");
    }

    protected static void setCookie(Cookie cookie, boolean delete, HttpServletRequest request, HttpServletResponse response) {
        if (request.getAttribute(PARAM_PREDEF_OUFQN) != null) {
            return;
        }
        int maxAge = 0;
        if (!delete) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(2, 6);
            maxAge = (int)((cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L);
        }
        cookie.setMaxAge(maxAge);
        cookie.setPath(CmsStringUtil.joinPaths(OpenCms.getStaticExportManager().getVfsPrefix(), "/system/login"));
        response.addCookie(cookie);
    }

    private static Locale getLocaleForRequest(HttpServletRequest req) {
        CmsAcceptLanguageHeaderParser parser = new CmsAcceptLanguageHeaderParser(req, OpenCms.getWorkplaceManager().getDefaultLocale());
        List<Locale> acceptedLocales = parser.getAcceptedLocales();
        List<Locale> workplaceLocales = OpenCms.getWorkplaceManager().getLocales();
        Locale locale = OpenCms.getLocaleManager().getFirstMatchingLocale(acceptedLocales, workplaceLocales);
        if (locale == null) {
            locale = OpenCms.getWorkplaceManager().getDefaultLocale();
        }
        return locale;
    }

    private static String getPcType(HttpServletRequest request) {
        String pcType = null;
        if (!OpenCms.getLoginManager().isEnableSecurity()) {
            pcType = PCTYPE_PRIVATE;
        } else {
            Cookie pcTypeCookie;
            pcType = CmsRequestUtil.getNotEmptyParameter(request, PARAM_PCTYPE);
            if (pcType == null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((pcTypeCookie = CmsLoginHelper.getCookie(request, COOKIE_PCTYPE)).getValue()) && !"null".equals(pcTypeCookie.getValue())) {
                pcType = pcTypeCookie.getValue();
            }
        }
        return pcType;
    }

    private static String getPreDefOuFqn(CmsObject cms, HttpServletRequest request, boolean logout) {
        if (logout && request.getAttribute(PARAM_PREDEF_OUFQN) == null) {
            String oufqn = cms.getRequestContext().getOuFqn();
            if (!oufqn.startsWith("/")) {
                oufqn = "/" + oufqn;
            }
            request.setAttribute(PARAM_PREDEF_OUFQN, (Object)oufqn);
        }
        return (String)request.getAttribute(PARAM_PREDEF_OUFQN);
    }

    public static class LoginParameters
    implements Serializable {
        private static final long serialVersionUID = -2636377967076796207L;
        private String m_authToken;
        private Locale m_locale;
        private boolean m_logout;
        private String m_oufqn;
        private String m_pcType;
        private String m_requestedResource;
        private String m_username;
        private boolean m_reset;

        public LoginParameters(String username, String pcType, String oufqn, String requestedResource, Locale locale, String authToken, boolean logout, boolean reset) {
            this.m_username = username;
            this.m_pcType = pcType;
            this.m_oufqn = oufqn;
            this.m_requestedResource = requestedResource;
            this.m_locale = locale;
            this.m_authToken = authToken;
            this.m_logout = logout;
            this.m_reset = reset;
        }

        public String getAuthToken() {
            return this.m_authToken;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public String getOufqn() {
            return this.m_oufqn;
        }

        public String getPcType() {
            return this.m_pcType;
        }

        public String getRequestedResource() {
            return this.m_requestedResource;
        }

        public String getUsername() {
            return this.m_username;
        }

        public boolean isLogout() {
            return this.m_logout;
        }

        public boolean isPrivatePc() {
            return this.m_pcType == null || this.m_pcType.equals(CmsLoginHelper.PCTYPE_PRIVATE);
        }

        public boolean isReset() {
            return this.m_reset;
        }
    }
}

