/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.event.ShortcutListener;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.UserError;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.twofactor.CmsSecondFactorInfo;
import org.opencms.security.twofactor.CmsSecondFactorSetupInfo;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.user.CmsAccountsApp;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.login.CmsLoginController;
import org.opencms.ui.login.CmsSecondFactorDialog;

public class CmsSecondFactorSetupDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsSecondFactorSetupDialog.class);
    private static final long serialVersionUID = 1L;
    private CmsLoginController.LoginContext m_context;
    private CmsLoginController.LoginContinuation m_continuation;
    private Label m_description;
    private Button m_okButton;
    private Image m_qrCodeImage;
    private String m_secret;
    private Label m_secretLabel;
    private TextField m_verification;

    public CmsSecondFactorSetupDialog(CmsLoginController.LoginContext context, CmsLoginController.LoginContinuation continuation) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), new HashMap<String, String>());
        CmsResourceInfo userInfo = CmsAccountsApp.getPrincipalInfo(context.getUser());
        userInfo.setTopLineText(context.getUser().getFullName());
        this.displayResourceInfoDirectly(Collections.singletonList(userInfo));
        this.setWidth("800px");
        this.m_context = context;
        this.m_continuation = continuation;
        CmsSecondFactorSetupInfo info = OpenCms.getTwoFactorAuthenticationHandler().generateSetupInfo(context.getUser());
        Locale locale = A_CmsUI.get().getLocale();
        String specialDescription = OpenCms.getTwoFactorAuthenticationHandler().getSetupMessage(locale);
        if (specialDescription != null) {
            this.m_description.setValue(specialDescription);
        }
        this.m_qrCodeImage.setSource((Resource)new ExternalResource(info.getQrCodeImageUrl()));
        this.m_secret = info.getSecret();
        this.m_secretLabel.setValue(info.getSecret());
        this.m_okButton.addClickListener((Button.ClickListener & Serializable)event -> this.submit());
        this.m_verification.addStyleName("o-verification-code-field");
        this.m_verification.addShortcutListener(new ShortcutListener(null, 13, null){
            private static final long serialVersionUID = 1L;

            public void handleAction(Object sender, Object target) {
                CmsSecondFactorSetupDialog.this.submit();
            }
        });
        this.addAttachListener((ClientConnector.AttachListener & Serializable)event -> {
            this.m_verification.focus();
            CmsSecondFactorDialog.initVerificationField();
        });
    }

    protected void submit() {
        this.m_verification.setComponentError(null);
        String verificationCode = this.m_verification.getValue().trim();
        CmsSecondFactorInfo secondFactorInfo = new CmsSecondFactorInfo(this.m_secret, verificationCode);
        if (!OpenCms.getTwoFactorAuthenticationHandler().verifySecondFactorSetup(secondFactorInfo)) {
            String message = CmsVaadinUtils.getMessageText("GUI_LOGIN_2FA_SETUP_INVALID_CODE_0", new Object[0]);
            this.m_verification.setComponentError((ErrorMessage)new UserError(message));
            return;
        }
        this.m_context.setSecondFactorInfo(secondFactorInfo);
        CmsVaadinUtils.closeWindow((Component)this);
        try {
            this.m_continuation.continueLogin(this.m_context);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

