/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.vaadin.event.LayoutEvents;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.gwt.CmsCoreService;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.FontOpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.CmsResourceInfoAction;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.contextmenu.CmsContextMenu;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.I_CmsSimpleContextMenuEntry;
import org.opencms.ui.sitemap.CmsCopyPageDialog;
import org.opencms.ui.sitemap.CmsLocaleLinkTargetSelectionDialog;
import org.opencms.ui.sitemap.CmsSitemapTreeDataProvider;
import org.opencms.ui.sitemap.CmsSitemapTreeNode;
import org.opencms.ui.sitemap.CmsSitemapTreeNodeData;
import org.opencms.ui.sitemap.CmsSitemapUI;
import org.opencms.ui.sitemap.CmsUnlinkDialog;
import org.opencms.ui.sitemap.I_CmsLocaleCompareContext;
import org.opencms.util.CmsUUID;

public class CmsSitemapTreeController {
    public static final int RHS_WIDTH = 420;
    private static final Log LOG = CmsLog.getLog(CmsSitemapTreeController.class);
    CmsContextMenu m_menu = new CmsContextMenu();
    Window m_window;
    private IdentityHashMap<CmsSitemapTreeNode, Void> m_alreadyLoaded = new IdentityHashMap();
    private CmsSitemapTreeNode m_currentRootNode;
    private I_CmsLocaleCompareContext m_localeContext;
    private CmsResource m_root;
    private CmsSitemapTreeDataProvider m_treeDataProvider;

    public CmsSitemapTreeController(CmsObject cms, CmsResource root, I_CmsLocaleCompareContext context, Component parent) {
        this.m_treeDataProvider = new CmsSitemapTreeDataProvider(cms, root, context);
        this.m_localeContext = context;
        this.m_root = root;
        this.m_menu.extend((AbstractClientConnector)((AbstractComponent)parent));
    }

    public static CmsMenuItemVisibilityMode activeIfTrue(boolean condition) {
        return condition ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INACTIVE;
    }

    public static CmsMenuItemVisibilityMode visibleIfTrue(boolean condition) {
        return condition ? CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE : CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    public CmsSitemapTreeNode createNode(final CmsSitemapTreeNodeData entry) {
        final CmsSitemapTreeNode node = new CmsSitemapTreeNode();
        node.addLayoutClickListener(new LayoutEvents.LayoutClickListener(){
            private static final long serialVersionUID = 1L;

            public void layoutClick(LayoutEvents.LayoutClickEvent event) {
                Component currentComponent = event.getClickedComponent();
                if (currentComponent != null) {
                    boolean linked = false;
                    do {
                        if ((currentComponent = currentComponent.getParent()) != null && "linked".equals(((AbstractComponent)currentComponent).getData())) {
                            linked = true;
                        }
                        if (!(event.getClickedComponent() instanceof CmsResourceIcon)) continue;
                        if (currentComponent == node) {
                            CmsSitemapTreeController.this.openTargetPage((CmsSitemapTreeNodeData)node.getData(), linked);
                            continue;
                        }
                        if (currentComponent instanceof CmsSitemapTreeNode) break;
                    } while (currentComponent != null);
                }
            }
        });
        Resource icon = CmsResourceIcon.getSitemapResourceIcon(A_CmsUI.getCmsObject(), entry.getResource(), CmsResourceIcon.IconMode.localeCompare);
        CmsResourceInfo info = new CmsResourceInfo(entry.getClientEntry().getTitle(), entry.getClientEntry().getSitePath(), icon);
        info = CmsResourceInfo.createSitemapResourceInfo(entry.getResource(), OpenCms.getSiteManager().getSiteForRootPath(this.m_localeContext.getRoot().getRootPath()));
        info.getResourceIcon().addStyleName("o-pointer");
        info.getResourceIcon().setDescription(CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_OPEN_PAGE_0", new Object[0]));
        if (entry.getClientEntry().isHiddenNavigationEntry()) {
            info.addStyleName("o-resourceinfo-weak");
        }
        final MenuBar menu = new MenuBar();
        boolean noTranslation = false;
        noTranslation = entry.isMarkedNoTranslation(this.m_localeContext.getComparisonLocale());
        MenuBar.MenuItem main = menu.addItem("", null);
        main.setIcon((Resource)FontOpenCms.CONTEXT_MENU);
        CssLayout rightSide = new CssLayout();
        info.setButtonWidget((Component)rightSide);
        rightSide.addComponent((Component)menu);
        main.setCommand(new MenuBar.Command(){
            private static final long serialVersionUID = 1L;

            public void menuSelected(MenuBar.MenuItem selectedItem) {
                List entries = Arrays.asList(new EntryOpen(), new EntryExplorer(), new EntryProperties(), new EntryLink(), new EntryUnlink(), new EntryMark(), new EntryRemoveMark(), new EntryCopy(), new EntryInfo());
                MenuContext context = new MenuContext(entry, node);
                CmsSitemapTreeController.this.m_menu.setEntries(entries, context);
                CmsSitemapTreeController.this.m_menu.open((Component)menu);
            }
        });
        menu.addStyleName("borderless o-toolbar-button o-resourceinfo-toolbar");
        if (entry.isLinked()) {
            CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(this.m_localeContext.getRoot().getRootPath());
            CmsResourceInfo linkedInfo = CmsResourceInfo.createSitemapResourceInfo(this.readSitemapEntryFolderIfPossible(entry.getLinkedResource()), site);
            linkedInfo.addStyleName("o-resourceinfo-directlink");
            rightSide.addComponent((Component)linkedInfo, 0);
            linkedInfo.setWidth("420px");
            node.setContent((Component)info);
            linkedInfo.setData("linked");
            linkedInfo.getResourceIcon().setDescription(CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_OPEN_PAGE_0", new Object[0]));
            linkedInfo.getResourceIcon().addStyleName("o-pointer");
        } else {
            if (noTranslation) {
                CmsResourceInfo noTranslationInfo = new CmsResourceInfo();
                String topMessage = CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_NO_TRANSLATION_TOP_0", new Object[0]);
                String bottomMessage = CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_NO_TRANSLATION_BOTTOM_0", new Object[0]);
                noTranslationInfo.getTopLine().setValue(topMessage);
                noTranslationInfo.getBottomLine().setValue(bottomMessage);
                noTranslationInfo.getResourceIcon().setValue("<span class=\"o-resource-icon o-notranslation\">" + FontAwesome.BAN.getHtml() + "</span>");
                noTranslationInfo.addStyleName("o-resourceinfo-directlink");
                noTranslationInfo.setWidth("420px");
                rightSide.addComponent((Component)noTranslationInfo, 0);
            }
            node.setContent((Component)info);
        }
        if (entry.hasNoChildren()) {
            node.setOpen(true);
            node.setOpenerVisible(false);
        }
        node.setData(entry);
        return node;
    }

    public CmsSitemapTreeNode createRootNode() {
        this.m_currentRootNode = this.createNode(this.m_treeDataProvider.getRoot());
        return this.m_currentRootNode;
    }

    public CmsResource getRoot() {
        return this.m_root;
    }

    public void initEventHandlers(final CmsSitemapTreeNode node) {
        node.getOpener().addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsSitemapTreeController.this.onClickOpen(node);
            }
        });
    }

    public void onClickOpen(CmsSitemapTreeNode node) {
        if (node.isOpen()) {
            node.setOpen(false);
        } else {
            if (!this.m_alreadyLoaded.containsKey((Object)node)) {
                Object nodeData = node.getData();
                List<CmsSitemapTreeNodeData> children = this.m_treeDataProvider.getChildren((CmsSitemapTreeNodeData)nodeData);
                this.m_alreadyLoaded.put(node, null);
                if (children.isEmpty()) {
                    node.setOpenerVisible(false);
                } else {
                    for (CmsSitemapTreeNodeData child : children) {
                        CmsSitemapTreeNode childNode = this.createNode(child);
                        childNode.setData(child);
                        this.initEventHandlers(childNode);
                        node.getChildren().addComponent((Component)childNode);
                    }
                }
            }
            node.setOpen(true);
        }
    }

    public void openPageCopyDialog(CmsSitemapTreeNode node, CmsSitemapTreeNodeData entry) {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            CmsResource resource = cms.readResource(entry.getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION);
            DialogContext context = new DialogContext(resource, node);
            CmsCopyPageDialog dialog = new CmsCopyPageDialog(context);
            String title = CmsVaadinUtils.getMessageText("GUI_COPYPAGE_DIALOG_TITLE_0", new Object[0]);
            context.start(title, (Component)dialog);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            CmsErrorDialog.showErrorDialog(e);
        }
    }

    public void updateNode(CmsSitemapTreeNode node) {
        CmsSitemapTreeNodeData data = (CmsSitemapTreeNodeData)node.getData();
        try {
            CmsSitemapTreeNodeData changedData = this.m_treeDataProvider.getData(A_CmsUI.getCmsObject().readResource(data.getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION));
            CmsSitemapTreeNode changedNode = this.createNode(changedData);
            this.initEventHandlers(changedNode);
            ComponentContainer parent = (ComponentContainer)node.getParent();
            parent.replaceComponent((Component)node, (Component)changedNode);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void updateNodeForId(final CmsUUID id) {
        final ArrayList nodes = Lists.newArrayList();
        CmsVaadinUtils.visitDescendants((Component)this.m_currentRootNode, new Predicate<Component>(){

            public boolean apply(Component input) {
                CmsSitemapTreeNode node;
                CmsSitemapTreeNodeData data;
                if (input instanceof CmsSitemapTreeNode && (data = (CmsSitemapTreeNodeData)(node = (CmsSitemapTreeNode)input).getData()).getResource().getStructureId().equals(id)) {
                    nodes.add(node);
                    return false;
                }
                return true;
            }
        });
        if (nodes.size() == 1) {
            this.updateNode((CmsSitemapTreeNode)((Object)nodes.get(0)));
        }
    }

    protected CmsResource readSitemapEntryFolderIfPossible(CmsResource resource) {
        CmsObject cms = A_CmsUI.getCmsObject();
        try {
            if (resource.isFolder()) {
                return resource;
            }
            CmsResource parent = cms.readParentFolder(resource.getStructureId());
            CmsResource defaultFile = cms.readDefaultFile(parent, CmsResourceFilter.IGNORE_EXPIRATION);
            if (defaultFile != null && defaultFile.equals(resource)) {
                return parent;
            }
            return resource;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return resource;
        }
    }

    Log getTreeControllerLog() {
        return LOG;
    }

    private void openTargetPage(CmsSitemapTreeNodeData nodeData, boolean second) {
        CmsUUID id = nodeData.getClientEntry().getId();
        CmsUUID defaultFileId = nodeData.getClientEntry().getDefaultFileId();
        CmsUUID targetId = defaultFileId;
        if (targetId == null) {
            targetId = id;
        }
        try {
            String mySiteRoot;
            boolean sameSite;
            CmsResource resource = A_CmsUI.getCmsObject().readResource(targetId, CmsResourceFilter.IGNORE_EXPIRATION);
            String link = OpenCms.getLinkManager().substituteLink(A_CmsUI.getCmsObject(), resource);
            if (second) {
                resource = A_CmsUI.getCmsObject().readResource(nodeData.getLinkedResource().getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                link = OpenCms.getLinkManager().substituteLink(A_CmsUI.getCmsObject(), resource);
            }
            if (sameSite = (mySiteRoot = A_CmsUI.getCmsObject().getRequestContext().getSiteRoot()).equals(OpenCms.getSiteManager().getSiteRoot(resource.getRootPath()))) {
                A_CmsUI.get().getPage().setLocation(link);
            } else {
                String message = CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_SHOW_WRONGSITE_1", resource.getRootPath());
                Notification.show((String)message, (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public class DialogContext
    implements I_CmsDialogContext {
        private CmsSitemapTreeNode m_node;
        private CmsResource m_resource;

        public DialogContext(CmsResource resource, CmsSitemapTreeNode node) {
            this.m_resource = resource;
            this.m_node = node;
        }

        public void closeWindow() {
            if (CmsSitemapTreeController.this.m_window != null) {
                CmsSitemapTreeController.this.m_window.close();
                CmsSitemapTreeController.this.m_window = null;
            }
        }

        @Override
        public void error(Throwable error) {
            CmsSitemapTreeController.this.getTreeControllerLog().error((Object)error.getLocalizedMessage(), error);
            CmsErrorDialog.showErrorDialog(error);
        }

        @Override
        public void finish(CmsProject project, String siteRoot) {
            this.closeWindow();
        }

        @Override
        public void finish(Collection<CmsUUID> result) {
            this.closeWindow();
            if (result.isEmpty()) {
                return;
            }
            if (this.m_node != null) {
                if (this.m_node == CmsSitemapTreeController.this.m_currentRootNode) {
                    CmsSitemapTreeController.this.m_localeContext.refreshAll();
                } else {
                    CmsSitemapTreeController.this.updateNode(this.m_node);
                }
            }
        }

        @Override
        public void focus(CmsUUID structureId) {
        }

        @Override
        public List<CmsUUID> getAllStructureIdsInView() {
            return null;
        }

        @Override
        public String getAppId() {
            return "sitemapeditor";
        }

        @Override
        public CmsObject getCms() {
            return A_CmsUI.getCmsObject();
        }

        @Override
        public I_CmsDialogContext.ContextType getContextType() {
            return null;
        }

        @Override
        public List<CmsResource> getResources() {
            return Arrays.asList(this.m_resource);
        }

        @Override
        public void navigateTo(String appId) {
        }

        @Override
        public void onViewChange() {
        }

        @Override
        public void reload() {
        }

        @Override
        public void setWindow(Window window) {
            CmsSitemapTreeController.this.m_window = window;
        }

        @Override
        public void start(String title, Component dialog) {
            this.start(title, dialog, CmsBasicDialog.DialogWidth.narrow);
        }

        @Override
        public void start(String title, Component dialog, CmsBasicDialog.DialogWidth width) {
            if (dialog != null) {
                CmsSitemapTreeController.this.m_window = CmsBasicDialog.prepareWindow(width);
                CmsSitemapTreeController.this.m_window.setCaption(title);
                CmsSitemapTreeController.this.m_window.setContent(dialog);
                UI.getCurrent().addWindow(CmsSitemapTreeController.this.m_window);
                if (dialog instanceof CmsBasicDialog) {
                    ((CmsBasicDialog)dialog).initActionHandler(CmsSitemapTreeController.this.m_window);
                }
            }
        }

        @Override
        public void updateUserInfo() {
        }
    }

    class MenuContext {
        private CmsSitemapTreeNodeData m_data;
        private CmsSitemapTreeNode m_node;

        public MenuContext(CmsSitemapTreeNodeData data, CmsSitemapTreeNode node) {
            this.m_node = node;
            this.m_data = data;
        }

        public CmsSitemapTreeNodeData getData() {
            return this.m_data;
        }

        public CmsSitemapTreeNode getNode() {
            return this.m_node;
        }

        public boolean isMainLocale() {
            return CmsSitemapTreeController.this.m_localeContext.getRootLocale().equals(A_CmsUI.getCmsObject().getLocaleGroupService().getMainLocale(CmsSitemapTreeController.this.m_localeContext.getRoot().getRootPath()));
        }
    }

    class EntryUnlink
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryUnlink() {
        }

        @Override
        public void executeAction(MenuContext context) {
            try {
                CmsResource secondary = context.getData().getLinkedResource();
                DialogContext dialogContext = new DialogContext(A_CmsUI.getCmsObject().readResource(context.getData().getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION), context.getNode());
                CmsUnlinkDialog dialog = new CmsUnlinkDialog(dialogContext, secondary);
                dialogContext.start(CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_UNLINK_LOCALE_VARIANT_0", new Object[0]), (Component)dialog, CmsBasicDialog.DialogWidth.wide);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                CmsErrorDialog.showErrorDialog(e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_UNLINK_LOCALE_VARIANT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            if (!context.getData().isLinked()) {
                return CmsSitemapTreeController.visibleIfTrue(false);
            }
            try {
                CmsResource defaultFile;
                CmsResource primary = A_CmsUI.getCmsObject().readResource(context.getData().getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION);
                if (primary.isFolder() && (defaultFile = A_CmsUI.getCmsObject().readDefaultFile(primary, CmsResourceFilter.IGNORE_EXPIRATION)) != null) {
                    primary = defaultFile;
                }
                CmsLocaleGroupService groupService = A_CmsUI.getCmsObject().getLocaleGroupService();
                Locale mainLocale = groupService.getMainLocale(CmsSitemapTreeController.this.m_localeContext.getRoot().getRootPath());
                int mainLocaleCount = 0;
                for (Locale testLocale : Arrays.asList(CmsSitemapTreeController.this.m_localeContext.getRootLocale(), CmsSitemapTreeController.this.m_localeContext.getComparisonLocale())) {
                    mainLocaleCount += mainLocale.equals(testLocale) ? 1 : 0;
                }
                return CmsSitemapTreeController.visibleIfTrue(mainLocaleCount == 1);
            }
            catch (Exception e) {
                return CmsSitemapTreeController.visibleIfTrue(false);
            }
        }
    }

    class EntryRemoveMark
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryRemoveMark() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void executeAction(MenuContext context) {
            List<Locale> currentLocales;
            CmsResource primaryFinal;
            CmsResource defaultFile;
            CmsSitemapTreeNodeData entry = context.getData();
            CmsSitemapTreeNode node = context.getNode();
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsLockActionRecord actionRecord = null;
            CmsResource fileToModify2 = null;
            CmsResource primary = A_CmsUI.getCmsObject().readResource(entry.getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION);
            if (primary.isFolder() && (defaultFile = A_CmsUI.getCmsObject().readDefaultFile(primary, CmsResourceFilter.IGNORE_EXPIRATION)) != null) {
                primary = defaultFile;
            }
            if ((fileToModify2 = (primaryFinal = primary)).isFolder()) {
                try {
                    fileToModify2 = A_CmsUI.getCmsObject().readDefaultFile(fileToModify2, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            actionRecord = CmsLockUtil.ensureLock(cms, fileToModify2);
            CmsSitemapTreeController.this.m_localeContext.getComparisonLocale().toString();
            CmsProperty prop = cms.readPropertyObject(fileToModify2, "locale.notranslation", false);
            String propValue = prop.getValue();
            if (propValue == null) {
                propValue = "";
            }
            if ((currentLocales = CmsLocaleManager.getLocales(propValue)).contains(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale())) {
                currentLocales.remove(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale());
                String newPropValue = Joiner.on((String)",").join(currentLocales);
                CmsProperty newProp = new CmsProperty("locale.notranslation", newPropValue, null);
                cms.writePropertyObjects(primaryFinal, Arrays.asList(newProp));
                DialogContext dialogContext = new DialogContext(A_CmsUI.getCmsObject().readResource(entry.getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION), node);
                dialogContext.finish(Arrays.asList(fileToModify2.getStructureId()));
            }
            if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) return;
            try {
                cms.unlockResource(fileToModify2);
                return;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                CmsErrorDialog.showErrorDialog(e);
            }
            return;
            catch (CmsException e) {
                try {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    CmsErrorDialog.showErrorDialog(e);
                    if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) return;
                }
                catch (Throwable throwable) {
                    if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) throw throwable;
                    try {
                        cms.unlockResource(fileToModify2);
                        throw throwable;
                    }
                    catch (CmsException e2) {
                        LOG.error((Object)e2.getLocalizedMessage(), (Throwable)e2);
                        CmsErrorDialog.showErrorDialog(e2);
                    }
                    throw throwable;
                }
                try {
                    cms.unlockResource(fileToModify2);
                    return;
                }
                catch (CmsException e3) {
                    LOG.error((Object)e3.getLocalizedMessage(), (Throwable)e3);
                    CmsErrorDialog.showErrorDialog(e3);
                }
                return;
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_REMOVE_DONT_TRANSLATE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            boolean result = context.isMainLocale() && context.getData().isMarkedNoTranslation(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale());
            return CmsSitemapTreeController.visibleIfTrue(result);
        }
    }

    class EntryProperties
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryProperties() {
        }

        @Override
        public void executeAction(MenuContext context) {
            ((CmsSitemapUI)A_CmsUI.get()).getSitemapExtension().openPropertyDialog(context.getData().getResource().getStructureId(), CmsSitemapTreeController.this.m_root.getStructureId());
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_PROPERTIES_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            return CmsSitemapTreeController.visibleIfTrue(true);
        }
    }

    class EntryOpen
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryOpen() {
        }

        @Override
        public void executeAction(MenuContext context) {
            CmsSitemapTreeController.this.openTargetPage((CmsSitemapTreeNodeData)context.getNode().getData(), false);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_OPEN_PAGE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext data) {
            return CmsSitemapTreeController.visibleIfTrue(true);
        }
    }

    class EntryMark
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryMark() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void executeAction(MenuContext context) {
            List<Locale> currentLocales;
            CmsResource primaryFinal;
            CmsResource defaultFile;
            CmsSitemapTreeNodeData entry = context.getData();
            CmsSitemapTreeNode node = context.getNode();
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsLockActionRecord actionRecord = null;
            CmsResource fileToModify2 = null;
            CmsResource primary = A_CmsUI.getCmsObject().readResource(entry.getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION);
            if (primary.isFolder() && (defaultFile = A_CmsUI.getCmsObject().readDefaultFile(primary, CmsResourceFilter.IGNORE_EXPIRATION)) != null) {
                primary = defaultFile;
            }
            if ((fileToModify2 = (primaryFinal = primary)).isFolder()) {
                try {
                    fileToModify2 = A_CmsUI.getCmsObject().readDefaultFile(fileToModify2, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            actionRecord = CmsLockUtil.ensureLock(cms, fileToModify2);
            CmsSitemapTreeController.this.m_localeContext.getComparisonLocale().toString();
            CmsProperty prop = cms.readPropertyObject(fileToModify2, "locale.notranslation", false);
            String propValue = prop.getValue();
            if (propValue == null) {
                propValue = "";
            }
            if (!(currentLocales = CmsLocaleManager.getLocales(propValue)).contains(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale())) {
                currentLocales.add(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale());
                String newPropValue = Joiner.on((String)",").join(currentLocales);
                CmsProperty newProp = new CmsProperty("locale.notranslation", newPropValue, null);
                cms.writePropertyObjects(fileToModify2, Arrays.asList(newProp));
                DialogContext dialogContext = new DialogContext(A_CmsUI.getCmsObject().readResource(entry.getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION), node);
                dialogContext.finish(Arrays.asList(fileToModify2.getStructureId()));
            }
            if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) return;
            try {
                cms.unlockResource(fileToModify2);
                return;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                CmsErrorDialog.showErrorDialog(e);
            }
            return;
            catch (CmsException e) {
                try {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    CmsErrorDialog.showErrorDialog(e);
                    if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) return;
                }
                catch (Throwable throwable) {
                    if (actionRecord == null || actionRecord.getChange() != CmsLockActionRecord.LockChange.locked) throw throwable;
                    try {
                        cms.unlockResource(fileToModify2);
                        throw throwable;
                    }
                    catch (CmsException e2) {
                        LOG.error((Object)e2.getLocalizedMessage(), (Throwable)e2);
                        CmsErrorDialog.showErrorDialog(e2);
                    }
                    throw throwable;
                }
                try {
                    cms.unlockResource(fileToModify2);
                    return;
                }
                catch (CmsException e3) {
                    LOG.error((Object)e3.getLocalizedMessage(), (Throwable)e3);
                    CmsErrorDialog.showErrorDialog(e3);
                }
                return;
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_ADD_DONT_TRANSLATE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            CmsSitemapTreeNodeData entry = context.getData();
            boolean result = context.isMainLocale() && !entry.isMarkedNoTranslation(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale()) && !entry.isLinked();
            return CmsSitemapTreeController.visibleIfTrue(result);
        }
    }

    class EntryLink
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryLink() {
        }

        @Override
        public void executeAction(MenuContext data) {
            try {
                DialogContext dialogContext = new DialogContext(A_CmsUI.getCmsObject().readResource(data.getData().getClientEntry().getId(), CmsResourceFilter.IGNORE_EXPIRATION), data.getNode());
                CmsLocaleLinkTargetSelectionDialog dialog = new CmsLocaleLinkTargetSelectionDialog(dialogContext, CmsSitemapTreeController.this.m_localeContext);
                dialogContext.start(CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_LINK_LOCALE_VARIANT_0", new Object[0]), (Component)dialog, CmsBasicDialog.DialogWidth.narrow);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                CmsErrorDialog.showErrorDialog(e);
            }
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_LINK_LOCALE_VARIANT_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            return CmsSitemapTreeController.activeIfTrue(!context.getData().isLinked() && !context.getData().isMarkedNoTranslation(CmsSitemapTreeController.this.m_localeContext.getComparisonLocale()));
        }
    }

    class EntryInfo
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryInfo() {
        }

        @Override
        public void executeAction(MenuContext context) {
            CmsResourceInfoAction infoAction = new CmsResourceInfoAction();
            infoAction.executeAction(new DialogContext(context.getData().getResource(), context.getNode()));
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_RESOURCE_INFO_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            return CmsSitemapTreeController.visibleIfTrue(true);
        }
    }

    class EntryExplorer
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryExplorer() {
        }

        @Override
        public void executeAction(MenuContext context) {
            String link = CmsCoreService.getVaadinWorkplaceLink(A_CmsUI.getCmsObject(), context.getData().getResource().getStructureId());
            A_CmsUI.get().getPage().setLocation(link);
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_EXPLORER_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            return CmsSitemapTreeController.visibleIfTrue(true);
        }
    }

    class EntryCopy
    implements I_CmsSimpleContextMenuEntry<MenuContext> {
        EntryCopy() {
        }

        @Override
        public void executeAction(MenuContext context) {
            CmsSitemapTreeController.this.openPageCopyDialog(context.getNode(), context.getData());
        }

        @Override
        public String getTitle(Locale locale) {
            return CmsVaadinUtils.getMessageText("GUI_LOCALECOMPARE_COPY_PAGE_0", new Object[0]);
        }

        @Override
        public CmsMenuItemVisibilityMode getVisibility(MenuContext context) {
            return CmsSitemapTreeController.visibleIfTrue(context.getData().isCopyable());
        }
    }
}

