/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class CmsParameterEscaper {
    public static final String DEFAULT_POLICY = "antisamy-opencms.xml";
    protected static Policy defaultPolicy;
    private static final Log LOG;
    private AntiSamy m_antiSamy;
    private Set<String> m_cleanHtml = new HashSet<String>();
    private String m_dummyValue;
    private Set<String> m_escapeInvalid = new HashSet<String>();
    private Set<String> m_exceptions = new HashSet<String>();

    public static Policy readPolicy(CmsObject cms, String sitePath) {
        try {
            CmsFile policyFile = cms.readFile(sitePath);
            ByteArrayInputStream input = new ByteArrayInputStream(policyFile.getContents());
            Policy policy = Policy.getInstance((InputStream)input);
            return policy;
        }
        catch (CmsException e) {
            LOG.error((Object)"Could not read Antisamy policy file");
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (PolicyException e) {
            LOG.error((Object)("Invalid Antisamy policy read from " + sitePath));
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public AntiSamy createAntiSamy(CmsObject cms, String policyPath) {
        String rootPath = cms.addSiteRoot(policyPath);
        Policy policy = null;
        if (policyPath != null) {
            Object cacheValue = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().getCachedObject(cms, rootPath);
            if (cacheValue == null) {
                policy = CmsParameterEscaper.readPolicy(cms, policyPath);
                if (policy != null) {
                    CmsVfsMemoryObjectCache.getVfsMemoryObjectCache().putCachedObject(cms, rootPath, policy);
                }
            } else {
                policy = (Policy)cacheValue;
            }
        }
        if (policy == null) {
            policy = defaultPolicy;
        }
        if (policy != null) {
            return new AntiSamy(policy);
        }
        return null;
    }

    public void enableAntiSamy(CmsObject cms, String policyPath, Set<String> params) {
        this.m_antiSamy = this.createAntiSamy(cms, policyPath);
        this.m_cleanHtml = params;
    }

    public String escape(String name, String value) {
        if (value == null) {
            return null;
        }
        if (this.m_exceptions.contains(name)) {
            return value;
        }
        LOG.info((Object)("Escaping parameter '" + name + "' with value '" + value + "'"));
        if (this.m_cleanHtml.contains(name)) {
            return this.filterAntiSamy(name, value);
        }
        return this.escapeSimple(name, value);
    }

    public String[] escape(String name, String[] values) {
        if (values == null) {
            return null;
        }
        if (this.m_exceptions.contains(name)) {
            return values;
        }
        boolean cleanHtml = this.m_cleanHtml.contains(name);
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = cleanHtml ? this.filterAntiSamy(name, values[i]) : this.escapeSimple(name, values[i]);
        }
        return result;
    }

    public String filterAntiSamy(String name, String html) {
        if (this.m_antiSamy == null) {
            LOG.warn((Object)"Antisamy policy invalid, using simple escaping as a fallback");
            return this.escapeSimple(name, html);
        }
        try {
            CleanResults results = this.m_antiSamy.scan(html);
            if (results.getNumberOfErrors() > 0) {
                LOG.info((Object)"Antisamy error messages:");
                for (Object message : results.getErrorMessages()) {
                    LOG.info(message);
                }
            }
            return results.getCleanHTML();
        }
        catch (PolicyException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return this.escapeSimple(name, html);
        }
        catch (ScanException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return this.escapeSimple(name, html);
        }
    }

    public void setDummyValue(String dummyValue) {
        this.m_dummyValue = dummyValue;
    }

    public void setEscapeInvalid(Collection<String> escapeInvalidList) {
        this.m_escapeInvalid = new HashSet<String>(escapeInvalidList);
    }

    public void setExceptions(Collection<String> exceptions) {
        this.m_exceptions = new HashSet<String>(exceptions);
    }

    protected String escapeSimple(String name, String value) {
        String result = CmsEncoder.escapeXml(value);
        if (this.m_dummyValue != null && !result.equals(value) && !this.m_escapeInvalid.contains(name)) {
            return name + "_" + this.m_dummyValue;
        }
        return result;
    }

    static {
        LOG = CmsLog.getLog(CmsParameterEscaper.class);
        try {
            Policy policy;
            String packageName = CmsParameterEscaper.class.getPackage().getName();
            String resourceName = packageName.replace(".", "/") + "/" + DEFAULT_POLICY;
            InputStream stream = CmsParameterEscaper.class.getClassLoader().getResourceAsStream(resourceName);
            defaultPolicy = policy = Policy.getInstance((InputStream)stream);
        }
        catch (PolicyException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

