/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.Serializable;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsPath
implements Serializable,
Comparable<CmsPath> {
    private static final long serialVersionUID = 1L;
    private String m_pathStr;

    public CmsPath(String pathStr) {
        if (pathStr.equals("") || pathStr.equals("/")) {
            this.m_pathStr = "/";
        } else {
            this.m_pathStr = CmsFileUtil.removeTrailingSeparator(pathStr);
            if (!this.m_pathStr.startsWith("/")) {
                this.m_pathStr = "/" + this.m_pathStr;
            }
        }
    }

    public String asString() {
        return this.m_pathStr;
    }

    @Override
    public int compareTo(CmsPath o) {
        return this.m_pathStr.compareTo(o.m_pathStr);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CmsPath)) {
            return false;
        }
        return ((CmsPath)obj).m_pathStr.equals(this.m_pathStr);
    }

    public int hashCode() {
        return this.m_pathStr.hashCode();
    }

    public boolean isPrefixOf(CmsPath path) {
        return this.isPrefixOfStr(path.asString());
    }

    public boolean isPrefixOfStr(String path) {
        return CmsStringUtil.isPrefixPath(this.m_pathStr, path);
    }

    public String toString() {
        return "CmsPath[" + this.asString() + "]";
    }
}

