/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsLocationPickerWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    private static final String DEFAULT_CONFIG = "{\"edit\":[\"map\", \"address\", \"coords\", \"size\", \"zoom\", \"type\", \"mode\"]}";
    private static final String DISABLED_POSTFIX = ".disabled";
    public static final String CONFIG_API_KEY = "apiKey";
    public static final String CONFIG_API_KEY_MESSAGE = "apiKeyMessage";
    private static final Log LOG = CmsLog.getLog(CmsLocationPickerWidget.class);

    public CmsLocationPickerWidget() {
        this("");
    }

    public CmsLocationPickerWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        String config = this.getConfiguration();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(config)) {
            config = DEFAULT_CONFIG;
        } else if (!config.startsWith("{")) {
            config = "{" + config + "}";
        }
        try {
            JSONObject conf = new JSONObject(config);
            String keyMessage = Messages.get().getBundle().key("LOG_API_KEY_FROM_CONFIG_0");
            String apiKey = conf.has(CONFIG_API_KEY) ? conf.getString(CONFIG_API_KEY) : "";
            String sitePath = null;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(apiKey)) {
                sitePath = resource.getStructureId().isNullUUID() ? "/" : cms.getSitePath(resource);
                try {
                    apiKey = cms.readPropertyObject(sitePath, "google.apikey.workplace", true).getValue();
                    keyMessage = Messages.get().getBundle().key("LOG_API_KEY_FROM_PROPERTY_1", "google.apikey.workplace");
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(apiKey)) {
                        apiKey = cms.readPropertyObject(sitePath, "google.apikey", true).getValue();
                        keyMessage = Messages.get().getBundle().key("LOG_API_KEY_FROM_PROPERTY_1", "google.apikey");
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(apiKey)) {
                apiKey = apiKey.trim();
                conf.put(CONFIG_API_KEY, apiKey);
                conf.put(CONFIG_API_KEY_MESSAGE, keyMessage);
                if (LOG.isDebugEnabled()) {
                    if (sitePath != null) {
                        keyMessage = keyMessage + Messages.get().getBundle().key("LOG_API_KEY_FOR_PATH_1", cms.getRequestContext().addSiteRoot(sitePath));
                    }
                    LOG.debug((Object)keyMessage);
                }
            }
            config = conf.toString();
        }
        catch (JSONException e) {
            config = DEFAULT_CONFIG;
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return config;
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.singleline;
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String value;
        String localizedValue = value = param.getStringValue(cms);
        if (CmsStringUtil.TRUE.equalsIgnoreCase(value) || CmsStringUtil.FALSE.equalsIgnoreCase(value)) {
            boolean booleanValue = Boolean.valueOf(value);
            localizedValue = booleanValue ? Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_LABEL_TRUE_0") : Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_LABEL_FALSE_0");
        }
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        result.append("<span class=\"xmlInput textInput\" style=\"border: 0px solid black;\">");
        if (CmsStringUtil.isNotEmpty(this.getConfiguration())) {
            result.append(this.getConfiguration());
        } else {
            result.append(localizedValue);
        }
        result.append("</span>");
        result.append("<input type=\"hidden\"");
        result.append(" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" value=\"");
        result.append(CmsEncoder.escapeXml(value));
        result.append("\">");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getHelpBubble(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(128);
        String locKey = this.getDisabledHelpKey(param);
        String locValue = widgetDialog.getMessages().key(locKey, true);
        if (locValue == null) {
            return widgetDialog.dialogHorizontalSpacer(16);
        }
        result.append("<td>");
        result.append("<img name=\"img");
        result.append(locKey);
        result.append("\" id=\"img");
        result.append(locKey);
        result.append("\" src=\"");
        result.append(OpenCms.getLinkManager().substituteLink(cms, "/system/workplace/resources/commons/help.png"));
        result.append("\" alt=\"\" border=\"0\"");
        if (widgetDialog.useNewStyle()) {
            result.append(this.getJsHelpMouseHandler(widgetDialog, locKey, null));
        } else {
            result.append(this.getJsHelpMouseHandler(widgetDialog, locKey, CmsEncoder.escape(locValue, cms.getRequestContext().getEncoding())));
        }
        result.append("></td>");
        return result.toString();
    }

    @Override
    public String getHelpText(I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String helpId = this.getDisabledHelpKey(param);
        Set<String> helpIdsShown = widgetDialog.getHelpMessageIds();
        if (helpIdsShown.contains(helpId)) {
            return "";
        }
        helpIdsShown.add(helpId);
        String locValue = widgetDialog.getMessages().key(helpId, true);
        if (locValue == null) {
            return "";
        }
        if (widgetDialog.useNewStyle()) {
            StringBuffer result = new StringBuffer(128);
            result.append("<div class=\"help\" id=\"help");
            result.append(helpId);
            result.append("\"");
            result.append(this.getJsHelpMouseHandler(widgetDialog, helpId, helpId));
            result.append(">");
            result.append(locValue);
            result.append("</div>\n");
            return result.toString();
        }
        return "";
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsLocationPickerWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsLocationPickerWidget(this.getConfiguration());
    }

    private String getDisabledHelpKey(I_CmsWidgetParameter param) {
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(param.getKey());
        result.append(".help");
        result.append(DISABLED_POSTFIX);
        return result.toString();
    }
}

