/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsVfsFileWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    public static final String CONFIGURATION_EXCLUDEFILES = "excludefiles";
    public static final String CONFIGURATION_GALLERYSELECT = "galleryselect";
    public static final String CONFIGURATION_HIDESITESELECTOR = "hidesiteselector";
    public static final String CONFIGURATION_INCLUDEFILES = "includefiles";
    public static final String CONFIGURATION_NOTPROJECTAWARE = "notprojectaware";
    public static final String CONFIGURATION_PROJECTAWARE = "projectaware";
    public static final String CONFIGURATION_SEARCHTYPES = "searchtypes";
    public static final String CONFIGURATION_SELECTABLETYPES = "selectabletypes";
    public static final String CONFIGURATION_SHOWSITESELECTOR = "showsiteselector";
    public static final String CONFIGURATION_STARTFOLDER = "startfolder";
    public static final String CONFIGURATION_STARTSITE = "startsite";
    public static final String DEFAULT_SEARCH_TYPES_MACRO = "defaultSearchTypes";
    private static final Log LOG = CmsLog.getLog(CmsVfsFileWidget.class);
    private boolean m_gallerySelect;
    private boolean m_includeFiles;
    private boolean m_projectAware;
    private String m_searchTypes;
    private String m_selectableTypes;
    private boolean m_showSiteSelector;
    private String m_startFolder;
    private String m_startSite;

    public CmsVfsFileWidget() {
        this("");
    }

    public CmsVfsFileWidget(boolean showSiteSelector, String startSite) {
        this(showSiteSelector, startSite, true);
    }

    public CmsVfsFileWidget(boolean showSiteSelector, String startSite, boolean includeFiles) {
        this(showSiteSelector, startSite, includeFiles, true);
    }

    public CmsVfsFileWidget(boolean showSiteSelector, String startSite, boolean includeFiles, boolean projectAware) {
        this.m_showSiteSelector = showSiteSelector;
        this.m_startSite = startSite;
        this.m_includeFiles = includeFiles;
        this.m_projectAware = projectAware;
    }

    public CmsVfsFileWidget(String configuration) {
        super(configuration);
    }

    public static String getDefaultSearchTypes(CmsObject cms, CmsResource resource) {
        StringBuffer result = new StringBuffer();
        String referenceSitePath = cms.getSitePath(resource);
        String configPath = resource == null ? cms.addSiteRoot(cms.getRequestContext().getUri()) : resource.getRootPath();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, configPath);
        Set<String> detailPageTypes = OpenCms.getADEManager().getDetailPageTypes(cms);
        for (CmsResourceTypeConfig typeConfig : config.getResourceTypes()) {
            String typeName = typeConfig.getTypeName();
            if (!detailPageTypes.contains(typeName) || !typeConfig.checkViewable(cms, referenceSitePath)) continue;
            result.append(typeName).append(",");
        }
        result.append(CmsResourceTypeXmlContainerPage.getStaticTypeName()).append(",");
        result.append(CmsResourceTypeBinary.getStaticTypeName()).append(",");
        result.append(CmsResourceTypeImage.getStaticTypeName()).append(",");
        result.append(CmsResourceTypePlain.getStaticTypeName());
        return result.toString();
    }

    @Override
    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_showSiteSelector) {
            result.append(CONFIGURATION_SHOWSITESELECTOR);
        } else {
            result.append(CONFIGURATION_HIDESITESELECTOR);
        }
        if (this.m_startSite != null) {
            result.append("|");
            result.append(CONFIGURATION_STARTSITE);
            result.append("=");
            result.append(this.m_startSite);
        }
        result.append("|");
        if (this.m_includeFiles) {
            result.append(CONFIGURATION_INCLUDEFILES);
        } else {
            result.append(CONFIGURATION_EXCLUDEFILES);
        }
        if (this.m_gallerySelect) {
            result.append("|");
            result.append(CONFIGURATION_GALLERYSELECT);
        }
        result.append("|");
        if (this.m_projectAware) {
            result.append(CONFIGURATION_PROJECTAWARE);
        } else {
            result.append(CONFIGURATION_NOTPROJECTAWARE);
        }
        if (this.m_searchTypes != null) {
            result.append("|");
            result.append(CONFIGURATION_SEARCHTYPES);
            result.append("=");
            result.append(this.m_searchTypes);
        }
        if (this.m_selectableTypes != null) {
            result.append("|");
            result.append(CONFIGURATION_SELECTABLETYPES);
            result.append("=");
            result.append(this.m_selectableTypes);
        }
        return result.toString();
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        JSONObject config = this.getJsonConfig(cms, schemaType, messages, resource, contentLocale);
        return config.toString();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.wide;
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "commons/tree.js"));
        result.append("\n");
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/fileselector.js"));
        return result.toString();
    }

    @Override
    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "\tinitVfsFileSelector();\n";
    }

    @Override
    public String getDialogInitMethod(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append("function initVfsFileSelector() {\n");
        result.append("\tinitResources(\"");
        result.append(OpenCms.getWorkplaceManager().getEncoding());
        result.append("\", \"");
        result.append("/system/workplace/");
        result.append("\", \"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("\", \"");
        result.append(OpenCms.getSystemInfo().getOpenCmsContext());
        result.append("\");\n");
        result.append("}\n");
        return result.toString();
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(128);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\"><tr><td style=\"width: 100%;\">");
        result.append("<input style=\"width: 99%;\" class=\"xmlInput");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" value=\"");
        result.append(param.getStringValue(cms));
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"></td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        StringBuffer buttonJs = new StringBuffer(8);
        buttonJs.append("javascript:openTreeWin('EDITOR',  '");
        buttonJs.append(id);
        buttonJs.append("', document, ");
        buttonJs.append(this.m_showSiteSelector);
        buttonJs.append(", '");
        if (this.m_startSite != null) {
            buttonJs.append(this.m_startSite);
        } else {
            buttonJs.append(cms.getRequestContext().getSiteRoot());
        }
        buttonJs.append("', ");
        buttonJs.append(this.m_includeFiles);
        buttonJs.append(", ");
        buttonJs.append(this.m_projectAware);
        buttonJs.append(");return false;");
        result.append(widgetDialog.button(buttonJs.toString(), null, "folder", "GUI_DIALOG_BUTTON_SEARCH_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table>");
        result.append("</td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    public String getStartSite() {
        return this.m_startSite;
    }

    @Override
    public String getWidgetName() {
        return CmsVfsFileWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    public boolean isShowingSiteSelector() {
        return this.m_showSiteSelector;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsVfsFileWidget(this.getConfiguration());
    }

    @Override
    public void setConfiguration(String configuration) {
        this.m_showSiteSelector = true;
        this.m_includeFiles = true;
        this.m_projectAware = true;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int startFolderIndex;
            int selectableTypesIndex;
            int searchTypesIndex;
            int siteIndex;
            if (configuration.contains(CONFIGURATION_HIDESITESELECTOR)) {
                this.m_showSiteSelector = false;
            }
            if ((siteIndex = configuration.indexOf(CONFIGURATION_STARTSITE)) != -1) {
                String site = configuration.substring(siteIndex + CONFIGURATION_STARTSITE.length() + 1);
                if (site.indexOf(124) != -1) {
                    site = site.substring(0, site.indexOf(124));
                }
                this.m_startSite = site;
            }
            if (configuration.contains(CONFIGURATION_EXCLUDEFILES)) {
                this.m_includeFiles = false;
            }
            if (configuration.contains(CONFIGURATION_GALLERYSELECT)) {
                this.m_gallerySelect = true;
            }
            if (configuration.contains(CONFIGURATION_NOTPROJECTAWARE)) {
                this.m_projectAware = false;
            }
            if ((searchTypesIndex = configuration.indexOf(CONFIGURATION_SEARCHTYPES)) != -1) {
                String searchTypes = configuration.substring(searchTypesIndex + CONFIGURATION_SEARCHTYPES.length() + 1);
                this.m_searchTypes = searchTypes.contains("|") ? searchTypes.substring(0, searchTypes.indexOf("|")) : searchTypes;
            }
            if ((selectableTypesIndex = configuration.indexOf(CONFIGURATION_SELECTABLETYPES)) != -1) {
                String selectableTypes = configuration.substring(selectableTypesIndex + CONFIGURATION_SELECTABLETYPES.length() + 1);
                this.m_selectableTypes = selectableTypes.contains("|") ? selectableTypes.substring(0, selectableTypes.indexOf("|")) : selectableTypes;
            }
            if ((startFolderIndex = configuration.indexOf(CONFIGURATION_STARTFOLDER)) != -1) {
                String startFolder = configuration.substring(startFolderIndex + CONFIGURATION_STARTFOLDER.length() + 1);
                this.m_startFolder = startFolder.contains("|") ? startFolder.substring(0, startFolder.indexOf("|")) : startFolder;
            }
        }
        super.setConfiguration(configuration);
    }

    protected JSONObject getJsonConfig(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        JSONObject config = new JSONObject();
        try {
            config.put(CONFIGURATION_STARTSITE, this.m_startSite);
            config.put(CONFIGURATION_SHOWSITESELECTOR, this.m_showSiteSelector);
            config.put("resource", cms.getSitePath(resource));
            config.put("locale", contentLocale.toString());
            config.put("gallerymode", I_CmsGalleryProviderConstants.GalleryMode.widget.name());
            config.put("galleryprefix", "linkselect");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_selectableTypes)) {
                config.put("resourcetypes", this.m_selectableTypes.trim());
            }
            String tabConfig = null;
            boolean bl = this.m_includeFiles = this.m_includeFiles && (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_selectableTypes) || !this.isOnlyFolders(this.m_selectableTypes.trim()));
            if (this.m_includeFiles) {
                tabConfig = "selectAll";
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_selectableTypes) && !Arrays.asList(this.m_selectableTypes.split("[, ]+")).contains(CmsResourceTypeXmlContainerPage.getStaticTypeName())) {
                    tabConfig = "selectAllNoSitemap";
                }
            } else {
                tabConfig = "folders";
            }
            config.put("tabconfig", tabConfig);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_searchTypes)) {
                CmsMacroResolver resolver = CmsMacroResolver.newInstance();
                resolver.addDynamicMacro(DEFAULT_SEARCH_TYPES_MACRO, new SearchTypesFactory(cms, resource));
                String searchTypes = resolver.resolveMacros(this.m_searchTypes.trim());
                config.put(CONFIGURATION_SEARCHTYPES, searchTypes);
            } else if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_selectableTypes)) {
                config.put(CONFIGURATION_SEARCHTYPES, CmsVfsFileWidget.getDefaultSearchTypes(cms, resource));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_startFolder)) {
                config.put(CONFIGURATION_STARTFOLDER, this.m_startFolder);
            }
            String treeToken = "" + Objects.hashCode((Object[])new Object[]{this.m_startSite, cms.getRequestContext().getSiteRoot(), "" + this.m_selectableTypes});
            config.put("treeToken", treeToken);
            if (this.m_gallerySelect) {
                config.put("galleriesSelectable", "true");
                config.put("resultsSelectable", "false");
                config.put("tabconfig", "galleries");
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return config;
    }

    protected String getTreeToken(CmsObject cms, A_CmsXmlContentValue value, CmsResource resource, Locale contentLocale) {
        return cms.getRequestContext().getSiteRoot();
    }

    private boolean isOnlyFolders(String types) {
        boolean result = true;
        for (String type : types.split("[, ]+")) {
            try {
                if (OpenCms.getResourceManager().getResourceType(type).isFolder()) continue;
                result = false;
                break;
            }
            catch (CmsLoaderException cmsLoaderException) {
                // empty catch block
            }
        }
        return result;
    }

    protected class SearchTypesFactory
    implements Factory {
        private CmsObject m_cms;
        private CmsResource m_resource;

        public SearchTypesFactory(CmsObject cms, CmsResource resource) {
            this.m_cms = cms;
            this.m_resource = resource;
        }

        public Object create() {
            return CmsVfsFileWidget.getDefaultSearchTypes(this.m_cms, this.m_resource);
        }
    }
}

