/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanYearlyWeekday
extends A_CmsSerialDateBean {
    private I_CmsSerialDateValue.WeekOfMonth m_weekOfMonth;
    private I_CmsSerialDateValue.Month m_month;
    private I_CmsSerialDateValue.WeekDay m_weekDay;

    public CmsSerialDateBeanYearlyWeekday(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions, I_CmsSerialDateValue.WeekOfMonth weekOfMonth, I_CmsSerialDateValue.Month month, I_CmsSerialDateValue.WeekDay weekDay) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
        this.m_weekOfMonth = weekOfMonth;
        this.m_month = month;
        this.m_weekDay = weekDay;
    }

    @Override
    protected Calendar getFirstDate() {
        Calendar date = (Calendar)this.getStartDate().clone();
        int month = date.get(2);
        Calendar firstPossibleMatch = (Calendar)date.clone();
        this.setFittingWeekDay(firstPossibleMatch);
        if (month > this.m_month.ordinal() || month == this.m_month.ordinal() && date.getTimeInMillis() > firstPossibleMatch.getTimeInMillis()) {
            date.set(2, 0);
            date.set(5, 1);
            date.add(1, 1);
        }
        date.set(2, this.m_month.ordinal());
        this.setFittingWeekDay(date);
        return date;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return true;
    }

    @Override
    protected void toNextDate(Calendar date) {
        date.set(5, 1);
        date.add(1, 1);
        this.setFittingWeekDay(date);
    }

    private void setFittingWeekDay(Calendar date) {
        date.set(5, 1);
        int weekDayFirst = date.get(7);
        int firstFittingWeekDay = (this.m_weekDay.toInt() + 7 - weekDayFirst) % 7 + 1;
        int fittingWeekDay = firstFittingWeekDay + 7 * this.m_weekOfMonth.ordinal();
        if (fittingWeekDay > date.getActualMaximum(5)) {
            fittingWeekDay -= 7;
        }
        date.set(5, fittingWeekDay);
    }
}

