/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.tools.CmsToolUserData;

public class CmsWorkplaceSettings {
    private static final Log LOG = CmsLog.getLog(CmsWorkplaceSettings.class);
    private I_CmsResourceCollector m_collector;
    private String m_currentSite;
    private Object m_dialogObject;
    private CmsMessageContainer m_errorMessage;
    private String m_explorerFlaturl;
    private String m_explorerMode;
    private int m_explorerPage = 1;
    private String m_explorerProjectFilter;
    private CmsUUID m_explorerProjectId;
    private Map<String, String> m_explorerResource = new HashMap<String, String>();
    private Map<String, String> m_frameUris;
    private String m_galleryType;
    private I_CmsGalleryProviderConstants.SortParams m_lastGalleryResultOrder;
    private Map<String, String> m_lastUsedGalleries;
    private Object m_listObject;
    private String m_permissionDetailView;
    private CmsUUID m_project;
    private CmsPublishList m_publishList;
    private CmsGallerySearchScope m_scope;
    private CmsToolUserData m_toolUserData;
    private Map<String, String> m_treeSite;
    private Map<String, String> m_treeType = new HashMap<String, String>();
    private CmsUser m_user;
    private boolean m_userAgreementAccepted;
    private CmsUserSettings m_userSettings;
    private String m_viewStartup;
    private String m_viewUri;

    CmsWorkplaceSettings() {
        this.m_treeSite = new HashMap<String, String>();
        this.m_frameUris = new HashMap<String, String>();
        this.m_lastUsedGalleries = new HashMap<String, String>();
        this.m_currentSite = OpenCms.getSiteManager().getDefaultSite().getSiteRoot();
    }

    public I_CmsResourceCollector getCollector() {
        return this.m_collector;
    }

    public Object getDialogObject() {
        return this.m_dialogObject;
    }

    public CmsMessageContainer getErrorMessage() {
        return this.m_errorMessage;
    }

    public String getExplorerFlaturl() {
        return this.m_explorerFlaturl;
    }

    public String getExplorerMode() {
        return this.m_explorerMode;
    }

    public int getExplorerPage() {
        return this.m_explorerPage;
    }

    public String getExplorerProjectFilter() {
        return this.m_explorerProjectFilter;
    }

    public CmsUUID getExplorerProjectId() {
        return this.m_explorerProjectId;
    }

    public String getExplorerResource() {
        String resource;
        String mode = this.getExplorerMode();
        if (mode == null) {
            mode = "explorerview";
        }
        if ("explorerview".equals(mode)) {
            mode = mode + "_" + this.getSite() + "/";
        }
        if ((resource = this.m_explorerResource.get(mode)) == null) {
            resource = "/";
        }
        return resource;
    }

    public Map<String, String> getFrameUris() {
        return this.m_frameUris;
    }

    public String getGalleryType() {
        return this.m_galleryType;
    }

    public I_CmsGalleryProviderConstants.SortParams getLastGalleryResultOrder() {
        if (this.m_lastGalleryResultOrder == null) {
            return I_CmsGalleryProviderConstants.SortParams.dateLastModified_desc;
        }
        return this.m_lastGalleryResultOrder;
    }

    public CmsGallerySearchScope getLastSearchScope() {
        if (this.m_scope == null) {
            return OpenCms.getWorkplaceManager().getGalleryDefaultScope();
        }
        return this.m_scope;
    }

    public String getLastUsedGallery(String galleryKey) {
        String result = this.m_lastUsedGalleries.get(galleryKey);
        LOG.info((Object)("user=" + this.m_user.getName() + ": getLastUsedGallery " + galleryKey + " : returning " + result));
        return result;
    }

    public Object getListObject() {
        return this.m_listObject;
    }

    public String getPermissionDetailView() {
        return this.m_permissionDetailView;
    }

    public CmsUUID getProject() {
        return this.m_project;
    }

    public CmsPublishList getPublishList() {
        return this.m_publishList;
    }

    public String getSite() {
        return this.m_currentSite;
    }

    public CmsToolUserData getToolUserData() {
        return this.m_toolUserData;
    }

    public String getTreeResource(String type) {
        String result = this.m_treeType.get(type);
        if (result == null) {
            result = "/";
        }
        return result;
    }

    public String getTreeSite(String type) {
        String result = this.m_treeSite.get(type);
        return result;
    }

    public CmsUser getUser() {
        return this.m_user;
    }

    public CmsUserSettings getUserSettings() {
        return this.m_userSettings;
    }

    public String getViewStartup() {
        return this.m_viewStartup;
    }

    public String getViewUri() {
        return this.m_viewUri;
    }

    public boolean isUserAgreementAccepted() {
        return this.m_userAgreementAccepted;
    }

    public boolean isViewExplorer() {
        return this.getViewUri().endsWith("/system/workplace/views/explorer/explorer_files.jsp");
    }

    public void setCollector(I_CmsResourceCollector collector) {
        this.m_collector = collector;
    }

    public void setDialogObject(Object dialogObject) {
        this.m_dialogObject = dialogObject;
    }

    public void setErrorMessage(CmsMessageContainer errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public void setExplorerFlaturl(String value) {
        this.m_explorerFlaturl = value;
    }

    public void setExplorerMode(String value) {
        this.m_explorerMode = value;
    }

    public void setExplorerPage(int page) {
        this.m_explorerPage = page;
    }

    public void setExplorerProjectFilter(String value) {
        this.m_explorerProjectFilter = value;
    }

    public void setExplorerProjectId(CmsUUID value) {
        this.m_explorerProjectId = value;
    }

    @Deprecated
    public void setExplorerResource(String value) {
        this.setExplorerResource(value, null);
    }

    public void setExplorerResource(String value, CmsObject cms) {
        if (value == null) {
            return;
        }
        String mode = this.getExplorerMode();
        if (mode == null) {
            mode = "explorerview";
        }
        if ("explorerview".equals(mode)) {
            mode = mode + "_" + this.getSite() + "/";
        }
        if (value.startsWith("/system/") && !value.startsWith(this.m_currentSite) && !"galleryview".equals(this.getExplorerMode())) {
            this.m_explorerResource.put(mode, "/");
        } else {
            if (cms != null) {
                try {
                    CmsResource resource = cms.readResource(value);
                    value = cms.getSitePath(resource);
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            this.m_explorerResource.put(mode, value);
        }
    }

    public void setGalleryType(String currentGallery) {
        this.m_galleryType = currentGallery;
    }

    public void setLastGalleryResultOrder(I_CmsGalleryProviderConstants.SortParams order) {
        this.m_lastGalleryResultOrder = order;
    }

    public void setLastSearchScope(CmsGallerySearchScope scope) {
        this.m_scope = scope;
    }

    public void setLastUsedGallery(String galleryKey, String gallerypath) {
        this.m_lastUsedGalleries.put(galleryKey, gallerypath);
        LOG.info((Object)("user=" + this.m_user.getName() + ": setLastUsedGallery " + galleryKey + " -> " + gallerypath));
    }

    public void setListObject(Object listObject) {
        this.m_listObject = listObject;
    }

    public void setPermissionDetailView(String value) {
        this.m_permissionDetailView = value;
    }

    public void setProject(CmsUUID project) {
        this.m_project = project;
    }

    public void setPublishList(CmsPublishList publishList) {
        this.m_publishList = publishList;
    }

    public void setSite(String value) {
        if (value != null && !value.equals(this.m_currentSite)) {
            this.m_currentSite = value;
            this.m_treeType = new HashMap<String, String>();
        }
    }

    public void setToolUserData(CmsToolUserData toolUserData) {
        this.m_toolUserData = toolUserData;
    }

    public void setTreeResource(String type, String value) {
        if (value == null) {
            return;
        }
        if (value.startsWith("/system/") && !value.startsWith(this.m_currentSite)) {
            value = "/";
        }
        this.m_treeType.put(type, value);
    }

    public void setTreeSite(String type, String value) {
        if (value == null) {
            return;
        }
        this.m_treeSite.put(type, value);
    }

    public void setUser(CmsUser user) {
        this.m_user = user;
    }

    public void setUserAgreementAccepted(boolean userAgreementAccepted) {
        this.m_userAgreementAccepted = userAgreementAccepted;
    }

    public void setUserSettings(CmsUserSettings userSettings) {
        this.m_userSettings = userSettings;
    }

    public void setViewStartup(String viewStartup) {
        this.m_viewStartup = viewStartup;
    }

    public void setViewUri(String string) {
        this.m_viewUri = string;
    }
}

